/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.netimesyn_u2kv1r7c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.netimesyn_u2kv1r7c00.TENESynFileMgr;
import com.huawei.nglct.nemgr.marine.netimesyn_u2kv1r7c00.TENESynTimeData;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class TENESynTimeQueryBean
extends TENEExplorerBean {
    private static final String prostatus_yes = "1";
    private static final String STANDARD_NTP_SYN_MODE = "3";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TENESynTimeData synTimeData;
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        int len = operationList.size();
        for (int t = 0; t < len; ++t) {
            tempOperationList.add(((Operation)operationList.get(t)).clone());
        }
        Datainterface tempOutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, tempOperationList);
        if (null == tempOutputData) {
            return;
        }
        BussinessParams bParams = tempOutputData.getBussinessParams();
        if (null == bParams || bParams.getRowParamsCount() == 0) {
            return;
        }
        String ntpidenable = "";
        try {
            Operation op = (Operation)operationList.get(3);
            ntpidenable = op.getOutput(0).getPart(0).getValue();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESynTimeQueryBean.handleMessage() fail!", (Throwable)e);
        }
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(tempOutputData.getErrorMessage());
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().addRowParams(new RowParams());
        RowParams outPutRowparams = this.outputData.getBussinessParams().getRowParams(0);
        RowParams[] tempRParams = bParams.getRowParams();
        outPutRowparams.setRowErrors(tempRParams[tempRParams.length - 1].getRowErrors());
        outPutRowparams.addParam("sychronmode", "");
        outPutRowparams.addParam("necurrtime", "");
        if (ntpidenable == null) {
            ntpidenable = "";
        }
        Param ntpidenableParam = new Param();
        ntpidenableParam.setName("ntpidenable");
        ntpidenableParam.setValue(ntpidenable);
        outPutRowparams.addParam(ntpidenableParam);
        long nmTime = new GregorianCalendar().getTimeInMillis();
        outPutRowparams.addParam("nmtime", String.valueOf(nmTime));
        if (bParams.getRowParams(0).getParam("neid") != null) {
            Param neparam = new Param();
            TENE ne = TENEListMgr.getInstance().getNE(this.neid);
            neparam.setName("neid");
            neparam.setValue(String.valueOf(ne.getRealNEID()));
            outPutRowparams.addParam(neparam);
            outPutRowparams.addParam(bParams.getRowParams(0).getParam("nename"));
        }
        if ((synTimeData = TENESynFileMgr.getNeSynTimeInfo(neid)) == null) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
        } else {
            outPutRowparams.getParam("sychronmode").setValue(synTimeData.getSynMode());
            outPutRowparams.addParam("synstarttime", synTimeData.getSynStartDate());
            outPutRowparams.addParam("aoutsyncycle", synTimeData.getAutoSynCycle());
        }
        try {
            String neYear = "";
            String neMonth = "";
            String neDay = "";
            String neHour = "";
            String neMinute = "";
            String neSecond = "";
            String syncMode = "";
            int size = operationList.size();
            for (int j = 0; j < size; ++j) {
                Operation operation = (Operation)operationList.get(j);
                if (operation.getName().equals("NSCMD_CFG_GET_DATE")) {
                    neYear = operation.getOutput(0).getPartValue("neyear");
                    neMonth = operation.getOutput(0).getPartValue("nemonth");
                    neDay = operation.getOutput(0).getPartValue("neday");
                }
                if (operation.getName().equals("NSCMD_CFG_GET_TIME")) {
                    neHour = operation.getOutput(0).getPartValue("nehour");
                    neMinute = operation.getOutput(0).getPartValue("neminute");
                    neSecond = operation.getOutput(0).getPartValue("nesecond");
                }
                if (!operation.getName().equals("NSCMD_NEWNTP_GET_STATUS")) continue;
                syncMode = operation.getOutput(0).getPartValue("ntpStatus");
            }
            if (prostatus_yes.equals(syncMode)) {
                outPutRowparams.getParam("sychronmode").setValue(STANDARD_NTP_SYN_MODE);
            } else if (!outPutRowparams.getParam("sychronmode").getValue().equals("2")) {
                outPutRowparams.getParam("sychronmode").setValue("0");
            }
            long time = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getNECurrentTime(Integer.parseInt(neYear), Integer.parseInt(neMonth), Integer.parseInt(neDay), Integer.parseInt(neHour), Integer.parseInt(neMinute), Integer.parseInt(neSecond));
            outPutRowparams.getParam("necurrtime").setValue(String.valueOf(time));
        }
        catch (Exception e) {
            outPutRowparams.getParam("necurrtime").setValue("");
            TELogFactory.getNormalLogger().error("necurrtime error:\n", (Throwable)e);
        }
    }
}

