/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.netimesyn;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.nemgr.marine.netimesyn.TENESynFileMgr;
import com.huawei.nglct.nemgr.marine.netimesyn.TENESynTimeData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class TENESynTimeQueryBean
extends TENEExplorerCommonForLogBean {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private TEResourceUtil res = null;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TENESynTimeData synTimeData;
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        int len = operationList.size();
        for (int t = 0; t < len; ++t) {
            tempOperationList.add(((Operation)operationList.get(t)).clone());
        }
        Datainterface tempOutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, tempOperationList);
        if (null == tempOutputData) {
            return;
        }
        BussinessParams bParams = tempOutputData.getBussinessParams();
        if (null == bParams || bParams.getRowParamsCount() == 0) {
            return;
        }
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(tempOutputData.getErrorMessage());
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().addRowParams(new RowParams());
        RowParams outPutRowparams = this.outputData.getBussinessParams().getRowParams(0);
        RowParams[] tempRParams = bParams.getRowParams();
        outPutRowparams.setRowErrors(tempRParams[tempRParams.length - 1].getRowErrors());
        outPutRowparams.addParam("sychronmode", "");
        outPutRowparams.addParam("necurrtime", "");
        long nmTime = new GregorianCalendar().getTimeInMillis();
        outPutRowparams.addParam("nmtime", String.valueOf(nmTime));
        if (bParams.getRowParams(0).getParam("neid") != null) {
            int phyNeId = TENECommMgr.getInstance().getNEID((long)neid);
            bParams.getRowParams(0).getParam("neid").setValue(String.valueOf(phyNeId));
            outPutRowparams.addParam(bParams.getRowParams(0).getParam("neid"));
            outPutRowparams.addParam(bParams.getRowParams(0).getParam("nename"));
        }
        if ((synTimeData = TENESynFileMgr.getNeSynTimeInfo(neid)) == null) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)3843));
        } else {
            outPutRowparams.getParam("sychronmode").setValue(synTimeData.getSynMode());
            outPutRowparams.addParam("synstarttime", synTimeData.getSynStartDate());
            outPutRowparams.addParam("aoutsyncycle", synTimeData.getAutoSynCycle());
        }
        try {
            String neYear = "";
            String neMonth = "";
            String neDay = "";
            String neHour = "";
            String neMinute = "";
            String neSecond = "";
            int size = operationList.size();
            for (int j = 0; j < size; ++j) {
                Operation oper = (Operation)operationList.get(j);
                if (oper.getName().equals("NSCMD_CFG_GET_DATE")) {
                    neYear = oper.getOutput(0).getPartValue("neyear");
                    neMonth = oper.getOutput(0).getPartValue("nemonth");
                    neDay = oper.getOutput(0).getPartValue("neday");
                }
                if (!oper.getName().equals("NSCMD_CFG_GET_TIME")) continue;
                neHour = oper.getOutput(0).getPartValue("nehour");
                neMinute = oper.getOutput(0).getPartValue("neminute");
                neSecond = oper.getOutput(0).getPartValue("nesecond");
            }
            long time = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getNECurrentTime(Integer.parseInt(neYear), Integer.parseInt(neMonth), Integer.parseInt(neDay), Integer.parseInt(neHour), Integer.parseInt(neMinute), Integer.parseInt(neSecond));
            outPutRowparams.getParam("necurrtime").setValue(String.valueOf(time));
        }
        catch (Exception e) {
            outPutRowparams.getParam("necurrtime").setValue("");
        }
    }

    @Override
    protected String descToString(Datainterface inputData) {
        return this.addProtectionToString(inputData);
    }

    private String addProtectionToString(Datainterface inputData) {
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        String neName = this.mgr.getNE(neId).getNEName();
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("netimesyn").append(File.separator).append("netimesynlog_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        strBuf.append(this.res.getString("NEname")).append(":").append(neName).append("  ");
        strBuf.append(this.res.getString("quaryNETime"));
        return strBuf.toString();
    }
}

