/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00.TESLMCommunicateCheckMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESLMSetRefreshTypeBean
extends TENEExplorerBean {
    private static final int ERROR_CODE_LINE_NOT_EXSIT = 42781;
    private Logger normalLogger = TELogFactory.getNormalLogger();
    private int srcNEID = 0;
    private int sinkNEID = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.user = user;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            if (null == inputData) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            int count = rowParams.length;
            if (0 == count) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                this.srcNEID = Integer.parseInt(inputData.getBussinessParams().getRowParams(i).getParam("srcNEID").getValue());
                this.sinkNEID = Integer.parseInt(inputData.getBussinessParams().getRowParams(i).getParam("sinkNEID").getValue());
                if (0 != this.srcNEID) {
                    this.sendCurNEMessage(this.srcNEID, subFunc, true, i);
                }
                if (0 == this.sinkNEID) continue;
                this.sendCurNEMessage(this.sinkNEID, subFunc, false, i);
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int sendCurNEMessage(int neid, SubFunc subFunc, boolean isSource, int index) {
        int result;
        ArrayList operList = this.getModifyOperation(neid, isSource, this.inputData, index);
        this.normalLogger.info("sendCurNEMessage start, and the current neid is -> " + neid);
        if (operList == null || operList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            result = this.sendMessage(neid, operList);
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neid, result, operList);
        }
        result = this.sendModifyRefreshMessage(neid, this.inputData, index);
        if (0 != result) {
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neid, neid, TENEListMgr.getInstance().getNE(neid).getNEName(), result);
        }
        if (0 != (result = this.sendModifyCommCheckMessage(neid, isSource, this.inputData, index))) {
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neid, neid, TENEListMgr.getInstance().getNE(neid).getNEName(), result);
        }
        this.normalLogger.info("sendCurNEMessage end, and the result is -> " + result);
        return result;
    }

    private int sendModifyRefreshMessage(int neid, Datainterface inputData, int index) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(index);
        String lineIDStr = rowParams.getParam("lineID").getValue();
        if (null == lineIDStr || "".equals(lineIDStr)) {
            return 42781;
        }
        String refreshTypeStr = rowParams.getParam("refreshType").getValue();
        if (null == refreshTypeStr || "".equals(refreshTypeStr)) {
            return 42781;
        }
        int lineID = Integer.parseInt(lineIDStr);
        byte refreshType = Byte.parseByte(refreshTypeStr);
        boolean ret = TESLMRefreshTypeMgr.getInstance().refreshType(neid, lineID, refreshType);
        if (!ret) {
            return 42781;
        }
        return 0;
    }

    private int sendModifyCommCheckMessage(int neid, boolean isSource, Datainterface inputData, int index) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(index);
        String lineIDStr = rowParams.getParam("lineID").getValue();
        if (null == lineIDStr || "".equals(lineIDStr)) {
            return 42781;
        }
        String commCheckStr = null;
        if (isSource && null != rowParams.getParam("srcCommunicateCheck")) {
            commCheckStr = rowParams.getParam("srcCommunicateCheck").getValue();
        }
        if (!isSource && null != rowParams.getParam("sinkCommunicateCheck")) {
            commCheckStr = rowParams.getParam("sinkCommunicateCheck").getValue();
        }
        if (null == commCheckStr || "".equals(commCheckStr)) {
            return 0;
        }
        int lineID = Integer.parseInt(lineIDStr);
        byte commCheck = Byte.parseByte(commCheckStr);
        boolean ret = TESLMCommunicateCheckMgr.getInstance().refreshData(neid, lineID, commCheck);
        if (!ret) {
            return 42781;
        }
        return 0;
    }

    public ArrayList getModifyOperation(int neid, boolean isSource, Datainterface inputData, int index) {
        ArrayList<Operation> optList = new ArrayList<Operation>();
        RowParams rowParams = inputData.getBussinessParams().getRowParams(index);
        String filterStatus = null;
        if (isSource && null != rowParams.getParam("srcFilterStatus")) {
            filterStatus = rowParams.getParam("srcFilterStatus").getValue();
        }
        if (!isSource && null != rowParams.getParam("sinkFilterStatus")) {
            filterStatus = rowParams.getParam("sinkFilterStatus").getValue();
        }
        if (null == filterStatus) {
            return optList;
        }
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            Operation operation = definitions.getOperation("NSCMD_SLM_SET_SMOOTHFILTER");
            Input input = operation.getInput();
            input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
            input.setPartValue("filterStatus", filterStatus);
            optList.add(operation);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        return optList;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuilder filePath = new StringBuilder();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor_u2kv1r3c00").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)filePath.toString());
        StringBuilder detailStr = new StringBuilder();
        detailStr.append(res.getString("LINE_ID")).append(rowparams.getParam("lineID").getValue());
        detailStr.append(',');
        if (null != rowparams.getParam("refreshType")) {
            String refreshType = res.getString("refreshType_" + rowparams.getParam("refreshType").getValue());
            detailStr.append(res.getString("refreshType")).append(refreshType);
            detailStr.append(',');
        }
        if (null != rowparams.getParam("srcFilterStatus")) {
            String srcFilterStatus = res.getString("FilterStatus_" + rowparams.getParam("srcFilterStatus").getValue());
            detailStr.append(res.getString("FilterStatus")).append(srcFilterStatus);
            detailStr.append(',');
        }
        if (null != rowparams.getParam("srcCommunicateCheck")) {
            String srcCommunicateCheck = res.getString("CommunicateCheck_" + rowparams.getParam("srcCommunicateCheck").getValue());
            detailStr.append(res.getString("CommunicateCheck")).append(srcCommunicateCheck);
            detailStr.append(',');
        }
        return detailStr.toString();
    }
}

