/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00;

import com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00.TESLMCommunicateCheckInfo;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TESLMCommunicateCheckMgr {
    private static final byte CHECK_START = 1;
    private static final byte CHECK_STOP = 0;
    private List<TESLMCommunicateCheckInfo> checkList = new ArrayList<TESLMCommunicateCheckInfo>();
    private static final TESLMCommunicateCheckMgr instance = new TESLMCommunicateCheckMgr();

    private TESLMCommunicateCheckMgr() {
    }

    public static TESLMCommunicateCheckMgr getInstance() {
        return instance;
    }

    public boolean containsLine(int neID, int lineID) {
        if (0 >= neID || 0 >= lineID) {
            return false;
        }
        return this.containsData(new TESLMCommunicateCheckInfo(neID, lineID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsData(TESLMCommunicateCheckInfo checkInfo) {
        List<TESLMCommunicateCheckInfo> list = this.checkList;
        synchronized (list) {
            if (null == checkInfo) {
                return false;
            }
            return this.checkList.contains(checkInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(int neID, int lineID, int communicateCheck) {
        List<TESLMCommunicateCheckInfo> list = this.checkList;
        synchronized (list) {
            if (0 >= neID || 0 > lineID) {
                return;
            }
            TESLMCommunicateCheckInfo tmpInfo = new TESLMCommunicateCheckInfo(neID, lineID, communicateCheck);
            if (this.containsData(tmpInfo)) {
                TESLMCommunicateCheckInfo refreshInfo = this.getRefreshInfo(neID, lineID);
                refreshInfo.setCommunicateCheck(communicateCheck);
            }
            this.checkList.add(tmpInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delData(int neID, int lineID) {
        List<TESLMCommunicateCheckInfo> list = this.checkList;
        synchronized (list) {
            if (0 >= neID || 0 > lineID) {
                return false;
            }
            TESLMCommunicateCheckInfo tmpInfo = new TESLMCommunicateCheckInfo(neID, lineID);
            if (!this.checkList.contains(tmpInfo)) {
                return false;
            }
            return this.checkList.remove(tmpInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshData(int neID, int lineID, int communicateCheck) {
        List<TESLMCommunicateCheckInfo> list = this.checkList;
        synchronized (list) {
            if (0 >= neID || 0 > lineID) {
                return false;
            }
            TESLMCommunicateCheckInfo tmpInfo = new TESLMCommunicateCheckInfo(neID, lineID, communicateCheck);
            if (!this.containsData(tmpInfo)) {
                return false;
            }
            TESLMCommunicateCheckInfo refreshInfo = this.getRefreshInfo(neID, lineID);
            refreshInfo.setCommunicateCheck(communicateCheck);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCommunicateCheck(int neID, int lineID) {
        List<TESLMCommunicateCheckInfo> list = this.checkList;
        synchronized (list) {
            if (0 >= neID || 0 >= lineID) {
                return -1;
            }
            TESLMCommunicateCheckInfo tmpInfo = new TESLMCommunicateCheckInfo(neID, lineID);
            for (TESLMCommunicateCheckInfo refreshInfo : this.checkList) {
                if (!refreshInfo.equals(tmpInfo)) continue;
                return refreshInfo.getCommunicateCheck();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTypeData(int neID, TIntArrayList list) {
        List<TESLMCommunicateCheckInfo> list2 = this.checkList;
        synchronized (list2) {
            if (null == list || 0 >= neID) {
                return;
            }
            if (list.isEmpty()) {
                this.checkList.clear();
                return;
            }
            Iterator<TESLMCommunicateCheckInfo> iterator = this.checkList.iterator();
            while (iterator.hasNext()) {
                int lineID;
                TESLMCommunicateCheckInfo tmpInto = iterator.next();
                if (neID != tmpInto.getNeID() || list.contains(lineID = tmpInto.getLineID())) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TESLMCommunicateCheckInfo getRefreshInfo(int neID, int lineID) {
        List<TESLMCommunicateCheckInfo> list = this.checkList;
        synchronized (list) {
            if (0 >= neID || 0 >= lineID) {
                return null;
            }
            TESLMCommunicateCheckInfo tmpInfo = new TESLMCommunicateCheckInfo(neID, lineID);
            for (TESLMCommunicateCheckInfo checkInfo : this.checkList) {
                if (!checkInfo.equals(tmpInfo)) continue;
                return checkInfo;
            }
            return null;
        }
    }

    public List<TESLMCommunicateCheckInfo> getCommunicateCheckInfoList() {
        return this.checkList;
    }
}

