/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.marine.common.TESLMLineGencfgBean;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.linemonitor.TELineRefreshInfo;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.linedata.TESLMLineState;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.slf4j.Logger;

public class TERefreshLineStatus
extends TESLMLineGencfgBean {
    private static final Logger LOG = TELogFactory.getNormalLogger();
    private Logger normalLogger = TELogFactory.getNormalLogger();
    private int srcNEID = 0;
    private int sinkNEID = 0;

    @Override
    public void operationNE() {
        int len = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            this.srcNEID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(i).getParam("srcNEID").getValue());
            this.sinkNEID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(i).getParam("sinkNEID").getValue());
            if (0 != this.srcNEID) {
                this.sendCurNEMessage(this.srcNEID, this.subfunc, true, i);
            }
            if (0 == this.sinkNEID) continue;
            this.sendCurNEMessage(this.sinkNEID, this.subfunc, false, i);
        }
    }

    private int sendCurNEMessage(int neid, SubFunc subFunc, boolean isSource, int index) {
        ArrayList operList = this.getQueryOperation(neid, this.inputData, index);
        if (operList == null || operList.isEmpty()) {
            return 0;
        }
        this.normalLogger.info("sendCurNEMessage start, and the current neid is -> " + neid);
        int result = this.sendMessage(neid, operList);
        if (result == 0) {
            this.handleMessage(neid, operList, subFunc, this.getFilterErrorCodeList(), isSource);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            String objName = TENEListMgr.getInstance().getNE(neid).getNEName();
            TESLMLineUtil.setErrorMessageInfo(this.outputData, this.neid, neid, objName, result);
        }
        this.normalLogger.info("sendCurNEMessage end, and the result is -> " + result);
        return result;
    }

    public ArrayList getQueryOperation(int neid, Datainterface inputData, int index) {
        ArrayList<Operation> optList = new ArrayList<Operation>();
        RowParams rowParams = inputData.getBussinessParams().getRowParams(index);
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            Operation operation = definitions.getOperation("NSCMD_SLM_GET_LINESTATE");
            Input input = operation.getInput();
            input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
            optList.add(operation);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        return optList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList, boolean isSource) {
        Operation tmpOper = null;
        Output output = null;
        int code = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            int size = tmpOper.getOutputCount();
            for (int j = 0; j < size; ++j) {
                output = tmpOper.getOutput(j);
                code = Integer.parseInt(output.getFault(0).getCode());
                if (0 != code) continue;
                RowParams rowparams = TESLMLineUtil.getOutputRowParams(this.outputData, output);
                int lineID = Integer.valueOf(output.getPart("lineID").getValue());
                rowparams.addParam("lineID", String.valueOf(lineID));
                this.appendTestState(neid, output, isSource, rowparams);
                this.refreshTestState(neid, output, isSource, rowparams);
                TESLMLineUtil.addRowParamsData(this.outputData, rowparams);
            }
        }
    }

    private void appendTestState(int neid, Output output, boolean isSource, RowParams rowparams) {
        this.appendTestStateInfo(neid, output, isSource, rowparams);
        this.appendTestTimeInfo(neid, output, isSource, rowparams);
    }

    private void refreshTestState(int neid, Output output, boolean isSource, RowParams rowparams) {
        this.refreshLineState(neid, output, isSource, rowparams);
        this.handleStateInfo(neid, output, isSource, rowparams);
    }

    private void refreshLineState(int neID, Output output, boolean isSource, RowParams rowparams) {
        int lineID = Integer.parseInt(output.getPartValue("lineID"));
        int testMode = Integer.parseInt(output.getPartValue("testMode"));
        int testType = Integer.parseInt(output.getPartValue("testType"));
        int currentWorkStatus = Integer.parseInt(output.getPartValue("currentWorkStatus"));
        this.refreshLineState(neID, lineID, testMode, testType, currentWorkStatus);
    }

    private void appendTestStateInfo(int neid, Output output, boolean isSource, RowParams rowparams) {
        int testMode = Integer.parseInt(output.getPartValue("testMode"));
        int testType = Integer.parseInt(output.getPartValue("testType"));
        int currentWorkStatus = Integer.parseInt(output.getPartValue("currentWorkStatus"));
        int abortErrorCode = Integer.parseInt(output.getPartValue("abortErrorCode"));
        String abortReason = TENEListUtils.getString((String)("OTDR_STOP_ABNORMAL_EVENT_" + abortErrorCode));
        if (isSource) {
            String[] paramNames = new String[]{"srcTestStatus", "srcTestMode", "srcTestType", "srcAbortErrorCode", "srcAbortReason"};
            this.addPartToOutput(output, paramNames[0], String.valueOf(currentWorkStatus), rowparams);
            this.addPartToOutput(output, paramNames[1], String.valueOf(testMode), rowparams);
            this.addPartToOutput(output, paramNames[2], String.valueOf(testType), rowparams);
            this.addPartToOutput(output, paramNames[3], String.valueOf(abortErrorCode), rowparams);
            this.addPartToOutput(output, paramNames[4], String.valueOf(abortReason), rowparams);
        } else {
            String[] paramNames = new String[]{"sinkTestStatus", "sinkTestMode", "sinkTestType", "sinkAbortErrorCode", "sinkAbortReason"};
            this.addPartToOutput(output, paramNames[0], String.valueOf(currentWorkStatus), rowparams);
            this.addPartToOutput(output, paramNames[1], String.valueOf(testMode), rowparams);
            this.addPartToOutput(output, paramNames[2], String.valueOf(testType), rowparams);
            this.addPartToOutput(output, paramNames[3], String.valueOf(abortErrorCode), rowparams);
            this.addPartToOutput(output, paramNames[4], String.valueOf(abortReason), rowparams);
        }
    }

    private void appendTestTimeInfo(int neid, Output output, boolean isSource, RowParams rowparams) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        String stringValue2 = output.getPart("startYear").getValue().trim();
        int startYear = Integer.parseInt(stringValue2);
        int currentWorkStatus = Integer.parseInt(output.getPartValue("currentWorkStatus"));
        if (this.isNETimeValid(currentWorkStatus, startYear += timezonebean.nebaseyear)) {
            if (isSource) {
                String[] paramNames = new String[]{"srcStartTime", "srcRemainingTime", "srcTestProgress"};
                this.addPartToOutput(output, paramNames[0], "-", rowparams);
                this.addPartToOutput(output, paramNames[1], "-", rowparams);
                this.addPartToOutput(output, paramNames[2], "-", rowparams);
            } else {
                String[] paramNames = new String[]{"sinkStartTime", "sinkRemainingTime", "sinkTestProgress"};
                this.addPartToOutput(output, paramNames[0], "-", rowparams);
                this.addPartToOutput(output, paramNames[1], "-", rowparams);
                this.addPartToOutput(output, paramNames[2], "-", rowparams);
            }
        } else {
            String srcTestProgress;
            stringValue2 = output.getPart("startMonth").getValue().trim();
            int startMonth = Integer.parseInt(stringValue2);
            stringValue2 = output.getPart("startDay").getValue().trim();
            int startDay = Integer.parseInt(stringValue2);
            stringValue2 = output.getPart("startHour").getValue().trim();
            int startHour = Integer.parseInt(stringValue2);
            stringValue2 = output.getPart("startMinute").getValue().trim();
            int startMinute = Integer.parseInt(stringValue2);
            stringValue2 = output.getPart("startSecond").getValue().trim();
            int startSecond = Integer.parseInt(stringValue2);
            String startTime = this.convertToServerTime(startYear, startMonth, startDay, startHour, startMinute, startSecond);
            String remainTime = output.getPartValue("remainTime");
            if ((remainTime = remainTime.trim()).equals("0")) {
                remainTime = "-";
            }
            if ((srcTestProgress = output.getPartValue("progress")).equals("0")) {
                srcTestProgress = "-";
            }
            if (isSource) {
                String[] paramNames = new String[]{"srcStartTime", "srcRemainingTime", "srcTestProgress"};
                this.addPartToOutput(output, paramNames[0], startTime, rowparams);
                this.addPartToOutput(output, paramNames[1], remainTime, rowparams);
                this.addPartToOutput(output, paramNames[2], srcTestProgress, rowparams);
            } else {
                String[] paramNames = new String[]{"sinkStartTime", "sinkRemainingTime", "sinkTestProgress"};
                this.addPartToOutput(output, paramNames[0], startTime, rowparams);
                this.addPartToOutput(output, paramNames[1], remainTime, rowparams);
                this.addPartToOutput(output, paramNames[2], srcTestProgress, rowparams);
            }
        }
    }

    private boolean isNETimeValid(int currentWorkStatus, int startYear) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
        boolean isValid = currentWorkStatus != 2 || startYear == 48 + timezonebean.nebaseyear || startYear == timezonebean.nebaseyear;
        return isValid;
    }

    private String convertToServerTime(int startYear, int startMonth, int startDay, int startHour, int startMinute, int startSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(startYear, startMonth - 1, startDay, startHour, startMinute, startSecond);
        SimpleDateFormat formatter = new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH);
        LOG.info("Refresh Line Status Convert To Applet Time. calendar: " + formatter.format(calendar.getTime()));
        String startTime = TESLMOTDRDataMgr.convertCalendarToServerTime(calendar, this.neid);
        LOG.info("Refresh Line Status Convert To Applet Time. startTime: " + startTime);
        return startTime;
    }

    private TESLMLineState refreshLineState(int neid, int lineID, int testMode, int testType, int currentWorkStatus) {
        TESLMLineState state = TESLMOTDRDataMgr.getLineState(neid, lineID);
        state.setTestMode(testMode);
        state.setTestType(testType);
        state.setTestState(currentWorkStatus);
        TESLMOTDRDataMgr.refreshLineState(neid, lineID, state);
        state = TESLMOTDRDataMgr.getLineState(neid, lineID);
        return state;
    }

    private void addPartToOutput(Output output, String partName, String partValue, RowParams rowparams) {
        rowparams.addParam(partName, partValue);
    }

    public void handleStateInfo(int neID, Output output, boolean isSource, RowParams rowparams) {
        byte refreshType;
        int INVALID_REFRESH_TYPE = -1;
        int lineID = Integer.parseInt(output.getPartValue("lineID"));
        if (0 <= lineID && -1 != (refreshType = TESLMRefreshTypeMgr.getInstance().getRefreshType(this.neid, lineID))) {
            this.updateLineRefreshInfo(neID, lineID, refreshType, output);
        }
    }

    private void updateLineRefreshInfo(int neID, int lineID, byte refreshType, Output output) {
        if (null == output) {
            return;
        }
        int testType = Integer.parseInt(output.getPart("testType").getValue());
        int currentWorkStatus1 = Integer.parseInt(output.getPart("currentWorkStatus").getValue());
        TELineRefreshInfo refreshInfo = TESLMRefreshTypeMgr.getInstance().getRefreshInfo(neID, lineID);
        if (1 == refreshType) {
            if (2 == currentWorkStatus1) {
                TESLMRefreshTypeMgr.getInstance().refreshType(neID, lineID, refreshType);
                refreshInfo.setRefreshStatus(2);
            } else if (1 == currentWorkStatus1) {
                TESLMRefreshTypeMgr.getInstance().stopTimer(neID, lineID);
            }
            if (3 == testType && 3 == currentWorkStatus1 && null != refreshInfo) {
                refreshInfo.waitingTestStatus();
            }
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

