/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class TEGetTestParamIS
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static final int NSCMD_SLM_GET_OTDRPWRRANG = 30226;
    private static final String OUT_OF_SER_TEST_MODE = "2";
    private static final String MIN_THR_POWER_VALUE = "-100";
    private static final String MAX_THR_POWER_VALUE = "175";
    private String testMode = "";
    private static final int NSCMD_SLM_GET_FIBERPARA = 30411;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList list = super.getOperation(neid, subFunc, inputData, memeryData);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Operation operation = (Operation)iter.next();
            if (30226 != operation.getCmdid()) continue;
            Input input = operation.getInput();
            Part part = input.getPart("testMode");
            this.testMode = part.getValue();
            if (!OUT_OF_SER_TEST_MODE.equals(part.getValue())) continue;
            iter.remove();
            break;
        }
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        double partOfFormula = this.getPartOfFormula(operationList);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (this.outputData != null && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
                RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
                if (!this.getParamValue(rowParams, "inSerThrMax", true)) {
                    TELogFactory.getNormalLogger().info("Marine: modify optical power.");
                    continue;
                }
                if (!this.getParamValue(rowParams, "inSerThrMin", true)) {
                    TELogFactory.getNormalLogger().info("Marine: modify optical power.");
                    continue;
                }
                this.getParamValue(rowParams, "lmiPower", false);
                rowParams.addParam("partOfFormula", String.valueOf(partOfFormula));
            }
        }
    }

    protected double getPartOfFormula(ArrayList operationList) {
        double partOfFormula = 0.0;
        Operation tmpOper = null;
        int cmdID = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            if (30411 != cmdID) continue;
            Output output = null;
            int code = 0;
            int size = tmpOper.getOutputCount();
            for (int j = 0; j < size; ++j) {
                output = tmpOper.getOutput(j);
                code = Integer.parseInt(output.getFault(0).getCode());
                if (0 != code) continue;
                double fefractiveIndex = (double)Integer.parseInt(output.getPart("refractiveRate").getValue()) * 0.001;
                int fiberLen = Integer.parseInt(output.getPart("fiberLength").getValue()) * 100;
                partOfFormula += (double)fiberLen * fefractiveIndex;
            }
        }
        return partOfFormula;
    }

    protected boolean getParamValue(RowParams rowParams, String name, boolean isThrValue) {
        Param param1 = rowParams.getParam(name);
        if (null == param1) {
            return false;
        }
        if (isThrValue && OUT_OF_SER_TEST_MODE.equals(this.testMode)) {
            return this.thrOutOfSerValueHandler(rowParams, name);
        }
        String stringValue = param1.getValue();
        if (null == stringValue || stringValue.length() <= 0) {
            return false;
        }
        int signedValue = new BigInteger(stringValue).intValue();
        param1.setValue(String.valueOf(signedValue));
        return true;
    }

    private boolean thrOutOfSerValueHandler(RowParams rowParams, String name) {
        if (null == name || "".equals(name)) {
            return false;
        }
        String strValue1 = "inSerThrMin".equals(name) ? MIN_THR_POWER_VALUE : MAX_THR_POWER_VALUE;
        Param param = rowParams.getParam(name);
        int signedValue = new BigInteger(strValue1).intValue();
        param.setValue(String.valueOf(signedValue));
        return true;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor_u2kv1r3c00").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer sbBuffer = new StringBuffer();
        Param[] params = rowparams.getParam();
        if (0 == params.length) {
            sbBuffer.append(this.res.getString("get_test_param"));
            return sbBuffer.toString();
        }
        String lineID = Datainterface.getParam((Param[])params, (String)"lineID").getValue();
        sbBuffer.append(this.res.getString("lineID")).append(": ").append(lineID);
        return sbBuffer.toString();
    }
}

