/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.common.TESLMLineGencfgBean;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.common.TESLMSinkNEStruct;
import com.huawei.nglct.nemgr.marine.linemonitor.TELineRefreshInfo;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00.TESLMCommunicateCheckMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;

public class TEGetLineStatus
extends TESLMLineGencfgBean {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TESLMSinkNEStruct> sinkNEList = new ArrayList<TESLMSinkNEStruct>();
    private TESLMSinkNEStruct sinkNEStuct = null;
    public static final int NSCMD_SLM_R2_RTRV_LINE = 30440;
    private static final int POSITIVE_LINE_DIRECTION = 1;
    private static final int NSCMD_SLM_GET_LINESTATE = 30402;
    private static final int NSCMD_SLM_GET_LINEMEMO = 30405;
    private static final int NSCMD_SLM_GET_LINE_WAVELEN = 30449;
    private static final byte DEFAULT_REFRESH_TYPE = 1;
    private static final int BDTYPE_TNB2LMU = 1628;
    private static final int BDTYPE_TNB2LMI = 1630;
    private static final int DEFAULT_VALUE = 0;
    private static final String UNKNOWN = "UNKNOWN";
    public static final int NSERR_MARINE_LINE_NOT_CONSISTANT = 1090615103;
    private ArrayList<Integer> neLst = new ArrayList();
    private ArrayList<Set<Integer>> lineIDSetLst = new ArrayList();

    @Override
    public void operationNE() {
        int result = this.sendCurNEMessage();
        if (0 == result) {
            this.sendOtherNEListMessage();
            this.setErrorLineNotConsistant();
        }
        this.refreshLineData();
    }

    private void setErrorLineNotConsistant() {
        ArrayList rowParamsList = this.outputData.getBussinessParams().getRowParamList();
        for (RowParams rowParams : rowParamsList) {
            Param param = rowParams.getParam("srcSaveSinkNEID");
            if (null == param || "0".equals(param.getValue())) {
                param = rowParams.getParam("sinkSaveSrcNEID");
            }
            if (null == param || "0".equals(param.getValue())) continue;
            int logicNEID = TENECommMgr.getInstance().getLogicNEID(Integer.parseInt(param.getValue()));
            TESLMLineUtil.setRowErrorLineNotConsistant(this.outputData, this.neid, logicNEID, rowParams, rowParams.getParam("srcLmuNeId"), rowParams.getParam("sinkLmuNeId"));
        }
    }

    private int sendCurNEMessage() {
        normalLogger.info("sendCurNEMessage start, and the current neid is -> " + this.neid);
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.handleMessage(this.neid, this.operationList, this.getFilterErrorCodeList());
            TESLMLineUtil.setErrorMessageInfoList(this.outputData, this.neid, this.operationList);
        } else {
            TESLMLineUtil.setErrorMessageInfoList(this.outputData, this.neid, this.operationList);
            ErrorMessage bigErr = this.outputData.getErrorMessage();
            if (bigErr.getErrorcode().equals(String.valueOf(0))) {
                TESLMLineUtil.setErrorMessageInfo(this.outputData, this.neid, 2, result);
            }
        }
        normalLogger.info("sendCurNEMessage end, and the result is -> " + result);
        return result;
    }

    public void handleMessage(int neid, ArrayList operationList, ArrayList filterErrorCodeList) {
        int i;
        Operation tmpOper = null;
        int cmdID = 0;
        HashSet<Integer> lineIDSet = new HashSet<Integer>();
        int len = operationList.size();
        for (i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            if (30440 != cmdID) continue;
            this.handleLineInfo(neid, tmpOper, lineIDSet);
        }
        len = operationList.size();
        for (i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            if (30405 == cmdID) {
                this.handleLineMemo(neid, tmpOper);
            }
            if (30449 == cmdID) {
                this.handleWaveLenInfo(neid, tmpOper);
            }
            if (30402 != cmdID) continue;
            this.handleLineStateInfo(neid, tmpOper);
        }
        this.neLst.add(neid);
        this.lineIDSetLst.add(lineIDSet);
    }

    public ArrayList getQuerySmoothFilterOperation(int neid, int lineID) {
        ArrayList<Operation> optList = new ArrayList<Operation>();
        if (0 == lineID) {
            return optList;
        }
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            Operation operation = definitions.getOperation("NSCMD_SLM_GET_SMOOTHFILTER");
            Input input = operation.getInput();
            input.setPartValue("lineID", String.valueOf(lineID));
            optList.add(operation);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        return optList;
    }

    private void handleLineInfo(int neid, Operation oper, Set<Integer> lineIDSet) {
        Output output = null;
        int code = 0;
        int size = oper.getOutputCount();
        for (int j = 0; j < size; ++j) {
            String[] paramNames;
            output = oper.getOutput(j);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code) continue;
            RowParams rowparams = TESLMLineUtil.getOutputRowParams(this.outputData, output);
            int lineID = Integer.valueOf(output.getPart("lineID").getValue());
            rowparams.addParam("lineID", String.valueOf(lineID));
            if (!lineIDSet.contains(lineID)) {
                lineIDSet.add(lineID);
            }
            int lineDirection = Integer.parseInt(output.getPartValue("lineDirection"));
            if (neid != this.neid) {
                int srcLineDirection = this.getLineDirection(output, rowparams);
                if (srcLineDirection == lineDirection) {
                    lineDirection = 1 == srcLineDirection ? 0 : 1;
                }
            } else {
                rowparams.addParam("lineDirection", String.valueOf(lineDirection));
            }
            if (1 == lineDirection) {
                paramNames = new String[]{"srcLmuFullName", "srcLmuNeName", "srcLmuNeId", "srcLmuSlotId", "srcLmuPortId", "srcLmiFullName", "srcLmiNeName", "srcLmiNeId", "srcLmiSlotId", "srcLmiPortId"};
                this.appendLineData(neid, output, paramNames, rowparams);
                this.addPartToOutput(output, "srcLineDirection", lineDirection, rowparams);
                this.addPartToOutput(output, "srcSaveSinkNEID", output.getPartValue("opNeID").trim(), rowparams);
                this.addPartToOutput(output, "srcSaveSinkLmiSlot", output.getPartValue("opLmiSlot").trim(), rowparams);
                int sinkneid = Integer.valueOf(output.getPart("opNeID").getValue());
                if (0 == sinkneid) {
                    this.addPartToOutput(output, "srcSaveSinkNEIDInfo", sinkneid, rowparams);
                } else {
                    TENE sinkNE = TENEListMgr.getInstance().getPhyNE(sinkneid);
                    if (null == sinkNE) {
                        this.addPartToOutput(output, "srcSaveSinkNEIDInfo", "0", rowparams);
                    } else {
                        this.addPartToOutput(output, "srcSaveSinkNEIDInfo", sinkNE.getNEID(), rowparams);
                    }
                }
            } else {
                paramNames = new String[]{"sinkLmuFullName", "sinkLmuNeName", "sinkLmuNeId", "sinkLmuSlotId", "sinkLmuPortId", "sinkLmiFullName", "sinkLmiNeName", "sinkLmiNeId", "sinkLmiSlotId", "sinkLmiPortId"};
                this.appendLineData(neid, output, paramNames, rowparams);
                this.addPartToOutput(output, "sinkLineDirection", lineDirection, rowparams);
                this.addPartToOutput(output, "sinkSaveSrcNEID", output.getPartValue("opNeID").trim(), rowparams);
                this.addPartToOutput(output, "sinkSaveSrcLmiSlot", output.getPartValue("opLmiSlot").trim(), rowparams);
                int srcneid = Integer.valueOf(output.getPart("opNeID").getValue());
                if (0 == srcneid) {
                    this.addPartToOutput(output, "sinkSaveSrcNEIDInfo", srcneid, rowparams);
                } else {
                    TENE srcNE = TENEListMgr.getInstance().getPhyNE(srcneid);
                    if (null == srcNE) {
                        this.addPartToOutput(output, "sinkSaveSrcNEIDInfo", "0", rowparams);
                    } else {
                        this.addPartToOutput(output, "sinkSaveSrcNEIDInfo", srcNE.getNEID(), rowparams);
                    }
                }
            }
            byte refreshType = TESLMRefreshTypeMgr.getInstance().getRefreshType(neid, lineID);
            if (-1 == refreshType) {
                TESLMRefreshTypeMgr.getInstance().addData(neid, lineID, (byte)1);
                refreshType = 1;
            }
            this.addPartToOutput(output, "refreshType", String.valueOf(refreshType), rowparams);
            int commCheck = TESLMCommunicateCheckMgr.getInstance().getCommunicateCheck(neid, lineID);
            if (-1 == commCheck) {
                TESLMCommunicateCheckMgr.getInstance().addData(neid, lineID, 1);
                commCheck = 1;
            }
            if (1 == lineDirection) {
                this.addPartToOutput(output, "srcCommunicateCheck", String.valueOf(commCheck), rowparams);
            } else {
                this.addPartToOutput(output, "sinkCommunicateCheck", String.valueOf(commCheck), rowparams);
            }
            int smoothFilter = 1;
            ArrayList operList = this.getQuerySmoothFilterOperation(neid, lineID);
            int result = this.sendMessage(neid, operList);
            if (result == 0) {
                Operation opt = (Operation)operList.get(0);
                Output output1 = opt.getOutput(0);
                if (null != output1 && null != output1.getPart("filterStatus") && null != output1.getPart("filterStatus").getValue()) {
                    smoothFilter = Integer.valueOf(output1.getPart("filterStatus").getValue());
                }
                TESLMLineUtil.setErrorMessageInfoList(this.outputData, neid, operList);
            } else {
                TESLMLineUtil.setErrorMessageInfoList(this.outputData, neid, operList);
            }
            if (1 == lineDirection) {
                this.addPartToOutput(output, "srcFilterStatus", String.valueOf(smoothFilter), rowparams);
            } else {
                this.addPartToOutput(output, "sinkFilterStatus", String.valueOf(smoothFilter), rowparams);
            }
            if (neid == this.neid) {
                int srcLmineid = this.neid;
                int srcLmiSlotId = Integer.valueOf(output.getPart("lmiSlot").getValue());
                int sinkLmineid = Integer.valueOf(output.getPart("opNeID").getValue());
                int sinkLmiSlotId = Integer.valueOf(output.getPart("opLmiSlot").getValue());
                TESLMSinkNEStruct sinkNEStruct = new TESLMSinkNEStruct(lineID, srcLmineid, srcLmiSlotId, sinkLmineid, sinkLmiSlotId, lineDirection);
                this.sinkNEList.add(sinkNEStruct);
            }
            if (neid != this.neid) {
                boolean isSame = true;
                int opNeID = Integer.parseInt(output.getPart("opNeID").getValue());
                int lmiSoltID = Integer.parseInt(output.getPart("lmiSlot").getValue());
                int opLmiSlot = Integer.parseInt(output.getPart("opLmiSlot").getValue());
                int opLogicNEID = TENECommMgr.getInstance().getLogicNEID(opNeID);
                int direction = Integer.parseInt(output.getPart("lineDirection").getValue());
                if (this.sinkNEStuct.getSrcNEID() != opLogicNEID || this.sinkNEStuct.getSrcLMISlotID() != opLmiSlot || this.sinkNEStuct.getSinkLMISlotID() != lmiSoltID || this.sinkNEStuct.getDirection() == direction) {
                    isSame = false;
                }
                this.addPartToOutput(output, "isSame", String.valueOf(isSame), rowparams);
                if (!isSame) {
                    String objName = TENEListMgr.getInstance().getNE(neid).getNEName() + "-" + lineID;
                    TESLMLineUtil.setErrorMessageInfo(this.outputData, this.neid, neid, objName, 1090615103);
                }
            }
            TESLMLineUtil.addRowParamsData(this.outputData, rowparams);
        }
    }

    public int getLineDirection(Output output, RowParams rowparams) {
        int lineDirection = 0;
        Param dirParam = rowparams.getParam("lineDirection");
        if (null != dirParam) {
            try {
                lineDirection = Integer.parseInt(dirParam.getValue());
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getLineDirection fail!", (Throwable)e);
            }
        }
        return lineDirection;
    }

    private void appendLineData(int neid, Output output, String[] paramNames, RowParams rowparams) {
        this.appendLmuData(neid, output, paramNames, rowparams);
        this.appendLmiData(neid, output, paramNames, rowparams);
    }

    private void appendLmuData(int neid, Output output, String[] paramNames, RowParams rowparams) {
        int lmuNeId = neid;
        TENE lmuNe = TEConfigurationDataMgr.getInstance().getNE(lmuNeId);
        int lmuSlotId = Integer.parseInt(output.getPart("lmuSlot").getValue());
        int lmuPortId = 1;
        String lmuNeName = UNKNOWN;
        String lmuBoardName = UNKNOWN;
        String lmuPortName = UNKNOWN;
        int lmuBoardType = 1628;
        if (null != lmuNe) {
            lmuNeName = lmuNe.getNEName();
            lmuBoardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(lmuNe.getNEID(), 1628);
            lmuPortName = TEConfigurationDataMgr.getInstance().getPortName(lmuNeId, lmuSlotId, lmuBoardType, lmuPortId);
        }
        String lmuFullName = lmuNeName + "-" + lmuSlotId + "-" + lmuBoardName + "-" + lmuPortName;
        this.addPartToOutput(output, paramNames[0], lmuFullName, rowparams);
        this.addPartToOutput(output, paramNames[1], lmuNeName, rowparams);
        this.addHiddenLMUInfo(output, lmuNeId, lmuSlotId, lmuPortId, paramNames, rowparams);
    }

    private void appendLmiData(int neid, Output output, String[] paramNames, RowParams rowparams) {
        int lmiSlotId = Integer.parseInt(output.getPart("lmiSlot").getValue());
        int lmiPortId = 2;
        TENE lmiNe = TENEListMgr.getInstance().getNE(neid);
        int lmiNeId = 0;
        if (null != lmiNe) {
            lmiNeId = lmiNe.getRealNEID();
        }
        String lmiNeName = UNKNOWN;
        String lmiBoardName = UNKNOWN;
        String lmiPortName = UNKNOWN;
        if (null != lmiNe) {
            lmiNeName = lmiNe.getNEName();
            lmiBoardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(lmiNe.getNEID(), 1630);
            lmiPortName = String.valueOf(TEConfigurationDataMgr.getInstance().getPortName(lmiNe.getNEID(), lmiSlotId, 1630, lmiPortId));
        }
        String lmiFullName = lmiNeName + "-" + lmiSlotId + "-" + lmiBoardName + "-" + lmiPortName;
        this.addPartToOutput(output, paramNames[5], lmiFullName, rowparams);
        this.addPartToOutput(output, paramNames[6], lmiNeName, rowparams);
        this.addHiddenLMIInfo(output, lmiNeId, lmiSlotId, lmiPortId, paramNames, rowparams);
    }

    private void addHiddenLMUInfo(Output output, int lmuNeId, int lmuSlotId, int lmuPortId, String[] paramNames, RowParams rowparams) {
        this.addPartToOutput(output, paramNames[2], lmuNeId, rowparams);
        this.addPartToOutput(output, paramNames[3], lmuSlotId, rowparams);
        this.addPartToOutput(output, paramNames[4], lmuPortId, rowparams);
    }

    private void addHiddenLMIInfo(Output output, int lmiNeId, int lmiSlotId, int lmiPortId, String[] paramNames, RowParams rowparams) {
        this.addPartToOutput(output, paramNames[7], lmiNeId, rowparams);
        this.addPartToOutput(output, paramNames[8], lmiSlotId, rowparams);
        this.addPartToOutput(output, paramNames[9], lmiPortId, rowparams);
    }

    private void addPartToOutput(Output output, String partName, String partValue, RowParams rowparams) {
        rowparams.addParam(partName, partValue);
    }

    private void addPartToOutput(Output output, String partName, int partValue, RowParams rowparams) {
        rowparams.addParam(partName, String.valueOf(partValue));
    }

    private void handleLineMemo(int neid, Operation oper) {
        Output output = null;
        int code = 0;
        int size = oper.getOutputCount();
        for (int j = 0; j < size; ++j) {
            output = oper.getOutput(j);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code) continue;
            RowParams rowparams = TESLMLineUtil.getOutputRowParams(this.outputData, output);
            this.addPartToOutput(output, "lineRemark", output.getPartValue("lineRemark").trim(), rowparams);
        }
    }

    private void handleWaveLenInfo(int neid, Operation oper) {
        Output output = null;
        int code = 0;
        int size = oper.getOutputCount();
        for (int j = 0; j < size; ++j) {
            String[] paramNames;
            output = oper.getOutput(j);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code) continue;
            RowParams rowparams = TESLMLineUtil.getOutputRowParams(this.outputData, output);
            int lineDirection = this.getLineDirection(output, rowparams);
            if (neid != this.neid) {
                lineDirection = 1 == lineDirection ? 0 : 1;
            }
            if (1 == lineDirection) {
                paramNames = new String[]{"srcProbeWaveBand", "srcProbeWaveIndex", "srcLoadingWaveBand", "srcLoadingWaveIndex"};
                this.addPartToOutput(output, paramNames[0], output.getPartValue("probeWaveBand").trim(), rowparams);
                this.addPartToOutput(output, paramNames[1], output.getPartValue("probeWaveIndex").trim(), rowparams);
                this.addPartToOutput(output, paramNames[2], output.getPartValue("loadingWaveBand").trim(), rowparams);
                this.addPartToOutput(output, paramNames[3], output.getPartValue("loadingWaveIndex").trim(), rowparams);
                continue;
            }
            paramNames = new String[]{"sinkProbeWaveBand", "sinkProbeWaveIndex", "sinkLoadingWaveBand", "sinkLoadingWaveIndex"};
            this.addPartToOutput(output, paramNames[0], output.getPartValue("probeWaveBand").trim(), rowparams);
            this.addPartToOutput(output, paramNames[1], output.getPartValue("probeWaveIndex").trim(), rowparams);
            this.addPartToOutput(output, paramNames[2], output.getPartValue("loadingWaveBand").trim(), rowparams);
            this.addPartToOutput(output, paramNames[3], output.getPartValue("loadingWaveIndex").trim(), rowparams);
        }
    }

    private void handleLineStateInfo(int neid, Operation oper) {
        Output output = null;
        int code = 0;
        int size = oper.getOutputCount();
        for (int j = 0; j < size; ++j) {
            String[] paramNames;
            output = oper.getOutput(j);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code) continue;
            byte refreshType = -1;
            RowParams rowparams = TESLMLineUtil.getOutputRowParams(this.outputData, output);
            int lineID = Integer.valueOf(output.getPart("lineID").getValue());
            if (0 >= lineID || -1 == (refreshType = (byte)TESLMRefreshTypeMgr.getInstance().getRefreshType(neid, lineID))) continue;
            this.updateLineRefreshInfo(neid, lineID, refreshType, output);
            int lineDirection = this.getLineDirection(output, rowparams);
            if (neid != this.neid) {
                lineDirection = 1 == lineDirection ? 0 : 1;
            }
            if (1 == lineDirection) {
                this.addPartToOutput(output, "srcTestMode", output.getPartValue("testMode").trim(), rowparams);
                this.addPartToOutput(output, "srcTestType", output.getPartValue("testType").trim(), rowparams);
                this.addPartToOutput(output, "srcTestStatus", output.getPartValue("currentWorkStatus").trim(), rowparams);
                paramNames = new String[]{"srcStartTime", "srcRemainingTime", "srcTestProgress"};
                this.addSrcTestTimeInfo(output, paramNames, rowparams);
                this.addPartToOutput(output, "srcAbortErrorCode", output.getPartValue("abortErrorCode").trim(), rowparams);
                continue;
            }
            this.addPartToOutput(output, "sinkTestMode", output.getPartValue("testMode").trim(), rowparams);
            this.addPartToOutput(output, "sinkTestType", output.getPartValue("testType").trim(), rowparams);
            this.addPartToOutput(output, "sinkTestStatus", output.getPartValue("currentWorkStatus").trim(), rowparams);
            paramNames = new String[]{"sinkStartTime", "sinkRemainingTime", "sinkTestProgress"};
            this.addSrcTestTimeInfo(output, paramNames, rowparams);
            this.addPartToOutput(output, "sinkAbortErrorCode", output.getPartValue("abortErrorCode").trim(), rowparams);
        }
    }

    private void addSrcTestTimeInfo(Output output, String[] paramNames, RowParams rowparams) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
        String stringValue1 = output.getPart("startYear").getValue().trim();
        int startYear = Integer.parseInt(stringValue1);
        int currentWorkStatus = Integer.parseInt(output.getPartValue("currentWorkStatus"));
        if (this.isNETimeValid(currentWorkStatus, startYear += timezonebean.nebaseyear)) {
            this.addPartToOutput(output, paramNames[0], "-", rowparams);
            this.addPartToOutput(output, paramNames[1], "-", rowparams);
            this.addPartToOutput(output, paramNames[2], "-", rowparams);
        } else {
            String srcTestProgress1;
            stringValue1 = output.getPart("startMonth").getValue().trim();
            int startMonth = Integer.parseInt(stringValue1);
            stringValue1 = output.getPart("startDay").getValue().trim();
            int startDay = Integer.parseInt(stringValue1);
            stringValue1 = output.getPart("startHour").getValue().trim();
            int startHour = Integer.parseInt(stringValue1);
            stringValue1 = output.getPart("startMinute").getValue().trim();
            int startMinute = Integer.parseInt(stringValue1);
            stringValue1 = output.getPart("startSecond").getValue().trim();
            int startSecond = Integer.parseInt(stringValue1);
            String startTime1 = this.convertToServerTime(startYear, startMonth, startDay, startHour, startMinute, startSecond);
            String remainTime1 = output.getPartValue("remainTime");
            if ((remainTime1 = remainTime1.trim()).equals("0")) {
                remainTime1 = "-";
            }
            if ((srcTestProgress1 = output.getPartValue("progress")).equals("0")) {
                srcTestProgress1 = "-";
            }
            this.addPartToOutput(output, paramNames[0], startTime1, rowparams);
            this.addPartToOutput(output, paramNames[1], remainTime1, rowparams);
            this.addPartToOutput(output, paramNames[2], srcTestProgress1, rowparams);
        }
    }

    private String convertToServerTime(int startYear, int startMonth, int startDay, int startHour, int startMinute, int startSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(startYear, startMonth - 1, startDay, startHour, startMinute, startSecond);
        SimpleDateFormat formatter = new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH);
        normalLogger.info("Refresh Line Status Convert To Applet Time. calendar: " + formatter.format(calendar.getTime()));
        String startTime = TESLMOTDRDataMgr.convertCalendarToServerTime(calendar, this.neid);
        normalLogger.info("Refresh Line Status Convert To Applet Time. startTime: " + startTime);
        return startTime;
    }

    private boolean isNETimeValid(int currentWorkStatus, int startYear) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
        boolean isValid = currentWorkStatus != 2 || startYear == 48 + timezonebean.nebaseyear || startYear == timezonebean.nebaseyear;
        return isValid;
    }

    private void updateLineRefreshInfo(int neID, int lineID, byte refreshType, Output output) {
        if (null == output) {
            return;
        }
        int testType = Integer.parseInt(output.getPart("testType").getValue());
        int currentWorkStatus = Integer.parseInt(output.getPart("currentWorkStatus").getValue());
        if (1 == refreshType) {
            TELineRefreshInfo refreshInfo;
            if (2 == currentWorkStatus) {
                TESLMRefreshTypeMgr.getInstance().refreshType(neID, lineID, refreshType);
            } else if (1 == currentWorkStatus) {
                TESLMRefreshTypeMgr.getInstance().stopTimer(neID, lineID);
            }
            if (3 == testType && 3 == currentWorkStatus && null != (refreshInfo = TESLMRefreshTypeMgr.getInstance().getRefreshInfo(neID, lineID))) {
                refreshInfo.waitingTestStatus();
            }
        }
    }

    private void refreshLineData() {
        int neid = 0;
        for (Integer neidTmp : this.neLst) {
            neid = neidTmp;
            TIntArrayList list = new TIntArrayList();
            int len = this.neLst.size();
            for (int i = 0; i < len; ++i) {
                if (neid != this.neLst.get(i)) continue;
                for (Integer bint : this.lineIDSetLst.get(i)) {
                    list.add(bint.intValue());
                }
            }
            TESLMOTDRDataMgr.refreshNELineData(neid, list);
            TESLMRefreshTypeMgr.getInstance().refreshTypeData(neid, list);
            TESLMCommunicateCheckMgr.getInstance().refreshTypeData(neid, list);
        }
    }

    private void sendOtherNEListMessage() {
        int len = this.sinkNEList.size();
        for (int i = 0; i < len; ++i) {
            this.sinkNEStuct = this.sinkNEList.get(i);
            this.sendOtherNEMessage(this.sinkNEStuct);
        }
    }

    private int sendOtherNEMessage(TESLMSinkNEStruct sinkNEStuct) {
        int logicNEID = TENECommMgr.getInstance().getLogicNEID(sinkNEStuct.getSinkNEID());
        TENE neInfo = TEConfigurationDataMgr.getInstance().getNE(logicNEID);
        if (null == neInfo) {
            return this.handleNENotExistMessage(sinkNEStuct);
        }
        if (0 == neInfo.getComStarus()) {
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neInfo.getNEID(), 1, 1090617361);
            return this.handleNENotExistMessage(sinkNEStuct);
        }
        if (0 == neInfo.getLogStatus()) {
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neInfo.getNEID(), 1, 1090646046);
            return this.handleNENotExistMessage(sinkNEStuct);
        }
        Datainterface input = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        RowParams row = new RowParams();
        row.addParam(new Param("neid", String.valueOf(logicNEID)));
        row.addParam(new Param("lineID", String.valueOf(sinkNEStuct.getLineID())));
        bussinessParams.addRowParams(row);
        input.setBussinessParams(bussinessParams);
        ArrayList otherNEOperationList = this.getOperation(logicNEID, this.subfunc, input, null);
        int result = 0;
        if (!otherNEOperationList.isEmpty()) {
            result = this.sendMessage(logicNEID, otherNEOperationList);
        }
        if (result == 0 && !otherNEOperationList.isEmpty()) {
            this.handleOtherNEMessage(logicNEID, otherNEOperationList, this.getFilterErrorCodeList());
        } else {
            TESLMLineUtil.setErrorMessageInfoList(this.outputData, logicNEID, otherNEOperationList);
        }
        return result;
    }

    public int handleNENotExistMessage(TESLMSinkNEStruct sinkNEStuct) {
        int lineID = sinkNEStuct.getLineID();
        int direction = sinkNEStuct.getDirection();
        ArrayList rowParamsList = this.outputData.getBussinessParams().getRowParamList();
        for (RowParams rowParams : rowParamsList) {
            int tmpLineID;
            Param param = rowParams.getParam("lineID");
            if (null == param || lineID != (tmpLineID = Integer.valueOf(param.getValue()).intValue())) continue;
            this.handleOpNENotExistDetail(direction, rowParams);
        }
        return 0;
    }

    private void handleOpNENotExistDetail(int direction, RowParams rowParams) {
        if (1 != direction) {
            String[] paramNames = new String[]{"srcLmuFullName", "srcLmuNeId", "srcLmuSlotId", "srcLmuPortId", "srcLmiFullName", "srcLmiNeId", "srcLmiSlotId", "srcLmiPortId", "srcLineDirection", "srcSaveSinkNEID", "srcSaveSinkLmiSlot", "srcSaveSinkNEIDInfo", "srcProbeWaveBand", "srcProbeWaveIndex", "srcLoadingWaveBand", "srcLoadingWaveIndex", "srcTestMode", "srcTestType", "srcTestStatus", "srcTestProgress", "srcStartYear", "srcStartMonth", "srcStartDay", "srcStartHour", "srcStartMinute", "srcStartMinute", "srcRemainingTime", "srcAbortErrorCode"};
            this.convertLineOutput(rowParams, paramNames, 1);
        } else {
            String[] paramNames = new String[]{"sinkLmuFullName", "sinkLmuNeId", "sinkLmuSlotId", "sinkLmuPortId", "sinkLmiFullName", "sinkLmiNeId", "sinkLmiSlotId", "sinkLmiPortId", "sinkLineDirection", "sinkSaveSrcNEID", "sinkSaveSrcLmiSlot", "sinkSaveSrcNEIDInfo", "sinkProbeWaveBand", "sinkProbeWaveIndex", "sinkLoadingWaveBand", "sinkLoadingWaveIndex", "sinkTestMode", "sinkTestType", "sinkTestStatus", "sinkTestProgress", "sinkStartYear", "sinkStartMonth", "sinkStartDay", "sinkStartHour", "sinkStartMinute", "sinkStartMinute", "sinkRemainingTime", "sinkAbortErrorCode"};
            this.convertLineOutput(rowParams, paramNames, 0);
        }
    }

    private void convertLineOutput(RowParams rowparams, String[] paramNames, int direction) {
        this.addPartToOutput(null, paramNames[0], UNKNOWN, rowparams);
        this.addPartToOutput(null, paramNames[1], 0, rowparams);
        this.addPartToOutput(null, paramNames[2], 0, rowparams);
        this.addPartToOutput(null, paramNames[3], 0, rowparams);
        this.addPartToOutput(null, paramNames[4], UNKNOWN, rowparams);
        this.addPartToOutput(null, paramNames[5], 0, rowparams);
        this.addPartToOutput(null, paramNames[6], 0, rowparams);
        this.addPartToOutput(null, paramNames[7], 0, rowparams);
        this.addPartToOutput(null, paramNames[8], direction, rowparams);
        this.addPartToOutput(null, paramNames[9], 0, rowparams);
        this.addPartToOutput(null, paramNames[10], 0, rowparams);
        this.addPartToOutput(null, paramNames[11], 0, rowparams);
        this.addPartToOutput(null, paramNames[12], 0, rowparams);
        this.addPartToOutput(null, paramNames[13], 0, rowparams);
        this.addPartToOutput(null, paramNames[14], 0, rowparams);
        this.addPartToOutput(null, paramNames[15], 0, rowparams);
        this.addPartToOutput(null, paramNames[16], 0, rowparams);
        this.addPartToOutput(null, paramNames[17], 0, rowparams);
        this.addPartToOutput(null, paramNames[18], 0, rowparams);
        this.addPartToOutput(null, paramNames[19], 0, rowparams);
        this.addPartToOutput(null, paramNames[20], 0, rowparams);
        this.addPartToOutput(null, paramNames[21], 0, rowparams);
        this.addPartToOutput(null, paramNames[22], 0, rowparams);
        this.addPartToOutput(null, paramNames[23], 0, rowparams);
        this.addPartToOutput(null, paramNames[24], 0, rowparams);
        this.addPartToOutput(null, paramNames[25], 0, rowparams);
        this.addPartToOutput(null, paramNames[26], 0, rowparams);
        this.addPartToOutput(null, paramNames[27], 0, rowparams);
    }

    public void handleOtherNEMessage(int neid, ArrayList operationList, ArrayList filterErrorCodeList) {
        normalLogger.info("handleNEMessage start, and the current neid is -> " + neid);
        HashSet<Integer> lineIDSet = new HashSet<Integer>();
        Operation tmpOper = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            int cmdID = tmpOper.getCmdid();
            if (30440 == cmdID) {
                this.handleLineInfo(neid, tmpOper, lineIDSet);
            }
            if (30449 == cmdID) {
                this.handleWaveLenInfo(neid, tmpOper);
            }
            if (30402 != cmdID) continue;
            this.handleLineStateInfo(neid, tmpOper);
        }
        this.neLst.add(neid);
        this.lineIDSetLst.add(lineIDSet);
        normalLogger.info("handleNEMessage end.");
    }
}

