/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.otdr.TESLMFileUtil;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESyncTestData
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static int NSCMD_SLM_GET_OTDRRESULT = 30423;
    private Logger log = TELogFactory.getNormalLogger();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.log.info("MARINE ---- BEGIN to handle sync test data message.");
        Operation tmpOper = null;
        int cmdID = 0;
        String lineID = "";
        String testModestr = null;
        Output output2 = null;
        int code = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            output2 = ((Operation)operationList.get(0)).getOutput(i);
            code = Integer.parseInt(output2.getFault(0).getCode());
            if (0 != code) continue;
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            lineID = tmpOper.getInput().getPartValue("lineID");
            if (cmdID != NSCMD_SLM_GET_OTDRRESULT) continue;
            for (Output output2 : tmpOper.getOutput()) {
                String testTypeStr = output2.getPartValue("lineTestType");
                testModestr = output2.getPartValue("testMode");
                int lmiNEID = Integer.parseInt(output2.getPartValue("lmineid"));
                this.log.info("MARINE ---- lmiNEID->" + lmiNEID);
                int lmiSlotID = Integer.parseInt(output2.getPartValue("lmiBid"));
                this.log.info("MARINE ---- lmiSlotID->" + lmiSlotID);
                int lmiPortID = Integer.parseInt(output2.getPartValue("lmiPortId"));
                this.log.info("MARINE ---- lmiPortID->" + lmiPortID);
                String neFileTime = output2.getPartValue("fileCreateTime").trim();
                this.log.info("MARINE ---- fileCreateTime->" + neFileTime);
                String fileName = output2.getPartValue("fileName");
                if (null == fileName) {
                    this.log.info("MARINE ---- fileName is null.");
                    continue;
                }
                fileName = fileName.trim();
                this.log.info("MARINE ---- fileName->" + fileName);
                output2.setPartValue("fileName", fileName);
                neFileTime = fileName.substring(0, fileName.indexOf("."));
                this.log.info("MARINE ---- neFileTime->" + neFileTime);
                String nmFileTime = TESLMOTDRDataMgr.convertNEFileTimeToNMFileTime(neFileTime, neid);
                this.log.info("MARINE ---- nmFileTime->" + nmFileTime);
                boolean isBaseLine = false;
                boolean isSaved = false;
                boolean isTmp = false;
                boolean isComplete = true;
                int indexID = Integer.parseInt(lineID);
                int testMode = Integer.parseInt(testModestr);
                int testType = Integer.parseInt(testTypeStr);
                this.log.info("MARINE ---- BEGIN to get file from ne");
                this.log.info("MARINE ---- neID->" + this.neid);
                this.log.info("MARINE ---- indexID->" + indexID);
                this.log.info("MARINE ---- testType->" + testType);
                this.log.info("MARINE ---- fileName->" + fileName);
                this.log.info("MARINE ---- testMode->" + testMode);
                int result = TESLMOTDRDataMgr.getFileFromNE(this.neid, indexID, testType, fileName);
                if (0 == result) {
                    String fileSuffixType = TESLMOTDRDataMgr.getFileSuffixTypeStr(fileName);
                    if (4 == testType) {
                        isBaseLine = true;
                        isSaved = true;
                    }
                    String nmFileName = TESLMOTDRDataMgr.convertNEFileNameToNMFileName(neid, indexID, testMode, testType, lmiNEID, lmiSlotID, lmiPortID, nmFileTime, isBaseLine, fileSuffixType);
                    this.log.info("MARINE ---- nmFileName->" + nmFileName);
                    if (TESLMOTDRDataMgr.fileExists(neid, indexID, nmFileName)) {
                        this.log.info("MARINE ---- file exists. fileName->" + nmFileName);
                        TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neid)), fileName);
                        continue;
                    }
                    TESLMOTDRDataMgr.copyNewFile(neid, fileName, nmFileName);
                    TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neid)), fileName);
                    if (isBaseLine) {
                        this.log.info("MARINE ---- delete current base line");
                        TESLMOTDRDataMgr.deleteBaseLine(neid, indexID, testMode);
                        TESLMOTDRDataMgr.addTestRecord(neid, indexID, testType, nmFileName, isBaseLine, isSaved, isTmp, isComplete);
                        this.log.info("MARINE ---- SET NEW BASELINE ON NM");
                        TESLMOTDRDataMgr.updateBaseLine(neid, indexID, testMode, nmFileName);
                        continue;
                    }
                    TESLMOTDRDataMgr.addTestRecord(neid, indexID, testType, nmFileName, isBaseLine, isSaved, isTmp, isComplete);
                    continue;
                }
                this.log.info("MARINE ---- failed to get file from ne");
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer();
        Param[] params = rowparams.getParam();
        String lineID = Datainterface.getParam((Param[])params, (String)"lineID").getValue();
        int testMode = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"testMode").getValue());
        int testType = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"testType").getValue());
        strBuf.append(this.res.getString("lineID")).append(": ").append(lineID).append(", ");
        String[] TEST_MODE = new String[]{this.res.getString("All"), this.res.getString("InServiceMode"), this.res.getString("OutOfServiceMode"), this.res.getString("UnknownMode")};
        strBuf.append(this.res.getString("testMode")).append(": ").append(TEST_MODE[testMode]).append(", ");
        String[] TEST_TYPE = new String[]{this.res.getString("All"), this.res.getString("SingleTest"), this.res.getString("ManualTest"), this.res.getString("CycleTest"), this.res.getString("BaselineTest"), this.res.getString("UnknownTest")};
        strBuf.append(this.res.getString("testType")).append(": ").append(TEST_TYPE[testType]);
        return strBuf.toString();
    }
}

