/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.otdr.TESLMFileUtil;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import org.slf4j.Logger;

public class TESLMUploadBaseLineBean
extends TENEExplorerBean {
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.inputData = inputData;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        RowParams row = (RowParams)inputData.getBussinessParams().getRowParamList().get(0);
        this.log.info("MARINE ------receive uploadbaseline request------");
        this.log.info("MARINE ------neID->" + neid + "  phyNEID->" + TESLMOTDRDataMgr.getRealNEID(neid));
        int indexID = -1;
        Param param = null;
        param = row.getParam("indexID");
        if (null == param) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        indexID = Integer.parseInt(param.getValue());
        this.log.info("MARINE ------indexID->" + indexID);
        param = row.getParam("testMode");
        if (null == param) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        int testMode = Integer.parseInt(param.getValue());
        this.log.info("MARINE ------testMode->" + testMode);
        super.performBussinessProcess(neid, this.subfunc, inputData, memeryData, user, ipAddress);
        int performResult = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        this.log.info("MARINE ------uploadbaseline result->" + performResult);
        if (0 == performResult) {
            this.log.info("MARINE ------begin to process ne response data------");
            RowParams rspRow = this.outputData.getBussinessParams().getRowParams()[0];
            int hasBaseLine = Integer.parseInt(rspRow.getParam("hasBaseLine").getValue());
            this.log.info("MARINE ------hasBaseLine->" + hasBaseLine);
            if (1 == hasBaseLine) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                param = this.outputData.getBussinessParams().getRowParams()[0].getParam("fileName");
                String newBLName = param.getValue().trim();
                this.log.info("MARINE ------fileName->" + newBLName);
                param.setValue(newBLName);
                param = this.outputData.getBussinessParams().getRowParams()[0].getParam("lmiNEID");
                int lmiNEID = Integer.parseInt(param.getValue());
                this.log.info("MARINE ------lmiNEID->" + lmiNEID);
                param = this.outputData.getBussinessParams().getRowParams()[0].getParam("lmiSlotID");
                int lmiSlotID = Integer.parseInt(param.getValue());
                this.log.info("MARINE ------lmiSlotID->" + lmiSlotID);
                param = this.outputData.getBussinessParams().getRowParams()[0].getParam("lmiPortID");
                int lmiPortID = Integer.parseInt(param.getValue());
                this.log.info("MARINE ------lmiPortID->" + lmiPortID);
                param = this.outputData.getBussinessParams().getRowParams()[0].getParam("neFileTime");
                String neFileTime = param.getValue().trim();
                this.log.info("MARINE ------neFileTime->" + neFileTime);
                neFileTime = newBLName.substring(0, newBLName.indexOf("."));
                this.log.info("MARINE ---- neFileTime->" + neFileTime);
                String nmFileTime = TESLMOTDRDataMgr.convertNEFileTimeToNMFileTime(neFileTime, neid);
                this.log.info("MARINE ------convert neFileTime to nmFileTime->" + nmFileTime);
                int testType = 4;
                boolean isBaseLine = true;
                boolean isSaved = true;
                boolean isTmp = false;
                boolean isComplete = true;
                String oldBLName = TESLMOTDRDataMgr.getBaseLineFileName(neid, indexID, testMode);
                String fileSuffixType = TESLMOTDRDataMgr.getFileSuffixTypeStr(newBLName);
                String nmNewBLName = TESLMOTDRDataMgr.convertNEFileNameToNMFileName(neid, indexID, testMode, testType, lmiNEID, lmiSlotID, lmiPortID, nmFileTime, isBaseLine, fileSuffixType);
                this.log.info("Marine UploadBaseLine Convert Time. fileName: " + nmNewBLName);
                String clientNewBLName = TESLMOTDRDataMgr.convertNMUTCFileNameToAppletFileName(nmNewBLName, neid);
                this.log.info("Marine UploadBaseLine Convert Time. fileName: " + clientNewBLName);
                this.outputData.getBussinessParams().getRowParams()[0].getParam("fileName").setValue(clientNewBLName);
                if (!nmNewBLName.equals(oldBLName)) {
                    this.log.info("MARINE ---- BEGIN to get file from ne.");
                    int result = TESLMOTDRDataMgr.getFileFromNE(neid, indexID, -1, newBLName);
                    this.log.info("MARINE ------get file from ne result->" + result);
                    if (0 == result) {
                        this.log.info("MARINE ---- succeeded to get file from ne");
                        if (!TESLMOTDRDataMgr.fileExists(neid, indexID, nmNewBLName)) {
                            this.log.info("MARINE ---- DELETE current base line");
                            TESLMOTDRDataMgr.deleteBaseLine(neid, indexID, testMode);
                            this.log.info("MARINE ------convertNEFileNameToNMFileName   nmNewBLName->" + nmNewBLName);
                            TESLMOTDRDataMgr.copyNewFile(neid, newBLName, nmNewBLName);
                            TESLMOTDRDataMgr.addTestRecord(neid, indexID, testType, nmNewBLName, isBaseLine, isSaved, isTmp, isComplete);
                        }
                        this.log.info("MARINE ---- delete file from ne. fileName->" + newBLName);
                        TESLMFileUtil.deleteFile(TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(neid)), newBLName);
                    } else {
                        this.log.info("MARINE ---- failed to get file from ne");
                    }
                }
            } else {
                this.log.info("MARINE ---- line does not have a base line");
                TESLMOTDRDataMgr.deleteBaseLine(neid, indexID, testMode);
                RowErrors rowErr = new RowErrors();
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setErrorcode("42793");
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)42793));
                rowErr.setErrorMessage(errorMessage);
                Param errParam = new Param();
                errParam.setName("neid");
                errParam.setValue("" + neid);
                rowErr.addParam(errParam);
                Param tmpParam = null;
                int rowLen = row.getParamCount();
                for (int i = 0; i < rowLen; ++i) {
                    tmpParam = row.getParam(i);
                    errParam = new Param(tmpParam.getName(), tmpParam.getValue());
                    rowErr.addParam(errParam);
                }
                TENE neObj = TENEListMgr.getInstance().getNE(neid);
                errParam = new Param("nename", neObj.getNEName());
                rowErr.addParam(errParam);
                RowParams errRow = new RowParams();
                errRow.addRowErrors(rowErr);
                this.outputData.getBussinessParams().clearRowParams();
                this.outputData.getBussinessParams().addRowParams(errRow);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        } else {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf1 = new StringBuffer();
        strBuf1.append(res.getString("lineID")).append(": ");
        Param[] params = rowparams.getParam();
        String lineID = Datainterface.getParam((Param[])params, (String)"indexID").getValue();
        strBuf1.append(lineID);
        strBuf1.append(" ");
        strBuf1.append(res.getString("testMode")).append(": ");
        String testModeStr = Datainterface.getParam((Param[])params, (String)"testMode").getValue();
        int testMode = Integer.parseInt(testModeStr);
        if (1 == testMode) {
            testModeStr = res.getString("InServiceMode");
        } else if (2 == testMode) {
            testModeStr = res.getString("OutOfServiceMode");
        }
        strBuf1.append(testModeStr);
        return strBuf1.toString();
    }
}

