/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TESLMSetRefreshTypeBean
extends TENEExplorerBean {
    private static final int ERROR_CODE_LINE_NOT_EXSIT = 42781;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            if (null == inputData) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return this.outputData;
            }
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            int count = rowParams.length;
            if (0 == count) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                return this.outputData;
            }
            this.refreshTypeHandler(rowParams, this.outputData);
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void refreshTypeHandler(RowParams[] rowParams, Datainterface outputData) {
        if (null == rowParams || 0 == rowParams.length) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return;
        }
        int count = rowParams.length;
        int successCount = 0;
        for (int i = 0; i < rowParams.length; ++i) {
            String refreshTypeStr;
            String lineIDStr;
            String neIDStr = rowParams[i].getParam("neid").getValue();
            if (null == neIDStr || "".equals(neIDStr) || null == (lineIDStr = rowParams[i].getParam("lineID").getValue()) || "".equals(lineIDStr) || null == (refreshTypeStr = rowParams[i].getParam("refreshType").getValue()) || "".equals(refreshTypeStr)) continue;
            int neIDInt = Integer.parseInt(neIDStr);
            int lineID = Integer.parseInt(lineIDStr);
            byte refreshType = Byte.parseByte(refreshTypeStr);
            boolean ret = TESLMRefreshTypeMgr.getInstance().refreshType(neIDInt, lineID, refreshType);
            if (ret) {
                ++successCount;
                continue;
            }
            BussinessParams bussinessParams = new BussinessParams();
            RowParams tmpRowParams = new RowParams();
            RowErrors rowError = new RowErrors();
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)42781));
            Param param = new Param();
            param.setName("neID");
            param.setValue(neIDStr);
            rowError.addParam(param);
            param = new Param();
            param.setName("lineID");
            param.setValue(lineIDStr);
            rowError.addParam(param);
            tmpRowParams.addRowErrors(rowError);
            bussinessParams.addRowParams(tmpRowParams);
            outputData.setBussinessParams(bussinessParams);
        }
        if (0 == successCount) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return;
        }
        if (count != successCount) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuilder filePath = new StringBuilder();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (String)filePath.toString());
        StringBuilder detailStr = new StringBuilder(super.getDetailStr(rowparams)).append(' ');
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (null == ne) {
            return detailStr.toString();
        }
        String neName = ne.getNEName();
        detailStr.append(res.getString("NE")).append(neName).append(", ");
        detailStr.append(res.getString("LINE_ID")).append(rowparams.getParam("lineID").getValue());
        detailStr.append(", ");
        if (null != rowparams.getParam("refreshType")) {
            String refreshType = res.getString("refreshType_" + rowparams.getParam("refreshType").getValue());
            detailStr.append(res.getString("refreshType")).append(refreshType);
            detailStr.append(", ");
        }
        if (null != rowparams.getParam("srcFilterStatus")) {
            String srcFilterStatus = res.getString("FilterStatus_" + rowparams.getParam("srcFilterStatus").getValue());
            detailStr.append(res.getString("FilterStatus")).append(srcFilterStatus);
            detailStr.append(", ");
        }
        if (null != rowparams.getParam("srcCommunicateCheck")) {
            String srcCommunicateCheck = res.getString("CommunicateCheck_" + rowparams.getParam("srcCommunicateCheck").getValue());
            detailStr.append(res.getString("CommunicateCheck")).append(srcCommunicateCheck);
            detailStr.append(", ");
        }
        return detailStr.toString();
    }
}

