/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;

public class TESLMSetBaseLineBean
extends TENEExplorerBean {
    protected Logger log = TELogFactory.getNormalLogger();
    private static final int FILE_OPERATE_FAILED = 1091092491;
    private static final int FILE_NOT_EXIST = 1090781211;
    protected int indexID = -1;
    protected int testMode = -1;
    protected int lmiNEID = -1;
    protected int lmiSlotID = -1;
    protected int lmiPortID = -1;
    protected String fileName = null;
    protected File sendToNEFile = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.log.info("MARINE ---- BEGIN to process set base line request.");
        this.log.info("MARINE ---- neID->" + neid);
        this.neid = neid;
        this.inputData = inputData;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        RowParams row = (RowParams)inputData.getBussinessParams().getRowParamList().get(0);
        Param param = null;
        param = row.getParam("indexID");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the indexID parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.indexID = Integer.parseInt(param.getValue());
        this.log.info("MARINE ---- indexID->" + this.indexID);
        param = row.getParam("testMode");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the testMode parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.testMode = Integer.parseInt(param.getValue());
        this.log.info("MARINE ---- testMode->" + this.testMode);
        param = row.getParam("fileName");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the fileName parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.fileName = param.getValue();
        this.log.info("MARINE ---- fileName->" + this.fileName);
        this.fileName = TESLMOTDRDataMgr.convertAppletFileNameToNMUTCFileName(this.fileName, neid);
        this.log.info("MARINE ---- fileName->" + this.fileName);
        String nmFileName = null;
        param = row.getParam("nmFileName");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the nmFileName parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        try {
            nmFileName = URLDecoder.decode(param.getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TESLMSetBaseLineBean.performBussinessProcess() fail!", (Throwable)e);
        }
        this.log.info("MARINE ---- nmFileName->" + nmFileName);
        param = row.getParam("lmiNEID");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the lmiNEID parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.lmiNEID = Integer.parseInt(param.getValue());
        this.log.info("MARINE ---- lmiNEID->" + this.lmiNEID);
        param = row.getParam("lmiSlotID");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the lmiSlotID parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.lmiSlotID = Integer.parseInt(param.getValue());
        this.log.info("MARINE ---- lmiSlotID->" + this.lmiSlotID);
        param = row.getParam("lmiPortID");
        if (null == param) {
            this.log.info("MARINE ---- application does not pass the lmiPortID parameter.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.lmiPortID = Integer.parseInt(param.getValue());
        this.log.info("MARINE ---- lmiPortID->" + this.lmiPortID);
        this.log.info("MARINE ---- BEGIN TO set base line");
        if (!TESLMOTDRDataMgr.fileExists(neid, this.indexID, this.fileName)) {
            this.log.info("MARINE ---- file does not exist!");
            this.log.info("MARINE ---- fileName->" + this.fileName);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090781211));
            return this.outputData;
        }
        this.log.info("MARINE ---- fileName->" + this.fileName);
        String fileNameTmp = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        String[] propArray = fileNameTmp.split("_");
        String nmTime = propArray[5];
        String suffix = TESLMOTDRDataMgr.getFileSuffixTypeStr(this.fileName);
        String sendToNEFileName = TESLMOTDRDataMgr.convertNMFileTimeToNEFileTime(nmTime, neid) + "." + suffix;
        this.log.info("MARINE ---- sendToNEFileName->" + sendToNEFileName);
        this.log.info("MARINE ---- copy a new file. newFileName->" + sendToNEFileName);
        this.sendToNEFile = TESLMOTDRDataMgr.copyNewFile(neid, this.fileName, sendToNEFileName);
        if (null == this.sendToNEFile) {
            this.log.info("MARINE ---- failed to copy file.");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1091092491));
            return this.outputData;
        }
        this.log.info("MARINE ---- succeeded to copy file");
        String stdBLName = sendToNEFileName;
        int result = TESLMOTDRDataMgr.sendFileToNE(neid, sendToNEFileName);
        if (0 != result) {
            this.log.info("MARINE ---- failed to send file to ne");
            this.log.info("MARINE ---- delete the file.");
            try {
                this.sendToNEFile.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TESLMSetBaseLineBean.performBussinessProcess() fail!", (Throwable)e);
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        row.getParam("fileName").setValue(stdBLName);
        this.log.info("MARINE ---- succeeded to send file.");
        this.log.info("MARINE ---- BEGIN to send request to ne to set base line");
        super.performBussinessProcess(neid, this.subfunc, inputData, memeryData, user, ipAddress);
        if (0 == Integer.parseInt(this.outputData.getErrorMessage().getErrorcode())) {
            this.operSuccess();
        } else {
            RowErrors rowErr;
            RowParams rowParams;
            this.log.info("MARINE ---- ne responds. FAILED to set base line. DELETE the new file");
            try {
                this.sendToNEFile.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TESLMSetBaseLineBean.performBussinessProcess() fail!", (Throwable)e);
            }
            BussinessParams bps = this.outputData.getBussinessParams();
            if (null != bps && null != (rowParams = bps.getRowParams()[0]) && null != (rowErr = rowParams.getRowErrors()[0])) {
                rowErr.addParam(row.getParam("nmFileName"));
            }
        }
        return this.outputData;
    }

    protected void operSuccess() {
        this.log.info("MARINE ---- ne responds. succeeded to set base line");
        this.log.info("MARINE ---- delete current base line");
        TESLMOTDRDataMgr.deleteBaseLine(this.neid, this.indexID, this.testMode);
        this.log.info("MARINE ---- MAKE new base line file name for nm");
        String newBLName = TESLMOTDRDataMgr.makeBaseLineName(this.indexID, this.testMode, this.lmiNEID, this.lmiSlotID, this.lmiPortID, this.fileName);
        this.log.info("MARINE ---- newBLName->" + newBLName);
        TESLMOTDRDataMgr.copyNewFile(this.neid, this.sendToNEFile.getName(), newBLName);
        try {
            this.sendToNEFile.delete();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMSetBaseLineBean.operSuccess() fail!", (Throwable)e);
        }
        this.log.info("MARINE ---- SET NEW BASELINE ON NM");
        TESLMOTDRDataMgr.updateBaseLine(this.neid, this.indexID, this.testMode, newBLName);
        String clientBLName = TESLMOTDRDataMgr.convertNMUTCFileNameToAppletFileName(newBLName, this.neid);
        this.log.info("MARINE Convert BLName. clientBLName->" + clientBLName);
        BussinessParams obus = new BussinessParams();
        this.outputData.setBussinessParams(obus);
        RowParams orow = new RowParams();
        Param oparam = new Param();
        oparam.setName("newBaseLineFileName");
        oparam.setValue(clientBLName);
        orow.addParam(oparam);
        obus.addRowParams(orow);
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(res.getString("lineID")).append(": ");
        Param[] params = rowparams.getParam();
        String lineID = Datainterface.getParam((Param[])params, (String)"indexID").getValue();
        strBuf.append(lineID);
        strBuf.append(" ");
        strBuf.append(res.getString("testMode")).append(": ");
        String testModeStr = Datainterface.getParam((Param[])params, (String)"testMode").getValue();
        int testMode = Integer.parseInt(testModeStr);
        if (1 == testMode) {
            testModeStr = res.getString("InServiceMode");
        } else if (2 == testMode) {
            testModeStr = res.getString("OutOfServiceMode");
        }
        strBuf.append(testModeStr);
        strBuf.append(" ");
        String fileName = "";
        try {
            fileName = URLDecoder.decode(Datainterface.getParam((Param[])params, (String)"nmFileName").getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TESLMSetBaseLineBean.getDetailStr() fail!", (Throwable)e);
        }
        strBuf.append(res.getString("fileName")).append(": ");
        strBuf.append(fileName);
        return strBuf.toString();
    }
}

