/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.nemgr.marine.linemonitor.TELineRefreshInfo;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TESLMRefreshTypeMgr {
    private static final byte REFRESH_TYPE_START = 1;
    private static final byte REFRESH_TYPE_STOP = 1;
    private List<TELineRefreshInfo> refreshTypeList = new ArrayList<TELineRefreshInfo>();
    private static final TESLMRefreshTypeMgr instance = new TESLMRefreshTypeMgr();

    private TESLMRefreshTypeMgr() {
    }

    public static TESLMRefreshTypeMgr getInstance() {
        return instance;
    }

    public boolean containsLine(int neID, int lineID) {
        if (0 >= neID || 0 >= lineID) {
            return false;
        }
        return this.containsData(new TELineRefreshInfo(neID, lineID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsData(TELineRefreshInfo refreshInfo) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (null == refreshInfo) {
                return false;
            }
            return this.refreshTypeList.contains(refreshInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(int neID, int lineID, byte refreshType) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (0 >= neID || 0 > lineID) {
                return;
            }
            TELineRefreshInfo tmpInfo = new TELineRefreshInfo(neID, lineID, refreshType);
            if (this.containsData(tmpInfo)) {
                TELineRefreshInfo refreshInfo = this.getRefreshInfo(neID, lineID);
                refreshInfo.setRefreshType(refreshType);
            }
            this.refreshTypeList.add(tmpInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delData(int neID, int lineID) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (0 >= neID || 0 > lineID) {
                return false;
            }
            TELineRefreshInfo tmpInfo = new TELineRefreshInfo(neID, lineID);
            if (!this.refreshTypeList.contains(tmpInfo)) {
                return false;
            }
            return this.refreshTypeList.remove(tmpInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshType(int neID, int lineID, byte refreshType) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (0 >= neID || 0 > lineID) {
                return false;
            }
            TELineRefreshInfo tmpInfo = new TELineRefreshInfo(neID, lineID, refreshType);
            if (!this.containsData(tmpInfo)) {
                return false;
            }
            TELineRefreshInfo refreshInfo = this.getRefreshInfo(neID, lineID);
            refreshInfo.setRefreshType(refreshType);
            if (1 == refreshType) {
                refreshInfo.startTimer();
            } else {
                refreshInfo.endTimer();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getRefreshType(int neID, int lineID) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (0 >= neID || 0 >= lineID) {
                return -1;
            }
            TELineRefreshInfo tmpInfo = new TELineRefreshInfo(neID, lineID);
            for (TELineRefreshInfo refreshInfo : this.refreshTypeList) {
                if (!refreshInfo.equals(tmpInfo)) continue;
                return refreshInfo.getRefreshType();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTypeData(int neID, TIntArrayList list) {
        List<TELineRefreshInfo> list2 = this.refreshTypeList;
        synchronized (list2) {
            if (null == list || 0 >= neID) {
                return;
            }
            if (list.isEmpty()) {
                this.refreshTypeList.clear();
                return;
            }
            Iterator<TELineRefreshInfo> iterator = this.refreshTypeList.iterator();
            while (iterator.hasNext()) {
                int lineID;
                TELineRefreshInfo tmpInto = iterator.next();
                if (neID != tmpInto.getNeID() || list.contains(lineID = tmpInto.getLineID())) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TELineRefreshInfo getRefreshInfo(int neID, int lineID) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (0 >= neID || 0 >= lineID) {
                return null;
            }
            TELineRefreshInfo tmpInfo = new TELineRefreshInfo(neID, lineID);
            for (TELineRefreshInfo refreshInfo : this.refreshTypeList) {
                if (!refreshInfo.equals(tmpInfo)) continue;
                return refreshInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTimer(int neID, int lineID) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (!this.containsLine(neID, lineID)) {
                return false;
            }
            TELineRefreshInfo refreshInfo = this.getRefreshInfo(neID, lineID);
            if (null == refreshInfo) {
                return false;
            }
            refreshInfo.startTimer();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTimer(int neID, int lineID) {
        List<TELineRefreshInfo> list = this.refreshTypeList;
        synchronized (list) {
            if (!this.containsLine(neID, lineID)) {
                return false;
            }
            TELineRefreshInfo refreshInfo = this.getRefreshInfo(neID, lineID);
            if (null == refreshInfo) {
                return false;
            }
            refreshInfo.endTimer();
            return true;
        }
    }

    public List<TELineRefreshInfo> getLineRefreshInfoList() {
        return this.refreshTypeList;
    }
}

