/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.otdr.report.TESLMReportInf;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TESLMPrintReportBean
implements TENEMgrInterface {
    private static final int NONREF_EVENT_TYPE = 1;
    private static final int REF_EVENT_TYPE = 2;
    private static final int END_EVENT_TYPE = 3;
    private static final int START_POINT_EVENT_TYPE = 4;
    private static final int END_POINT_EVENT_TYPE = 5;
    private static final String filePath = "marine" + File.separator + TEPathManager.RESOURCE_PROFILE_PATH + "linemonitor" + File.separator + "linemonitor_" + TESysManagerBean.getInstance().getlanguage() + ".ini";

    public boolean isNeedOperationlog() {
        return false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface outputData;
        try {
            outputData = TESLMReportInf.getAllReportData(inputData);
            outputData = this.getEventType(neid, outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return outputData;
    }

    private Datainterface getEventType(int neid, Datainterface outputData) {
        RowParams tmpParam = outputData.getBussinessParams().getRowParams(0);
        if (null == tmpParam.getParam("eventType")) {
            return outputData;
        }
        int len = outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            tmpParam = outputData.getBussinessParams().getRowParams(i);
            String eventTypeIndex = tmpParam.getParam("eventType").getValue();
            tmpParam.getParam("eventType").setValue(this.getEventType(neid, Integer.parseInt(eventTypeIndex)));
        }
        return outputData;
    }

    private String getEventType(int neid, int eventTypeIndex) {
        TEResourceUtil res = TEGetFilePath.getResource((int)neid, (String)filePath);
        if (1 == eventTypeIndex) {
            return res.getString("nonrefeventtype");
        }
        if (2 == eventTypeIndex) {
            return res.getString("refeventtype");
        }
        if (3 == eventTypeIndex) {
            return res.getString("endeventtype");
        }
        if (4 == eventTypeIndex) {
            return res.getString("startpointeventtype");
        }
        if (5 == eventTypeIndex) {
            return res.getString("endpointeventtype");
        }
        return "";
    }
}

