/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESLMDeleteTestRecordBean
extends TENEExplorerBean {
    private static final int FILE_NOT_EXIST = 1090781211;
    private static final int FILE_NOT_EXIST_MACHINE = 43025;
    private static final int FILE_OPERATE_FAILED = 1091092491;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.log.info("MARINE ---- RECEIVE delete test record request.");
        this.neid = neid;
        this.inputData = inputData;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        RowParams row = (RowParams)inputData.getBussinessParams().getRowParamList().get(0);
        int indexID = -1;
        Param param = null;
        param = row.getParam("indexID");
        if (null == param) {
            this.log.info("MARINE ---- param indexID is null, return inner error");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        indexID = Integer.parseInt(param.getValue());
        String fileName = null;
        param = row.getParam("fileName");
        if (null == param) {
            this.log.info("MARINE ---- param fileName is null, return inner error");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        fileName = param.getValue();
        fileName = TESLMOTDRDataMgr.convertAppletFileNameToNMUTCFileName(fileName, neid);
        param = row.getParam("nmFileName");
        if (null == param) {
            this.log.info("MARINE ---- param nmFileName is null, return inner error");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        this.log.info("MARINE ---- neID->" + neid + " indexID->" + indexID + " fileName->" + fileName);
        boolean fileExist = TESLMOTDRDataMgr.fileExists(neid, indexID, fileName);
        if (!fileExist) {
            this.log.info("MARINE ---- file doesn't exist, return inner error");
        }
        String fileNameTmp = fileName.substring(0, fileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        String nmTime = propArray[5];
        String suffix = TESLMOTDRDataMgr.getFileSuffixTypeStr(fileName);
        String sendToNEFileName = TESLMOTDRDataMgr.convertNMFileTimeToNEFileTime(nmTime, neid) + "." + suffix;
        row.getParam("fileName").setValue(sendToNEFileName);
        super.performBussinessProcess(neid, this.subfunc, inputData, memeryData, user, ipAddress);
        int errCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 == errCode) {
            TESLMOTDRDataMgr.deleteTestRecord(neid, indexID, fileName);
        } else {
            RowErrors rowErr;
            RowParams rowParams;
            BussinessParams bps = this.outputData.getBussinessParams();
            if (null != bps && null != (rowParams = bps.getRowParams()[0]) && null != (rowErr = rowParams.getRowErrors()[0])) {
                rowErr.addParam(row.getParam("nmFileName"));
            }
        }
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterList = new ArrayList<Integer>();
        filterList.add(new Integer(43025));
        return filterList;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("config").append(File.separator).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(res.getString("lineID")).append(": ");
        Param[] params = rowparams.getParam();
        String lineID = Datainterface.getParam((Param[])params, (String)"indexID").getValue();
        strBuf.append(lineID);
        strBuf.append(" ");
        String fileName = Datainterface.getParam((Param[])params, (String)"nmFileName").getValue();
        strBuf.append(res.getString("fileName")).append(": ");
        strBuf.append(fileName);
        return strBuf.toString();
    }
}

