/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.marine.linemonitor.TELineRefreshInfo;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.linedata.TESLMLineState;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.slf4j.Logger;

public class TERefreshLineStatus
extends TENEExplorerBean {
    private static final int REFRESH_STATUS_TESTING = 2;
    private Logger log = TELogFactory.getNormalLogger();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TimeZoneDateBean timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        Operation tmpOper = null;
        int code = 0;
        Output output = null;
        String stringValue = null;
        int startYear = 0;
        int startMonth = 0;
        int startDay = 0;
        int startHour = 0;
        int startMinute = 0;
        int startSecond = 0;
        String startTime = "";
        String remainTime = "";
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            int size = tmpOper.getOutputCount();
            for (int j = 0; j < size; ++j) {
                output = tmpOper.getOutput(j);
                code = Integer.parseInt(output.getFault(0).getCode());
                if (0 != code) continue;
                int lineID = Integer.parseInt(output.getPartValue("lineID"));
                int testMode = Integer.parseInt(output.getPartValue("testMode"));
                int testType = Integer.parseInt(output.getPartValue("testType"));
                int currentWorkStatus = Integer.parseInt(output.getPartValue("currentWorkStatus"));
                TESLMLineState state = TESLMOTDRDataMgr.getLineState(neid, lineID);
                state.setTestMode(testMode);
                state.setTestType(testType);
                state.setTestState(currentWorkStatus);
                TESLMOTDRDataMgr.refreshLineState(neid, lineID, state);
                state = TESLMOTDRDataMgr.getLineState(neid, lineID);
                int midResultTransFinished = 0;
                midResultTransFinished = state.getMidResultState();
                Part part = new Part();
                part.setName("midResultTransFinished");
                part.setValue(String.valueOf(midResultTransFinished));
                output.addPart(part);
                int abortErrorCode = Integer.parseInt(output.getPartValue("abortErrorCode"));
                String abortReason = TENEListUtils.getString((String)("OTDR_STOP_ABNORMAL_EVENT_" + abortErrorCode));
                part = new Part();
                part.setName("abortReason");
                part.setValue(abortReason);
                output.addPart(part);
                stringValue = output.getPart("startYear").getValue().trim();
                startYear = Integer.parseInt(stringValue);
                if (currentWorkStatus != 2 || (startYear += timezonebean.nebaseyear) == 48 + timezonebean.nebaseyear || startYear == timezonebean.nebaseyear) {
                    part = new Part();
                    part.setName("startTime");
                    part.setValue("-");
                    output.addPart(part);
                    part = output.getPart("remainTime");
                    part.setValue("-");
                    continue;
                }
                stringValue = output.getPart("startMonth").getValue().trim();
                startMonth = Integer.parseInt(stringValue);
                stringValue = output.getPart("startDay").getValue().trim();
                startDay = Integer.parseInt(stringValue);
                stringValue = output.getPart("startHour").getValue().trim();
                startHour = Integer.parseInt(stringValue);
                stringValue = output.getPart("startMinute").getValue().trim();
                startMinute = Integer.parseInt(stringValue);
                stringValue = output.getPart("startSecond").getValue().trim();
                startSecond = Integer.parseInt(stringValue);
                Calendar calendar = Calendar.getInstance();
                calendar.set(startYear, startMonth - 1, startDay, startHour, startMinute, startSecond);
                SimpleDateFormat formatter = new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH);
                this.log.info("Refresh Line Status Convert To Applet Time. calendar: " + formatter.format(calendar.getTime()));
                startTime = TESLMOTDRDataMgr.convertCalendarToServerTime(calendar, neid);
                this.log.info("Refresh Line Status Convert To Applet Time. startTime: " + startTime);
                part = new Part();
                part.setName("startTime");
                part.setValue(startTime);
                output.addPart(part);
                remainTime = output.getPartValue("remainTime");
                remainTime = remainTime.trim();
                if (remainTime.equals("0")) {
                    remainTime = "-";
                }
                part = output.getPart("remainTime");
                part.setValue(remainTime);
            }
            this.handleStateInfo(tmpOper);
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    public void handleStateInfo(Operation oper) {
        Output output = null;
        int code = -1;
        int lineID = -1;
        byte refreshType = -1;
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code || 0 >= (lineID = Integer.parseInt(output.getPartValue("lineID"))) || -1 == (refreshType = (byte)TESLMRefreshTypeMgr.getInstance().getRefreshType(this.neid, lineID))) continue;
            this.updateLineRefreshInfo(this.neid, lineID, refreshType, output);
        }
    }

    private void updateLineRefreshInfo(int neID, int lineID, byte refreshType, Output output) {
        if (null == output) {
            return;
        }
        int testType = Integer.parseInt(output.getPart("testType").getValue());
        int currentWorkStatus = Integer.parseInt(output.getPart("currentWorkStatus").getValue());
        TELineRefreshInfo refreshInfo = TESLMRefreshTypeMgr.getInstance().getRefreshInfo(neID, lineID);
        if (1 == refreshType) {
            if (2 == currentWorkStatus) {
                TESLMRefreshTypeMgr.getInstance().refreshType(neID, lineID, refreshType);
                refreshInfo.setRefreshStatus(2);
            } else if (1 == currentWorkStatus) {
                TESLMRefreshTypeMgr.getInstance().stopTimer(neID, lineID);
            }
            if (3 == testType && 3 == currentWorkStatus && null != refreshInfo) {
                refreshInfo.waitingTestStatus();
            }
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

