/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import java.util.Timer;
import java.util.TimerTask;

public class TELineRefreshInfo {
    public static final byte DEFAULT_REFRESH_TYPE = 1;
    private static final byte REFRESH_STATUS_FIRST_TIME = 1;
    public static final byte REFRESH_STATUS_TESTING = 2;
    private static final byte REFRESH_STATUS_WAITING = 3;
    private static final byte REFRESH_STATUS_TEST_STOP = 4;
    private static final byte REFRESH_STATUS_CLOSE = 5;
    private int neID = -1;
    private int lineID = -1;
    private byte refreshType = 1;
    private int refreshTime = 0;
    private int refreshStatus = 0;
    private TERefreshCurrTimer timer = new TERefreshCurrTimer();

    public TELineRefreshInfo(int neID, int lineID) {
        this.neID = neID;
        this.lineID = lineID;
    }

    public TELineRefreshInfo(int neID, int lineID, byte refreshType) {
        this.neID = neID;
        this.lineID = lineID;
        this.refreshType = refreshType;
        if (0 == refreshType) {
            this.refreshStatus = 5;
        }
    }

    public void startTimer() {
        if (!this.timer.isRunning()) {
            this.stopStatusUpdate();
            this.timer.startTimer();
        }
    }

    public void stopStatusUpdate() {
        this.refreshTime = 0;
        this.refreshStatus = 4;
        if (0 == this.refreshType) {
            this.refreshStatus = 5;
        }
    }

    public void endTimer() {
        this.stopStatusUpdate();
        if (this.timer.isRunning()) {
            this.timer.endTimer();
        }
    }

    public int getNeID() {
        return this.neID;
    }

    public int getLineID() {
        return this.lineID;
    }

    public byte getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(byte refreshType) {
        this.refreshType = refreshType;
        if (0 == refreshType) {
            this.refreshStatus = 5;
        }
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(int refreshTime) {
        this.refreshTime = refreshTime;
    }

    public int getRefreshStatus() {
        return this.refreshStatus;
    }

    public void setRefreshStatus(int refreshStatus) {
        this.refreshStatus = refreshStatus;
    }

    public void waitingTestStatus() {
        this.refreshTime = 0;
        this.refreshStatus = 3;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lineID;
        result = 31 * result + this.neID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TELineRefreshInfo other = (TELineRefreshInfo)obj;
        if (this.lineID != other.lineID) {
            return false;
        }
        return this.neID == other.neID;
    }

    private class TERefreshCurrTimer {
        private static final int REFRESH_TIME = 600000;
        private static final int WAIT_TIME = 180000;
        private Timer timer;
        private boolean runningFlg = false;

        public synchronized void startTimer() {
            this.endTimer();
            this.timer = new Timer("SLMLineRefreshTimer");
            TERefreshCurrTimerTask task = new TERefreshCurrTimerTask();
            this.timer.scheduleAtFixedRate((TimerTask)task, 180000L, 600000L);
            this.runningFlg = true;
        }

        public synchronized boolean isRunning() {
            return this.runningFlg;
        }

        public synchronized void endTimer() {
            if (null != this.timer) {
                this.timer.cancel();
            }
            this.runningFlg = false;
        }

        private class TERefreshCurrTimerTask
        extends TimerTask {
            private TERefreshCurrTimerTask() {
            }

            @Override
            public void run() {
                this.refreshHander(TELineRefreshInfo.this.neID, TELineRefreshInfo.this.lineID);
            }

            private void refreshHander(int neID, int lineID) {
                try {
                    TENEExplorerBean neExplorerBean = new TENEExplorerBean(){

                        public boolean isNeedOperationlog() {
                            return false;
                        }
                    };
                    SubFunc subfunc = TECreateObjectFactory.parseFuncDesFile((int)neID).getSubFunc(2556003);
                    Datainterface inputData = new Datainterface();
                    inputData.setBussinessParams(new BussinessParams());
                    RowParams rowParams = new RowParams();
                    rowParams.addParam("neid", String.valueOf(neID));
                    rowParams.addParam("lineID", String.valueOf(lineID));
                    inputData.getBussinessParams().addRowParams(rowParams);
                    neExplorerBean.performBussinessProcess(neID, subfunc, inputData, null, null, null);
                    if (0 == TELineRefreshInfo.this.refreshTime) {
                        TELineRefreshInfo.this.refreshStatus = 1;
                    } else {
                        TELineRefreshInfo.this.refreshStatus = 2;
                    }
                    TELineRefreshInfo.this.refreshTime++;
                }
                catch (Exception ex) {
                    TELogFactory.getNormalLogger().error("TELineRefreshInfo.refreshHander() fail!", (Throwable)ex);
                }
            }
        }
    }
}

