/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class TEGetTestParam
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static final int NSCMD_SLM_GET_OTDRPWRRANG = 30226;
    private static final String OUT_OF_SER_TEST_MODE = "2";
    private static final String MIN_THR_POWER_VALUE = "-100";
    private static final String MAX_THR_POWER_VALUE = "175";
    private String testMode = "";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList list = super.getOperation(neid, subFunc, inputData, memeryData);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Operation oper = (Operation)iter.next();
            if (30226 != oper.getCmdid()) continue;
            Input input = oper.getInput();
            Part part = input.getPart("testMode");
            this.testMode = part.getValue();
            if (!OUT_OF_SER_TEST_MODE.equals(part.getValue())) continue;
            iter.remove();
            break;
        }
        return list;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (this.outputData != null && this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
                RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
                if (!this.getParamValue(rowParams, "power", false)) {
                    TELogFactory.getNormalLogger().info("Marine: modify optical power.");
                    continue;
                }
                if (!this.getParamValue(rowParams, "inSerThrMax", true)) {
                    TELogFactory.getNormalLogger().info("Marine: modify optical power.");
                    continue;
                }
                if (!this.getParamValue(rowParams, "inSerThrMin", true)) {
                    TELogFactory.getNormalLogger().info("Marine: modify optical power.");
                    continue;
                }
                this.getParamValue(rowParams, "lmiPower", false);
            }
        }
    }

    private boolean getParamValue(RowParams rowParams, String name, boolean isThrValue) {
        Param param = rowParams.getParam(name);
        if (null == param) {
            return false;
        }
        if (isThrValue && OUT_OF_SER_TEST_MODE.equals(this.testMode)) {
            return this.thrOutOfSerValueHandler(rowParams, name);
        }
        String stringValue = param.getValue();
        if (null == stringValue || stringValue.length() <= 0) {
            return false;
        }
        int signedValue = new BigInteger(stringValue).intValue();
        param.setValue(String.valueOf(signedValue));
        return true;
    }

    private boolean thrOutOfSerValueHandler(RowParams rowParams, String name) {
        if (null == name || "".equals(name)) {
            return false;
        }
        String stringValue = "inSerThrMin".equals(name) ? MIN_THR_POWER_VALUE : MAX_THR_POWER_VALUE;
        Param param = rowParams.getParam(name);
        int signedValue = new BigInteger(stringValue).intValue();
        param.setValue(String.valueOf(signedValue));
        return true;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer();
        Param[] params = rowparams.getParam();
        if (0 == params.length) {
            strBuf.append(this.res.getString("get_test_param"));
            return strBuf.toString();
        }
        String lineID = Datainterface.getParam((Param[])params, (String)"lineID").getValue();
        strBuf.append(this.res.getString("lineID")).append(": ").append(lineID);
        return strBuf.toString();
    }
}

