/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEGetMidReslut
extends TENEExplorerBean {
    private static final int ERROR_CODE_LINE_NOT_EXSIT = 42781;
    private static final int REFRESH_TYPE_START = 1;
    private static final int REFRESH_TYPE_STOP = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList rowParamList = inputData.getBussinessParams().getRowParamList();
        if (rowParamList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        int count = this.intputDataHandler(rowParamList);
        if (0 == count) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        ArrayList paramList = inputData.getBussinessParams().getRowParamList();
        if (null == paramList || paramList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private int intputDataHandler(List<RowParams> rowParamList) {
        int count = 0;
        Iterator<RowParams> iter = rowParamList.iterator();
        while (iter.hasNext()) {
            RowParams params = iter.next();
            String lineIDStr = params.getParam("lineID").getValue();
            if (null == lineIDStr || "".equals(lineIDStr)) continue;
            int lineID = Integer.parseInt(lineIDStr);
            boolean contains = TESLMRefreshTypeMgr.getInstance().containsLine(this.neid, lineID);
            if (!contains) {
                this.lineNotExistHandler(this.neid, lineID);
                continue;
            }
            byte refreshType = TESLMRefreshTypeMgr.getInstance().getRefreshType(this.neid, lineID);
            if (1 == refreshType) {
                iter.remove();
                this.startHandler(this.neid, lineID);
            } else if (0 == refreshType) {
                this.stopHandler(this.neid, lineID);
            } else {
                iter.remove();
            }
            ++count;
        }
        return count;
    }

    private void startHandler(int neID, int lineID) {
        TESLMRefreshTypeMgr.getInstance().startTimer(neID, lineID);
    }

    private void stopHandler(int neID, int lineID) {
        TESLMRefreshTypeMgr.getInstance().stopTimer(neID, lineID);
    }

    private void lineNotExistHandler(int neID, int lineID) {
        BussinessParams bussinessParams = new BussinessParams();
        RowParams tmpRowParams = new RowParams();
        RowErrors rowError = new RowErrors();
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)42781));
        Param param = new Param();
        param.setName("neID");
        param.setValue(String.valueOf(neID));
        rowError.addParam(param);
        param = new Param();
        param.setName("nename");
        param.setValue(TENEListMgr.getInstance().getNE(neID).getNEName() + "-" + lineID);
        rowError.addParam(param);
        param = new Param();
        param.setName("lineID");
        param.setValue(String.valueOf(lineID));
        rowError.addParam(param);
        tmpRowParams.addRowErrors(rowError);
        bussinessParams.addRowParams(tmpRowParams);
        this.outputData.setBussinessParams(bussinessParams);
    }
}

