/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.linemonitor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.linemonitor.TELineRefreshInfo;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class TEGetLineStatus
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private static final int NSCMD_SLM_GET_LINE = 30393;
    private static final int NSCMD_SLM_GET_LINEMEMO = 30405;
    private static final int NSCMD_SLM_GET_LINESTATE = 30402;
    private static final String NSERR_SLM_IDX_NOTEXIST = "42781";
    public static final String UNKNOWN = "UNKNOWN";
    private static final byte DEFAULT_REFRESH_TYPE = 1;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation tmpOper = null;
        int cmdID = 0;
        int code = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            if (cmdID == 30405) {
                Output[] outputs = tmpOper.getOutput();
                int outputLen = outputs.length;
                for (int j = 0; j < outputLen; ++j) {
                    String remark;
                    code = Integer.parseInt(outputs[j].getFault(0).getCode());
                    if (0 != code || null == (remark = outputs[j].getPartValue("remark"))) continue;
                    outputs[j].setPartValue("remark", remark.trim());
                }
            }
            if (cmdID == 30393) {
                this.handleLineInfo(tmpOper);
            }
            if (30402 != cmdID) continue;
            this.handleStateInfo(tmpOper);
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    public void handleStateInfo(Operation oper) {
        Output outputTmp = null;
        int code = -1;
        int lineID = -1;
        byte refreshType = -1;
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            outputTmp = oper.getOutput(i);
            code = Integer.parseInt(outputTmp.getFault(0).getCode());
            if (0 != code || 0 >= (lineID = Integer.parseInt(outputTmp.getPartValue("lineID"))) || -1 == (refreshType = (byte)TESLMRefreshTypeMgr.getInstance().getRefreshType(this.neid, lineID))) continue;
            this.updateLineRefreshInfo(this.neid, lineID, refreshType, outputTmp);
        }
    }

    public void handleLineInfo(Operation oper) {
        Output output = null;
        Part tmpPart = null;
        int lmuSlotId = -1;
        int lmuPortId = -1;
        int lmiNeId = -1;
        int lmiSlotId = -1;
        int lmiPortId = -1;
        String lmuBoardName = "";
        String lmuPortName = "";
        int lmuBoardType = -1;
        String lmiNeName = "";
        String lmiBoardName = "";
        String lmiPortName = "";
        String lmuFullName = "";
        String lmiFullName = "";
        TEBoard board = null;
        int code = -1;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        Integer indexIDInteger = null;
        TIntArrayList list = new TIntArrayList();
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code) continue;
            lmuSlotId = Integer.parseInt(output.getPart("lmuSlotId").getValue());
            lmuPortId = Integer.parseInt(output.getPart("lmuPortId").getValue());
            TENE lmuNe = TEConfigurationDataMgr.getInstance().getNE(this.neid);
            tmpPart = new Part();
            tmpPart.setName("lmuBoardName");
            board = lmuNe.getBoard(lmuSlotId);
            if (null == board) {
                lmuBoardName = UNKNOWN;
                lmuBoardType = 1229;
            } else {
                lmuBoardName = board.getBoardName();
                lmuBoardType = board.getBoardType();
            }
            tmpPart.setValue(lmuBoardName);
            output.addPart(tmpPart);
            tmpPart = new Part();
            tmpPart.setName("lmuPortName");
            lmuPortName = TEConfigurationDataMgr.getInstance().getPortName(lmuNe.getNEID(), lmuSlotId, lmuBoardType, lmuPortId);
            tmpPart.setValue(lmuPortName);
            output.addPart(tmpPart);
            tmpPart = new Part();
            tmpPart.setName("lmuFullName");
            lmuFullName = lmuSlotId + "-" + lmuBoardName + "-" + lmuPortName;
            tmpPart.setValue(lmuFullName);
            output.addPart(tmpPart);
            lmiNeId = Integer.parseInt(output.getPart("lmineid").getValue());
            lmiSlotId = Integer.parseInt(output.getPart("lmiSlotId").getValue());
            lmiPortId = Integer.parseInt(output.getPart("lmiPortId").getValue());
            TENE lmiNe = TENEListMgr.getInstance().getPhyNE(lmiNeId);
            if (null == lmiNe) {
                lmiNeName = UNKNOWN;
                lmiBoardName = UNKNOWN;
                lmiPortName = UNKNOWN;
            } else {
                lmiNeName = lmiNe.getNEName();
                lmiBoardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(lmiNe.getNEID(), 1226);
                lmiPortName = String.valueOf(TEConfigurationDataMgr.getInstance().getPortName(lmiNe.getNEID(), lmiSlotId, 1226, lmiPortId));
            }
            tmpPart = new Part();
            tmpPart.setName("lmiNeName");
            tmpPart.setValue(lmiNeName);
            output.addPart(tmpPart);
            lmiFullName = UNKNOWN.equals(lmiNeName) ? lmiNeName + "-" + lmiSlotId + "-" + lmiBoardName + "-" + lmiPortId + "(" + lmiPortName + ")" : lmiNeName + "-" + lmiSlotId + "-" + lmiBoardName + "-" + lmiPortName;
            tmpPart = new Part();
            tmpPart.setName("lmiBoardName");
            tmpPart.setValue(lmiBoardName);
            output.addPart(tmpPart);
            tmpPart = new Part();
            tmpPart.setName("lmiPortName");
            tmpPart.setValue(lmiPortName);
            output.addPart(tmpPart);
            tmpPart = new Part();
            tmpPart.setName("lmiFullName");
            tmpPart.setValue(lmiFullName);
            output.addPart(tmpPart);
            indexIDInteger = new Integer(output.getPartValue("lineID"));
            indexSet.add(indexIDInteger);
            list.add(indexIDInteger.intValue());
            tmpPart = new Part();
            byte refreshType = TESLMRefreshTypeMgr.getInstance().getRefreshType(this.neid, indexIDInteger);
            if (-1 == refreshType) {
                TESLMRefreshTypeMgr.getInstance().addData(this.neid, indexIDInteger, (byte)1);
                refreshType = 1;
            }
            tmpPart.setName("refreshType");
            tmpPart.setValue(String.valueOf(refreshType));
            output.addPart(tmpPart);
        }
        TESLMOTDRDataMgr.refreshNELineData(this.neid, list);
        TESLMRefreshTypeMgr.getInstance().refreshTypeData(this.neid, list);
    }

    private void updateLineRefreshInfo(int neID, int lineID, byte refreshType, Output output) {
        if (null == output) {
            return;
        }
        int testType = Integer.parseInt(output.getPart("testType").getValue());
        int currentWorkStatus = Integer.parseInt(output.getPart("currentWorkStatus").getValue());
        if (1 == refreshType) {
            TELineRefreshInfo refreshInfo;
            if (2 == currentWorkStatus) {
                TESLMRefreshTypeMgr.getInstance().refreshType(neID, lineID, refreshType);
            } else if (1 == currentWorkStatus) {
                TESLMRefreshTypeMgr.getInstance().stopTimer(neID, lineID);
            }
            if (3 == testType && 3 == currentWorkStatus && null != (refreshInfo = TESLMRefreshTypeMgr.getInstance().getRefreshInfo(neID, lineID))) {
                refreshInfo.waitingTestStatus();
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(NSERR_SLM_IDX_NOTEXIST));
        return list;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linemonitor").append(File.separator).append("linemonitor_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        if (0 == rowparams.getParam().length) {
            return this.res.getString("slm_get_line_status");
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.res.getString("lineID")).append(": ");
        Param[] params = rowparams.getParam();
        String lineID = Datainterface.getParam((Param[])params, (String)"lineID").getValue();
        strBuf.append(lineID);
        return strBuf.toString();
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj3 = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj3 ? String.valueOf(neid) : neObj3.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCode3 = 0;
            int len = outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                loginfo = new TELogInfo();
                rowparams = outputData.getBussinessParams().getRowParams(i);
                loginfo.setOperateDesc(this.getDetailStr(rowparams));
                if (0 != errorCode && 2 != errorCode && 1 != errorCode) {
                    loginfo.setResult(2);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                } else if (0 == errorCode) {
                    loginfo.setResult(0);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                } else {
                    int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                    errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                    tmpErrorCode3 = this.getOperResult(rowparams, errorRowParams);
                    if (tmpErrorCode3 != 0) {
                        loginfo.setResult(2);
                    } else {
                        loginfo.setResult(0);
                    }
                    loginfo.setErrCode(tmpErrorCode3);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)tmpErrorCode3));
                }
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i3 = 0; i3 < size; ++i3) {
                loginfo = (TELogInfo)loginfoList.get(i3);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i3)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

