/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.gencfg;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nemgr.marine.gencfg.TEWaveLengthInfo;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEWaveLengthInfoStaticData {
    private static final int ALL_PARITY = 0;
    private static final int ODD_PARITY = 1;
    private static final int EVEN_PARITY = 2;
    private TIntObjectHashMap<List<TEWaveLengthInfo>> waveLengthInfoData = new TIntObjectHashMap();
    private HashMap waveBandData = new HashMap();
    private static TEWaveLengthInfoStaticData m_instance = null;
    private static String WAVE_LENGTH_PATH = "nemgr" + File.separator + "marine" + File.separator + "conf" + File.separator + "gencfg" + File.separator + "waveinfo.xml";

    private TEWaveLengthInfoStaticData() {
        this.loadWaveLengthInfoData();
    }

    public String getWaveLengthInfo(int waveBandType, int waveNo) {
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthInfoList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            for (TEWaveLengthInfo waveLengthInfo : waveLengthInfoList) {
                if (waveLengthInfo.getWaveNo() != waveNo) continue;
                return waveLengthInfo.getWavenLength();
            }
        }
        return null;
    }

    public String getFrequency(int waveBandType, int waveNo) {
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthInfoList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            for (TEWaveLengthInfo waveLengthInfo : waveLengthInfoList) {
                if (waveLengthInfo.getWaveNo() != waveNo) continue;
                return waveLengthInfo.getFrequency();
            }
        }
        return null;
    }

    public String getCustomizeWaveNo(int waveBandType, int waveNo) {
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthInfoList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            for (TEWaveLengthInfo waveLengthInfo : waveLengthInfoList) {
                if (waveLengthInfo.getWaveNo() != waveNo) continue;
                return waveLengthInfo.getcustomizeNo();
            }
        }
        return null;
    }

    public int getWaveNoByCustNO(int waveBandType, String custWaveNo) {
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthInfoList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            for (TEWaveLengthInfo waveLengthInfo : waveLengthInfoList) {
                if (!waveLengthInfo.getcustomizeNo().equals(custWaveNo)) continue;
                return waveLengthInfo.getWaveNo();
            }
        }
        return -1;
    }

    public String getNumberWaveLengthFrequency(int waveBandType, int waveNo) {
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthInfoList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            for (TEWaveLengthInfo waveLengthInfo : waveLengthInfoList) {
                if (waveLengthInfo.getWaveNo() != waveNo) continue;
                return waveLengthInfo.getcustomizeNo() + "/" + waveLengthInfo.getWavenLength() + "/" + waveLengthInfo.getFrequency();
            }
        }
        return null;
    }

    public List getWaveLengthInfoList(int waveBandType, int waveParity) {
        return this.getWaveLengthInfoList(waveBandType, waveParity, Integer.MAX_VALUE);
    }

    public List getWaveLengthInfoList(int waveBandType, int waveParity, int maxWaveLenNo) {
        ArrayList<String> waveLengthInfoList = new ArrayList<String>();
        if (waveBandType == 255) {
            return waveLengthInfoList;
        }
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            Iterator iter = waveLengthList.iterator();
            switch (waveParity) {
                case 0: {
                    while (iter.hasNext()) {
                        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)iter.next();
                        if (waveLengthInfo.getWaveNo() > maxWaveLenNo) continue;
                        String waveStr = waveLengthInfo.getDisplayString();
                        waveLengthInfoList.add(waveStr.substring(0, waveStr.indexOf(":")));
                    }
                    break;
                }
                case 1: {
                    while (iter.hasNext()) {
                        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)iter.next();
                        if (waveLengthInfo.getWaveNo() % 2 == 0 || waveLengthInfo.getWaveNo() > maxWaveLenNo) continue;
                        String waveStr = waveLengthInfo.getDisplayString();
                        waveLengthInfoList.add(waveStr.substring(0, waveStr.indexOf(":")));
                    }
                    break;
                }
                case 2: {
                    while (iter.hasNext()) {
                        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)iter.next();
                        if (waveLengthInfo.getWaveNo() % 2 != 0 || waveLengthInfo.getWaveNo() > maxWaveLenNo) continue;
                        String waveStr = waveLengthInfo.getDisplayString();
                        waveLengthInfoList.add(waveStr.substring(0, waveStr.indexOf(":")));
                    }
                    break;
                }
            }
        }
        return waveLengthInfoList;
    }

    public void remove() {
        this.waveLengthInfoData.clear();
    }

    public static synchronized TEWaveLengthInfoStaticData getInstance() {
        if (m_instance == null) {
            m_instance = new TEWaveLengthInfoStaticData();
        }
        return m_instance;
    }

    private void loadWaveLengthInfoData() {
        StringBuffer path = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append(WAVE_LENGTH_PATH);
        Document doc = TEParseXMLFile.parseFile((String)path.toString());
        NodeList firstNodeList = doc.getChildNodes();
        Node firstNode = firstNodeList.item(0);
        NodeList secondNodeList = firstNode.getChildNodes();
        int m = secondNodeList.getLength();
        for (int i = 0; i < m; ++i) {
            Node secondNode = secondNodeList.item(i);
            if (!secondNode.getNodeName().equalsIgnoreCase("wave_band")) continue;
            String waveBandType = secondNode.getAttributes().getNamedItem("value").getNodeValue();
            String waveBandCustomerType = secondNode.getAttributes().getNamedItem("defined_waveband").getNodeValue();
            ArrayList<TEWaveLengthInfo> waveLengthInfoList = new ArrayList<TEWaveLengthInfo>();
            NodeList thirdNodeList = secondNode.getChildNodes();
            int n = thirdNodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node thirdNode = thirdNodeList.item(j);
                if (!thirdNode.getNodeName().equalsIgnoreCase("wave_info")) continue;
                NamedNodeMap namedNodeMap = thirdNode.getAttributes();
                String waveno = namedNodeMap.getNamedItem("waveno").getNodeValue();
                String wavelength = namedNodeMap.getNamedItem("wavelength").getNodeValue();
                String frequency = namedNodeMap.getNamedItem("frequency").getNodeValue();
                String customerno = namedNodeMap.getNamedItem("definedno").getNodeValue();
                TEWaveLengthInfo waveLengthInfo = new TEWaveLengthInfo(Integer.parseInt(waveno), wavelength, frequency, customerno);
                waveLengthInfoList.add(waveLengthInfo);
            }
            this.waveLengthInfoData.put(this.getWaveBandType(waveBandType), waveLengthInfoList);
            this.waveBandData.put(waveBandType, waveBandCustomerType);
        }
    }

    private int getWaveBandType(String waveBandTypeName) {
        if ("C_BANDL_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 0;
        }
        if ("C_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 1;
        }
        if ("L_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 2;
        }
        if ("C32_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 3;
        }
        if ("RAMAN_C_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 4;
        }
        if ("RAMAN_L_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 5;
        }
        if ("CWDM_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 6;
        }
        if ("SMC_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 7;
        }
        if ("C96A_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 8;
        }
        if ("C96B_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 9;
        }
        if ("C192_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 10;
        }
        if ("INVALIDATE_BAND".equalsIgnoreCase(waveBandTypeName)) {
            return 255;
        }
        return -1;
    }

    public static String getWaveBandTypeName(int bandNo) {
        String waveBandTypeName = "";
        switch (bandNo) {
            case 0: {
                waveBandTypeName = "C+L";
                break;
            }
            case 1: {
                waveBandTypeName = "C";
                break;
            }
            case 2: {
                waveBandTypeName = "L";
                break;
            }
            case 3: {
                waveBandTypeName = "C32";
                break;
            }
            case 4: {
                waveBandTypeName = "RAMAN_C";
                break;
            }
            case 5: {
                waveBandTypeName = "RAMAN_L";
                break;
            }
            case 6: {
                waveBandTypeName = "CWDM";
                break;
            }
            case 7: {
                waveBandTypeName = "SMC";
                break;
            }
            case 8: {
                waveBandTypeName = "C96A";
                break;
            }
            case 9: {
                waveBandTypeName = "C96B";
                break;
            }
            case 10: {
                waveBandTypeName = "C192";
                break;
            }
        }
        return waveBandTypeName;
    }

    public Map getWaveLengthInfoMap(int waveBandType, int waveParity, int maxWaveLenNo) {
        HashMap<String, String> waveLengthInfoMap = new HashMap<String, String>();
        Integer waveBandTypeInteger = waveBandType;
        if (this.waveLengthInfoData.containsKey(waveBandTypeInteger.intValue())) {
            ArrayList waveLengthList = (ArrayList)this.waveLengthInfoData.get(waveBandTypeInteger.intValue());
            for (TEWaveLengthInfo waveLengthInfo : waveLengthList) {
                int waveNo = waveLengthInfo.getWaveNo();
                switch (waveParity) {
                    case 0: {
                        if (waveNo > maxWaveLenNo) break;
                        String waveStr = waveLengthInfo.getDisplayString();
                        waveLengthInfoMap.put(waveLengthInfo.getcustomizeNo(), waveStr.substring(0, waveStr.indexOf(":")));
                        break;
                    }
                    case 1: {
                        if (waveNo % 2 == 0 || waveLengthInfo.getWaveNo() > maxWaveLenNo) break;
                        String waveStr = waveLengthInfo.getDisplayString();
                        waveLengthInfoMap.put(waveLengthInfo.getcustomizeNo(), waveStr.substring(0, waveStr.indexOf(":")));
                        break;
                    }
                    case 2: {
                        if (waveLengthInfo.getWaveNo() % 2 != 0 || waveLengthInfo.getWaveNo() > maxWaveLenNo) break;
                        String waveStr = waveLengthInfo.getDisplayString();
                        waveLengthInfoMap.put(waveLengthInfo.getcustomizeNo(), waveStr.substring(0, waveStr.indexOf(":")));
                        break;
                    }
                }
            }
        }
        return waveLengthInfoMap;
    }
}

