/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.gencfg.TEWaveLengthInfoStaticData;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class TEGenGetMarineWaveLengthBean
extends TENEExplorerBean {
    private static int[] waveBandTypeArr = new int[]{0, 1, 2, 3, 7, 6, 9, 255};
    private static final int ALL_PARITY = 0;
    private static final int MARINE_MAX = 96;
    private static final int NETYPE_BWS1600ST16 = 96;
    private static final int BDTYPE_TN96NS3 = 2347;
    private static final int BDTYPE_TN96TOA = 2348;
    private static final int BDTYPE_TN96TSXL = 2349;
    private static final int BDTYPE_TN96TQX = 2350;
    private static final int BDTYPE_TN96LTX = 2356;
    private static final int BDTYPE_TN96LSC = 2559;
    private int wavelengthnum = 96;
    private int wavelengthForLSCandLTX = 80;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            this.inputData = inputData;
            this.outputData = new Datainterface();
            BussinessParams bParams = new BussinessParams();
            TEWaveLengthInfoStaticData waveLengthDataInstance = TEWaveLengthInfoStaticData.getInstance();
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            if (96 == ne.getNEType() && boardType == 2347) {
                this.sendQueryMessage(neid, subFunc, inputData);
            }
            for (int i = 0; i < waveBandTypeArr.length; ++i) {
                RowParams rParam = new RowParams();
                rParam.addParam("bandType", String.valueOf(waveBandTypeArr[i]));
                Map waveLengthMap = waveLengthDataInstance.getWaveLengthInfoMap(waveBandTypeArr[i], 0, Integer.MAX_VALUE);
                ArrayList custWaveNOList = new ArrayList(waveLengthMap.keySet());
                Collections.sort(custWaveNOList, new WaveComparator());
                int count = 0;
                int size = custWaveNOList.size();
                for (int j = 0; j < size; ++j) {
                    int wavelength = Integer.parseInt(String.valueOf(custWaveNOList.get(j)));
                    if (waveBandTypeArr[i] == 1 && (96 != ne.getNEType() && wavelength > 96 || 96 == ne.getNEType() && wavelength > this.wavelengthnum) || waveBandTypeArr[i] != 255 && 96 == ne.getNEType() && (boardType == 2356 || boardType == 2559) && wavelength > this.wavelengthForLSCandLTX) continue;
                    rParam.addParam("custWaveNO" + j, String.valueOf(custWaveNOList.get(j)));
                    rParam.addParam("waveNO" + j, String.valueOf(waveLengthDataInstance.getWaveNoByCustNO(waveBandTypeArr[i], String.valueOf(custWaveNOList.get(j)))));
                    rParam.addParam("waveLengthInfo" + j, (String)waveLengthMap.get(custWaveNOList.get(j)));
                    ++count;
                }
                rParam.addParam("waveLengthCount", String.valueOf(count));
                bParams.addRowParams(rParam);
            }
            this.outputData.setBussinessParams(bParams);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private int sendQueryMessage(int neid, SubFunc subFunc, Datainterface inputData) {
        int result = 0;
        try {
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            if (null != definitions) {
                ArrayList<Operation> optList = new ArrayList<Operation>();
                Operation operation = definitions.getOperation("NSCMD_CFG_GET_WAVELENGTH_RANGE_ADJUST_EXT_EX");
                Input input = operation.getInput();
                input.setPartValue("slotid", rowParams.getParam("slotid").getValue());
                input.setPartValue("subCardId", rowParams.getParam("subCardId").getValue());
                input.setPartValue("port", rowParams.getParam("port").getValue());
                input.setPartValue("path", rowParams.getParam("path").getValue());
                optList.add(operation);
                result = this.sendMessage(neid, optList);
                if (0 != result) {
                    return result;
                }
                Operation tmpOper1 = (Operation)optList.get(0);
                Output[] outputArr1 = tmpOper1.getOutput();
                Output output1 = outputArr1[0];
                String strWavelengthnum = output1.getPart("W32PORT_ATTR_WAVELENGTH_RANGE").getValue();
                if (null != strWavelengthnum) {
                    this.wavelengthnum = Integer.parseInt(strWavelengthnum);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return result;
    }

    class WaveComparator
    implements Comparator {
        WaveComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (String.valueOf(o1).equals("dummy") || String.valueOf(o2).equals("dummy")) {
                return 1;
            }
            return Integer.parseInt(String.valueOf(o1)) - Integer.parseInt(String.valueOf(o2));
        }
    }
}

