/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fiber;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEQueryFiberBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "marine" + File.separator + "res" + File.separator + "stringresource_" + LANGUAGE + ".ini";
    private static final int SOURCE_PORT = 0;
    private static final int SINK_PORT = 1;
    private static final int FIND_NULL_ERROR_CODE = 38662;
    private ArrayList<String> noLoginNEList = new ArrayList();
    private static final int NOTLOGGEDIN_ERROR_CODE = 37926;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        String fiberLevel = resourceUtil.getString("fiberlevel");
        String fiberDirection = resourceUtil.getString("fiberdirection");
        if (null != operationList && operationList.size() > 0) {
            ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
            Operation operation = null;
            RowParams rowparams = null;
            Output output = null;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            boolean succ = false;
            boolean fault = false;
            boolean row_succ = false;
            operation = (Operation)operationList.get(0);
            TEDataConverter.handleSpecialStr((Operation)operation);
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                row_succ = TEDataConverter.handleRowError((Output)output, (ArrayList)filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean bFlag = false;
                    int n = output.getFaultCount();
                    for (int j = 0; j < n; ++j) {
                        String errorCode = output.getFault(j).getCode();
                        if (Integer.parseInt(errorCode) == 0) continue;
                        bFlag = true;
                        break;
                    }
                    if (!bFlag) {
                        rowparams = new RowParams();
                        Param param = new Param("fiberLevel", fiberLevel);
                        rowparams.addParam(param);
                        param = new Param("fiberDirection", fiberDirection);
                        rowparams.addParam(param);
                        int srcNEID = Integer.parseInt(output.getPartValue("srcNE"));
                        TENE srcNE = mgr.getNE(srcNEID);
                        String srcNEName = String.valueOf(srcNEID);
                        if (null != srcNE) {
                            srcNEName = srcNE.getNEName();
                        }
                        if (-1 == srcNEID) {
                            srcNEName = resourceUtil.getString("otherdevice");
                        }
                        param = new Param("srcNEName", srcNEName);
                        rowparams.addParam(param);
                        int srcSolt = Integer.parseInt(output.getPartValue("srcSolt"));
                        int bdType = mgr.getBoardType(srcNEID, srcSolt);
                        if (-1 != srcNEID && -1 == bdType && !this.noLoginNEList.contains(srcNEName)) {
                            this.noLoginNEList.add(srcNEName);
                        }
                        String srcBdTypeName = mgr.getBoardTypeName(srcNEID, bdType);
                        String srcPort = output.getPartValue("srcPort");
                        String srcPortName = this.getPortName(srcNEID, bdType, Integer.parseInt(srcPort), 0);
                        String srcSrName = TEBoardUtil.getSubrackNameFromSlot((int)srcNEID, (int)srcSolt);
                        if (!srcSrName.equals("")) {
                            param = new Param("fiberSrcSubrackName", srcSrName);
                            rowparams.addParam(param);
                        }
                        param = new Param("fiberSrcSlot", srcSolt + "");
                        rowparams.addParam(param);
                        param = new Param("fiberSrcBoardName", srcBdTypeName);
                        rowparams.addParam(param);
                        String fiberSrcPort = srcPort + "(" + srcPortName + ")";
                        param = new Param("fiberSrcPort", fiberSrcPort);
                        rowparams.addParam(param);
                        int snkNEID = Integer.parseInt(output.getPartValue("snkNE"));
                        TENE snkNE = mgr.getNE(snkNEID);
                        String snkNEName = String.valueOf(snkNEID);
                        if (null != snkNE) {
                            snkNEName = snkNE.getNEName();
                        }
                        if (-1 == snkNEID) {
                            snkNEName = resourceUtil.getString("otherdevice");
                        }
                        param = new Param("snkNEName", snkNEName);
                        rowparams.addParam(param);
                        int snkSolt = Integer.parseInt(output.getPartValue("snkSolt"));
                        bdType = mgr.getBoardType(snkNEID, snkSolt);
                        if (-1 != snkNEID && -1 == bdType && !this.noLoginNEList.contains(snkNEName)) {
                            this.noLoginNEList.add(snkNEName);
                        }
                        String snkBdTypeName = mgr.getBoardTypeName(snkNEID, bdType);
                        String snkPort = output.getPartValue("snkPort");
                        String snkPortName = this.getPortName(snkNEID, bdType, Integer.parseInt(snkPort), 1);
                        String snkSrName = TEBoardUtil.getSubrackNameFromSlot((int)snkNEID, (int)snkSolt);
                        if (!snkSrName.equals("")) {
                            param = new Param("fiberSnkSubrackName", snkSrName);
                            rowparams.addParam(param);
                        }
                        param = new Param("fiberSnkSlot", snkSolt + "");
                        rowparams.addParam(param);
                        param = new Param("fiberSnkBoardName", snkBdTypeName);
                        rowparams.addParam(param);
                        String fiberSnkPort = snkPort + "(" + snkPortName + ")";
                        param = new Param("fiberSnkPort", fiberSnkPort);
                        rowparams.addParam(param);
                        this.outputData.getBussinessParams().addRowParams(rowparams);
                    }
                }
                row_succ = false;
            }
            if (null != errorData && 0 != errorData.size()) {
                fault = true;
                rowparams = new RowParams();
                size = errorData.size();
                for (int i = 0; i < size; ++i) {
                    rowparams.addRowErrors((RowErrors)errorData.get(i));
                }
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
            for (String neName : this.noLoginNEList) {
                fault = true;
                rowparams = new RowParams();
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("nename", neName);
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
                rowparams.addRowErrors(rowError);
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
            this.outputData.setErrorMessage(new ErrorMessage());
            if (succ && !fault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            } else if (!succ && fault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else {
            this.outputData = null;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38662);
        return errorCodeList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfoObj = new TELogInfo();
            loginfoObj.setCmdID(subfunc.getCode());
            loginfoObj.setLocation(ipAddress);
            loginfoObj.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfoObj.setOperateObject("");
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfoObj.setOperateObject(String.valueOf(neid));
            } else {
                loginfoObj.setOperateObject(neObj.getNEName());
            }
            String desc = subfunc.getSubFuncDes(neid);
            loginfoObj.setOperateName(desc);
            loginfoObj.setOperateDesc(desc);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 0) {
                loginfoObj.setResult(0);
                loginfoObj.setErrCode(0);
                loginfoObj.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfoObj);
            } else {
                loginfoObj.setResult(2);
                if (errorCode == 1090646019) {
                    return;
                }
                if (errorCode == 2 || errorCode == 1) {
                    if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                        loginfoObj.setErrCode(errorCode);
                    }
                    int len = outputData.getBussinessParams().getRowParamsCount();
                    for (i = 0; i < len; ++i) {
                        RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                        int size = rowErrors.length;
                        for (int j = 0; j < size; ++j) {
                            loginfoObj.setErrCode(Integer.parseInt(rowErrors[i].getErrorMessage().getErrorcode()));
                            loginfoObj.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                            loginfoList.add(loginfoObj);
                        }
                    }
                } else {
                    loginfoObj.setErrCode(errorCode);
                    loginfoObj.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    loginfoList.add(loginfoObj);
                }
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private String getPortName(int neID, int iBoardType, int portID, int srcOrSnk) {
        String strPortName = "UNKNOWN";
        TEPortParaRecord portParaRecord = TEConfigurationDataMgr.getInstance().getPortParaRecord(neID, iBoardType, portID);
        if (null != portParaRecord) {
            switch (srcOrSnk) {
                case 0: {
                    strPortName = portParaRecord.outName;
                    break;
                }
                case 1: {
                    strPortName = portParaRecord.inName;
                    break;
                }
            }
        }
        return strPortName;
    }
}

