/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fiber;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEPrintFiberBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "ngwdm" + File.separator + "res" + File.separator + "stringresource_" + LANGUAGE + ".ini";
    private static final int SOURCE_PORT = 0;
    private static final int SINK_PORT = 1;
    private static final int FIND_NULL_ERROR_CODE = 38662;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TENE ne = mgr.getNE(neid);
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        String fiberLevel = resourceUtil.getString("fiberlevel");
        String fiberDirection = resourceUtil.getString("fiberdirection");
        if (null != operationList && operationList.size() > 0) {
            TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
            Operation operation = null;
            RowParams rowparams = null;
            Output output = null;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            boolean row_succ = false;
            operation = (Operation)operationList.get(0);
            TEDataConverter.handleSpecialStr((Operation)operation);
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                row_succ = TEDataConverter.handleRowError((Output)output, (ArrayList)filterErrorCodeList);
                if (!row_succ) continue;
                boolean flag = false;
                int n = output.getFaultCount();
                for (int j = 0; j < n; ++j) {
                    String errorCode = output.getFault(j).getCode();
                    if (Integer.parseInt(errorCode) == 0) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                rowparams = new RowParams();
                Param param = new Param("fiberLevel", fiberLevel);
                rowparams.addParam(param);
                param = new Param("fiberDirection", fiberDirection);
                rowparams.addParam(param);
                String neName = String.valueOf(neid);
                if (null != ne) {
                    neName = ne.getNEName();
                }
                param = new Param("fiberSrcNE", neName);
                rowparams.addParam(param);
                String srcSolt = output.getPartValue("srcSolt");
                int bdType = mgr.getBoardType(neid, Integer.parseInt(srcSolt));
                String srcBdTypeName = mgr.getBoardTypeName(neid, bdType);
                String srcPort = output.getPartValue("srcPort");
                String srcPortName = this.getPortName(neid, bdType, Integer.parseInt(srcPort), 0);
                String fiberSrcPort = srcSolt + "-" + srcBdTypeName + "-" + srcPort + "(" + srcPortName + ")";
                param = new Param("fiberSrcPort", fiberSrcPort);
                rowparams.addParam(param);
                param = new Param("fiberSnkNE", neName);
                rowparams.addParam(param);
                String snkSolt = output.getPartValue("snkSolt");
                bdType = mgr.getBoardType(neid, Integer.parseInt(snkSolt));
                String snkBdTypeName = mgr.getBoardTypeName(neid, bdType);
                String snkPort = output.getPartValue("snkPort");
                String snkPortName = this.getPortName(neid, bdType, Integer.parseInt(snkPort), 1);
                String fiberSnkPort = snkSolt + "-" + snkBdTypeName + "-" + snkPort + "(" + snkPortName + ")";
                param = new Param("fiberSnkPort", fiberSnkPort);
                rowparams.addParam(param);
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
        } else {
            this.outputData = null;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private String getPortName(int neID, int iBoardType, int portID, int srcOrSnk) {
        String portName = "UNKNOWN";
        TEPortParaRecord portParaRecord = TEConfigurationDataMgr.getInstance().getPortParaRecord(neID, iBoardType, portID);
        if (null != portParaRecord) {
            switch (srcOrSnk) {
                case 0: {
                    portName = portParaRecord.outName;
                    break;
                }
                case 1: {
                    portName = portParaRecord.inName;
                    break;
                }
            }
        }
        return portName;
    }
}

