/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fiber;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEDeleteFiberBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "marine" + File.separator + "res" + File.separator + "stringresource_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        int rowCount = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            RowParams rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (null == rowParams) continue;
            int errorCount = rowParams.getRowErrorsCount();
            for (int j = 0; j < errorCount; ++j) {
                RowErrors rowErrors = rowParams.getRowErrors(j);
                if (null == rowErrors) continue;
                int slotId = Integer.parseInt(rowErrors.getParam("srcsoltid").getValue());
                int bdType = this.cfgDataMgr.getBoardType(neid, slotId);
                String bdTypeName = this.cfgDataMgr.getBoardTypeName(neid, bdType);
                int portId = Integer.parseInt(rowErrors.getParam("srcportid").getValue());
                String portName = this.getPortName(slotId, portId, true);
                String source = "";
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotId);
                if (!"".equals(subrackName)) {
                    source = source + subrackName + "-";
                }
                source = source + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotId) + "-" + bdTypeName + "-" + portId + "(" + portName + ")";
                Param param = new Param("source", source);
                rowErrors.addParam(param);
                slotId = Integer.parseInt(rowErrors.getParam("snksoltid").getValue());
                bdType = this.cfgDataMgr.getBoardType(neid, slotId);
                bdTypeName = this.cfgDataMgr.getBoardTypeName(neid, bdType);
                portId = Integer.parseInt(rowErrors.getParam("snkportid").getValue());
                portName = this.getPortName(slotId, portId, false);
                String sink = "";
                subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotId);
                if (!"".equals(subrackName)) {
                    sink = sink + subrackName + "-";
                }
                sink = sink + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotId) + "-" + bdTypeName + "-" + portId + "(" + portName + ")";
                param = new Param("sink", sink);
                rowErrors.addParam(param);
            }
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            desc = desc + operateName + "," + this.resourceUtil.getString("source") + "[" + rowParams.getParam("source").getValue() + "]," + this.resourceUtil.getString("sink") + "[" + rowParams.getParam("sink").getValue() + "]";
            loginfo.setOperateDesc(desc);
            loginfo.setResult(0);
            loginfo.setErrCode(0);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                int slotId = Integer.parseInt(rowErrors[j].getParam("srcsoltid").getValue());
                int bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                int portId = Integer.parseInt(rowErrors[j].getParam("srcportid").getValue());
                String portName = this.getPortName(slotId, portId, true);
                String desc = operateName + "," + this.resourceUtil.getString("source") + "[" + operateObject + "-";
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                if (!"".equals(subrackName)) {
                    desc = desc + subrackName + "-";
                }
                desc = desc + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "-" + boardName + "-" + portId + "(" + portName + ")],";
                slotId = Integer.parseInt(rowErrors[j].getParam("snksoltid").getValue());
                bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                portId = Integer.parseInt(rowErrors[j].getParam("snkportid").getValue());
                portName = this.getPortName(slotId, portId, false);
                desc = desc + this.resourceUtil.getString("sink") + "[" + operateObject + "-";
                subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                if (!"".equals(subrackName)) {
                    desc = desc + subrackName + "-";
                }
                desc = desc + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "-" + boardName + "-" + portId + "(" + portName + ")]";
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo = new TELogInfo();
                loginfo.setCmdID(this.subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateObject(operateObject);
                loginfo.setOperateName(operateName);
                loginfo.setOperateDesc(desc);
                loginfo.setResult(2);
                loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(this.subfunc.getCode());
        loginfo.setLocation(ipAddress);
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateObject(operateObject);
        loginfo.setOperateName(operateName);
        loginfo.setOperateDesc(operateName);
        loginfo.setResult(2);
        loginfo.setErrCode(errorCode);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo);
    }

    private String getPortName(int slotId, int portId, boolean srcOrSnk) {
        int bdType;
        String portName = "";
        TEConfigurationDataMgr cfgData = TEConfigurationDataMgr.getInstance();
        TEPortParaRecord portParaRecord = cfgData.getPortParaRecord(this.neid, bdType = cfgData.getBoardType(this.neid, slotId), portId);
        if (null != portParaRecord) {
            if (srcOrSnk) {
                if (portParaRecord.outName != null) {
                    portName = portParaRecord.outName;
                }
            } else if (portParaRecord.inName != null) {
                portName = portParaRecord.inName;
            }
        }
        return portName;
    }
}

