/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TESetAISInsertBean
extends TENEExplorerBean {
    private static final String FILEPATH = "ngwdm" + File.separator + "conf" + File.separator + "fault" + File.separator + "ais" + File.separator + "aisalarm.xml";
    private static HashMap alarmList = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.operationList = this.convertToOperation(inputData);
            int result = this.sendMessage(neid);
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESetAISInsertBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    private ArrayList convertToOperation(Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        RowParams rowParam2 = null;
        String portID = null;
        String slotID = null;
        String colID = null;
        String pathID = null;
        String aisEnable = null;
        for (RowParams rowParam2 : rowParams) {
            portID = rowParam2.getParam("port").getValue();
            slotID = rowParam2.getParam("slotid").getValue();
            pathID = rowParam2.getParam("path").getValue();
            int len1 = rowParam2.getParamCount();
            for (int j = 4; j < len1; ++j) {
                colID = rowParam2.getParam(j).getName();
                if (!rowParam2.getParam(j).getModifyFlag()) continue;
                aisEnable = rowParam2.getParam(colID).getValue();
                operationList.add(this.setOperaion(portID, slotID, pathID, colID, aisEnable));
            }
        }
        return operationList;
    }

    private Operation setOperaion(String portID, String slotID, String pathID, String colID, String aisEnable) {
        Operation oper = null;
        if (null == alarmList) {
            this.initAlarmList();
        }
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_ALM2AISEX");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(slotID);
            part = input.getPart("port");
            part.setValue(portID);
            part = input.getPart("path");
            part.setValue(pathID);
            part = input.getPart("alarmid");
            part.setValue(alarmList.get(colID).toString());
            part = input.getPart("alarmEnable");
            part.setValue(aisEnable);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESetAISInsertBean.setOperaion() fail!", (Throwable)e);
        }
        return oper;
    }

    private void initAlarmList() {
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)this.neid, (String)FILEPATH)));
        NodeList options = doc.getElementsByTagName("option");
        alarmList = new HashMap();
        String name = null;
        String value = null;
        Element element = null;
        int len = options.getLength();
        for (int i = 0; i < len; ++i) {
            element = (Element)options.item(i);
            name = element.getAttribute("name");
            value = element.getAttribute("value");
            alarmList.put(name, value);
        }
    }
}

