/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.nemgr.marine.fault.TEBitErrThMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryBitErrorBean
extends TENEExplorerCommonForLogBean {
    private static final int TIME_OUT = 10;
    private int slotID = -1;
    private int boardType = -1;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private static Logger log = TELogFactory.getNormalLogger();
    private int level = -1;
    private ArrayList filterErrorCodeList = new ArrayList();
    private static final int ERROR_CODE_NOT_SUPPORTED = 38737;
    private static final int ERROR_CODE_NOT_SUPPORTED_BDTYPE = 38664;
    private static final String NE_NOT_LOGIN = "37926";
    HashMap bitErrorMap = new HashMap();
    boolean isBreanchBoard = false;
    private int errorCode = 0;
    private static final String OTN = "1";
    private static final String SDH = "2";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        block14: {
            BussinessParams bussinessParams;
            block13: {
                try {
                    this.neid = neid;
                    this.subfunc = subFunc;
                    this.inputData = inputData;
                    this.outputData = new Datainterface();
                    RowParams[] rParams = inputData.getBussinessParams().getRowParams();
                    this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
                    this.slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
                    this.operationList = this.queryBitError(neid);
                    if (null == this.operationList) {
                        if (this.isNeedOperationlog()) {
                            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                        }
                        log.info("The operationlist is null!");
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.errorCode));
                        return this.outputData;
                    }
                    int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
                    if (result == 0) {
                        this.handleMessage(result);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    }
                    if (this.isNeedOperationlog()) {
                        this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
                    }
                }
                catch (Exception e) {
                    log.error("query bit error fail!", (Throwable)e);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                    return this.outputData;
                }
                if (this.outputData.getErrorMessage().getErrorcode().equals("0")) break block13;
                bussinessParams = this.outputData.getBussinessParams();
                if (bussinessParams == null) {
                    return this.outputData;
                }
                if (bussinessParams.getRowParamsCount() == 0) {
                    return this.outputData;
                }
                RowParams rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
                RowErrors rowErrors = rowparams.getRowErrors(0);
                if (!rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) break block14;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int i = rowparams.getRowErrorsCount() - 1; i >= 0; --i) {
                    rowparams.removeRowErrors(rowparams.getRowErrors(i));
                }
                break block14;
            }
            bussinessParams = this.outputData.getBussinessParams();
            if (bussinessParams == null) {
                return this.outputData;
            }
            if (bussinessParams.getRowParamsCount() == 0) {
                return this.outputData;
            }
            Iterator iterator = this.outputData.getBussinessParams().getRowParamList().iterator();
            while (iterator.hasNext()) {
                RowParams rowparam = (RowParams)iterator.next();
                if (rowparam.getParamCount() >= 4) continue;
                iterator.remove();
            }
        }
        return this.outputData;
    }

    public void handleMessage(int result) {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (ne.getLogStatus() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)37926));
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result));
        BussinessParams bParams = new BussinessParams();
        this.outputData.setBussinessParams(bParams);
        ArrayList<TEPortBitErrorTh> BitErrorThList = new ArrayList<TEPortBitErrorTh>();
        int size = this.operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = (Operation)this.operationList.get(i);
            if (!oper.getOutput()[0].getFault()[0].getCode().equalsIgnoreCase(String.valueOf(0))) continue;
            Part[] parts = oper.getOutput()[0].getPart();
            String PortID = OTN;
            String PathID = OTN;
            TEBitErrorTh bitError = new TEBitErrorTh();
            for (Part part : parts) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("portID")) {
                    PortID = value;
                    continue;
                }
                if (name.equalsIgnoreCase("pathID")) {
                    PathID = value;
                    continue;
                }
                if (name.indexOf("biterr_type_") < 0) continue;
                int index = name.lastIndexOf("_");
                bitError.setThtype(new Integer(name.substring(index + 1)).intValue());
                bitError.setBitErrorvalue(value);
                String key = PortID + "-" + PathID;
                if (!this.bitErrorMap.containsKey(key)) continue;
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)this.bitErrorMap.get(key);
                tEPortBitErrorTh.getBitErrorThList().add(bitError.clone());
            }
        }
        for (TEPortBitErrorTh tEPortBitErrorTh : this.bitErrorMap.values()) {
            BitErrorThList.add(tEPortBitErrorTh);
        }
        Collections.sort(BitErrorThList);
        int port = 0;
        String nename = ne.getNEName();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardType);
        String portname = "";
        RowParams row = null;
        Param param = null;
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!subrackname.equals("")) {
            nename = nename + "-" + subrackname;
        }
        String monObject = nename + "-" + TEBoardUtil.slotIDNEToNM((int)this.slotID) + "-" + boardname + "-";
        int size2 = BitErrorThList.size();
        for (int i = 0; i < size2; ++i) {
            TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)BitErrorThList.get(i);
            port = tEPortBitErrorTh.getPortID();
            portname = TEConfigurationDataMgr.getInstance().getPortName(this.neid, this.slotID, this.boardType, port);
            row = tEPortBitErrorTh.toRowParams(this.isBreanchBoard);
            param = row.getParam("monObject");
            String showPath = this.getBitErrorPath(tEPortBitErrorTh.getPortID(), tEPortBitErrorTh.getPathID());
            param.setValue(monObject + portname + "-" + showPath);
            bParams.addRowParams(row);
        }
    }

    private String getBitErrorPath(int portID, int pathID) {
        int grade = TEOTNModelDataMgr.getInstance().getGradeFromBoard(this.boardType);
        if (!TEOTNModelDataMgr.getInstance().isSupportSimpleModePort(this.boardType, portID) || portID > 51) {
            return String.valueOf(pathID);
        }
        int layer = 8;
        int nmPath = TEOTNModelDataMgr.getInstance().getNmPath(layer, grade, pathID, this.boardType);
        if (nmPath != -1) {
            return TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(nmPath);
        }
        return String.valueOf(pathID);
    }

    private ArrayList queryBitError(int neID) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = null;
        try {
            ArrayList tEPortBitErrorThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
            Operation operServiceType = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_WDMMODE");
            Input inputServiceType = operServiceType.getInput();
            inputServiceType.setPartValue("slotid", this.slotID + "");
            int len = tEPortBitErrorThList.size();
            for (int i = 0; i < len; ++i) {
                TEPortBitErrorTh tEPortBitErrorTh = (TEPortBitErrorTh)tEPortBitErrorThList.get(i);
                int portID = tEPortBitErrorTh.getPortID();
                int pathID = tEPortBitErrorTh.getPathID();
                TEPortBitErrorTh bitErrorTh = new TEPortBitErrorTh();
                bitErrorTh.setPortID(portID);
                bitErrorTh.setPathID(pathID);
                ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
                if (this.tEBitErrThMgr.isNABitError(bitErrorThList)) continue;
                this.bitErrorMap.put(bitErrorTh.makeBitErrorKey(), bitErrorTh);
                bitErrorThList = this.tEBitErrThMgr.delNABitErrorList(bitErrorThList);
                int length = bitErrorThList.size();
                if (length % 2 != 0) {
                    oper = this.setFECQXData(this.slotID, portID, pathID);
                    operationList.add(oper);
                    --length;
                }
                for (int j = 0; j < length; ++j) {
                    TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(j);
                    int type = tEBitErrorTh.getThtype();
                    int bitType = this.tEBitErrThMgr.getBitType(type);
                    if (bitType == -1) {
                        ++j;
                        continue;
                    }
                    if (1 == type || 2 == type) {
                        oper = this.setSDHQXData(this.slotID, portID, pathID, bitType);
                        operationList.add(oper);
                    } else if (type > 2 && type < 18) {
                        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
                        this.level = Integer.parseInt(rParams[0].getParam("level").getValue());
                        oper = this.setOTNQXData(this.slotID, portID, pathID, bitType, this.level);
                        operationList.add(oper);
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return operationList;
    }

    private Operation setSDHQXData(int slotID, int portID, int pathID, int bitType) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_B1B2B3_SFSDTH");
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("bitType");
            part.setValue(String.valueOf(bitType));
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getSDHExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getSDHBadType(bitType));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setFECQXData(int slotID, int portID, int pathID) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_FLOAT_BEFORE_FEC_TH");
            Input input = null;
            if (oper != null) {
                input = oper.getInput();
                Part part = input.getPart("slotID");
                part.setValue(String.valueOf(slotID));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portID));
                part = input.getPart("pathID");
                part.setValue(String.valueOf(pathID));
                oper.getOutput(0).getPart("coefficient").setName("biterr_type_35");
                oper.getOutput(0).getPart("exponent").setName("biterr_type_1001");
            } else {
                oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BEFORE_FEC_TH");
                input = oper.getInput();
                Part part = input.getPart("slotID");
                part.setValue(String.valueOf(slotID));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portID));
                part = input.getPart("pathID");
                part.setValue(String.valueOf(pathID));
                oper.getOutput(0).getPart("excValue").setName("biterr_type_35");
            }
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setOTNQXData(int slotID, int portID, int pathID, int bitType, int level) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_OTNBIP8");
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("level");
            part.setValue(String.valueOf(level));
            part = input.getPart("bitType");
            part.setValue(String.valueOf(bitType));
            oper.getOutput(0).getPart("exceedValue").setName(this.tEBitErrThMgr.getOTNExceedType(bitType));
            oper.getOutput(0).getPart("badValue").setName(this.tEBitErrThMgr.getOTNBadType(bitType));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    @Override
    protected String descToString(Datainterface inputData) {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        strBuf.append(boardString);
        strBuf.append(TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID)).append("-").append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID)).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, this.boardType));
        return strBuf.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        this.filterErrorCodeList.add(38737);
        this.filterErrorCodeList.add(38664);
        this.filterErrorCodeList.add(38777);
        this.filterErrorCodeList.add(39555);
        return this.filterErrorCodeList;
    }
}

