/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmAISTh;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEQueryAISInsertBean
extends TENEExplorerBean {
    private static final String FILEPATH = "ngwdm" + File.separator + "conf" + File.separator + "fault" + File.separator + "ais" + File.separator + "aisalarm.xml";
    private static final String CFGGETISNULL = "38662";
    private static HashMap alarmList = null;
    private static int NSCMD_CFG_GET_ALM2AISEX = 28884;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.convertToOperation(subFunc, inputData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        ArrayList supportAIS = TEAlarmDataMgr.getInstance().getAISList(boardType);
        Operation oper = null;
        Input input = null;
        Part part = null;
        int len = supportAIS.size();
        for (int i = 0; i < len; ++i) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (int)NSCMD_CFG_GET_ALM2AISEX);
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("port");
            part.setValue("" + ((TEAlarmAISTh)supportAIS.get(i)).getPortID());
            part = input.getPart("path");
            part.setValue("" + ((TEAlarmAISTh)supportAIS.get(i)).getPathID());
            part = input.getPart("alarmid");
            part.setValue("0");
            operationList.add(oper);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        if (null == alarmList) {
            this.initAlarmList();
        }
        Operation operation = null;
        Output output = null;
        Part part = null;
        String alarmid = null;
        String alarmEnable = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            int len1 = operation.getOutputCount();
            for (int j = 0; j < len1; ++j) {
                output = operation.getOutput(j);
                part = output.getPart("alarmid");
                alarmEnable = output.getPartValue("alarmEnable");
                alarmid = part.getValue();
                output.removePart(part);
                part = output.getPart("alarmEnable");
                output.removePart(part);
                if (null == alarmid) continue;
                part = new Part();
                part.setName(alarmList.get(alarmid).toString());
                part.setValue(alarmEnable);
                output.addPart(part);
            }
        }
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList);
    }

    private Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        Operation operation = null;
        ArrayList errorDataList = new ArrayList();
        ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            this.joinOutput(subfunc, operation, errorDataList, filterErrorCodeList);
        }
        this.joinOperation(operationList);
        BussinessParams bussinessParams = new BussinessParams();
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(bussinessParams);
        RowParams rowparams = null;
        Output tempOutput = null;
        String name = null;
        String value = null;
        operation = (Operation)operationList.get(0);
        boolean row_succ = false;
        boolean succ = false;
        int len2 = operation.getOutputCount();
        for (int i = 0; i < len2; ++i) {
            tempOutput = operation.getOutput(i);
            row_succ = TEDataConverter.handleRowError((Output)tempOutput, (ArrayList)filterErrorCodeList);
            rowparams = new RowParams();
            if (!row_succ) continue;
            succ = true;
            int len1 = tempOutput.getPartCount();
            for (int j = 0; j < len1; ++j) {
                name = "nename";
                value = neObj.getNEName();
                rowparams.addParam(name, value);
                name = tempOutput.getPart(j).getName();
                value = tempOutput.getPart(j).getValue();
                rowparams.addParam(name, value);
            }
            bussinessParams.addRowParams(rowparams);
        }
        boolean fault = false;
        if (null != errorDataList && 0 != errorDataList.size()) {
            fault = true;
            rowparams = new RowParams();
            int size = errorDataList.size();
            for (int i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorDataList.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    private void joinOperation(ArrayList operationList) {
        Operation operation = null;
        Operation tempOperation = null;
        Output output = null;
        operation = (Operation)operationList.get(0);
        while (operationList.size() > 1) {
            tempOperation = (Operation)operationList.get(1);
            output = tempOperation.getOutput(0);
            operation.addOutput(output);
            operationList.remove(1);
        }
    }

    private void joinOutput(SubFunc subfunc, Operation operation, ArrayList errorDataList, ArrayList filterErrorCodeList) {
        ArrayList operationObject = TEDataConverter.getOperationObject((SubFunc)subfunc);
        Output curOutput = null;
        Output tmpOutput = null;
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        Part part = null;
        if (null == operation) {
            return;
        }
        int faultCode = 0;
        for (int i = 0; i < operation.getOutputCount(); ++i) {
            curOutput = operation.getOutput(i);
            faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
            if (0 != faultCode && !filterErrorCodeList.contains(new Integer(faultCode))) {
                errorDataList.add(TEDataConverter.handleErrorData((int)this.neid, (SubFunc)subfunc, (Input)operation.getInput(), (Output)curOutput));
            }
            operObjPart = TEDataConverter.getOperObjData((ArrayList)operationObject, (Input)operation.getInput(), (Output)curOutput);
            for (int j = operation.getOutputCount() - 1; j > 0; --j) {
                tmpOutput = operation.getOutput(j);
                tmpoperObjPart = TEDataConverter.getOperObjData((ArrayList)operationObject, (Input)operation.getInput(), (Output)tmpOutput);
                if (!TEDataConverter.compareOperObj((ArrayList)operObjPart, (ArrayList)tmpoperObjPart)) continue;
                part = tmpOutput.getPart(tmpOutput.getPartCount() - 1);
                curOutput.addPart(part);
                operation.removeOutput(j);
            }
        }
    }

    private void initAlarmList() {
        Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)this.neid, (String)FILEPATH)));
        NodeList options = doc.getElementsByTagName("option");
        alarmList = new HashMap();
        String name = null;
        String value = null;
        Element element = null;
        int len = options.getLength();
        for (int i = 0; i < len; ++i) {
            element = (Element)options.item(i);
            name = element.getAttribute("name");
            value = element.getAttribute("value");
            alarmList.put(value, name);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(new Integer(CFGGETISNULL));
        return codeList;
    }
}

