/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.nemgr.marine.fault.TEBitErrThMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;

public class TEApplyBitErrorBean
extends TENEExplorerCommonForLogBean {
    private ArrayList filterErrorCodeList = new ArrayList();
    private static final int TIME_OUT = 10;
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private static Logger log = TELogFactory.getNormalLogger();
    private int boardType = -1;
    private int level = -1;
    private static final String NE_NOT_LOGIN = "37926";
    private static final int ERROR_CODE_NOT_SUPPORTED = 38737;
    private static final int ERROR_CODE_NOT_SUPPORTED_BDTYPE = 38664;
    private String degLevel = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.user = user;
            this.outputData = new Datainterface();
            this.operationList = this.applyBitError(neid);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)10).retCode;
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("Apply bit error fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return this.outputData;
        }
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            BussinessParams bussinessParams = this.outputData.getBussinessParams();
            if (null == bussinessParams) {
                return this.outputData;
            }
            if (0 == bussinessParams.getRowParamsCount()) {
                return this.outputData;
            }
            RowParams rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
            RowErrors rowErrors = rowparams.getRowErrors(0);
            if (rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int i = rowparams.getRowErrorsCount() - 1; i >= 0; --i) {
                    rowparams.removeRowErrors(rowparams.getRowErrors(i));
                }
            }
        }
        return this.outputData;
    }

    private ArrayList applyBitError(int neID) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = null;
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        TEPortBitErrorTh tEPortBitErrorTh = null;
        int size = rParams.length;
        block0: for (int i = 0; i < size; ++i) {
            int slotID = Integer.parseInt(rParams[i].getParam("slotID").getValue());
            int portID = Integer.parseInt(rParams[i].getParam("portID").getValue());
            int pathID = Integer.parseInt(rParams[i].getParam("pathID").getValue());
            this.boardType = Integer.parseInt(rParams[0].getParam("boardType").getValue());
            ArrayList alarmBITThList = TEAlarmDataMgr.getInstance().getBITThList(this.boardType);
            int alarmBITThListSize = alarmBITThList.size();
            for (int k = 0; k < alarmBITThListSize; ++k) {
                tEPortBitErrorTh = (TEPortBitErrorTh)alarmBITThList.get(k);
                if (portID != tEPortBitErrorTh.getPortID() || pathID != tEPortBitErrorTh.getPathID()) continue;
                ArrayList bitErrorThList = tEPortBitErrorTh.getBitErrorThList();
                int length = bitErrorThList.size();
                if (length % 2 != 0) {
                    if (rParams[i].getParam("biterr_type_35") != null && !rParams[i].getParam("biterr_type_35").getValue().isEmpty()) {
                        int excValue = Integer.parseInt(rParams[i].getParam("biterr_type_35").getValue());
                        operation = this.setFECQXData(slotID, portID, pathID, excValue);
                        operationList.add(operation);
                    }
                    if (rParams[i].getParam("biterr_type_35_coefficient") != null && !rParams[i].getParam("biterr_type_35_coefficient").getValue().isEmpty()) {
                        int coefficient = Integer.parseInt(rParams[i].getParam("biterr_type_35_coefficient").getValue());
                        int exponent = Integer.parseInt(rParams[i].getParam("biterr_type_35_exponent").getValue());
                        operation = this.setFloatFECQXData(slotID, portID, pathID, coefficient, exponent);
                        operationList.add(operation);
                    }
                    --length;
                }
                for (int j = 0; j < length; ++j) {
                    int badValue;
                    TEBitErrorTh tEBitErrorTh = (TEBitErrorTh)bitErrorThList.get(j);
                    int type = tEBitErrorTh.getThtype();
                    int bitType = this.tEBitErrThMgr.getBitType(type);
                    if (bitType == -1) {
                        ++j;
                        continue;
                    }
                    if (1 == type || 2 == type) {
                        if (rParams[i].getParam(this.tEBitErrThMgr.getSDHExceedType(bitType)).getValue().equals("")) {
                            ++j;
                            continue;
                        }
                        int exceedValue = Integer.parseInt(rParams[i].getParam(this.tEBitErrThMgr.getSDHExceedType(bitType)).getValue());
                        badValue = Integer.parseInt(rParams[i].getParam(this.tEBitErrThMgr.getSDHBadType(bitType)).getValue());
                        operation = this.setSDHQXData(neID, slotID, portID, pathID, bitType, exceedValue, badValue);
                        operationList.add(operation);
                    } else if (type > 2 && type < 18) {
                        if (rParams[i].getParam(this.tEBitErrThMgr.getOTNExceedType(bitType)).getValue().equals("")) {
                            ++j;
                            continue;
                        }
                        this.level = Integer.parseInt(rParams[0].getParam("level").getValue());
                        int exceedValue = Integer.parseInt(rParams[i].getParam(this.tEBitErrThMgr.getOTNExceedType(bitType)).getValue());
                        badValue = Integer.parseInt(rParams[i].getParam(this.tEBitErrThMgr.getOTNBadType(bitType)).getValue());
                        operation = this.setOTNQXData(slotID, portID, pathID, this.level, bitType, exceedValue, badValue);
                        operationList.add(operation);
                    } else {
                        if (rParams[i].getParam(this.tEBitErrThMgr.getDEGExceedType(bitType)).getValue().equals("")) {
                            ++j;
                            continue;
                        }
                        this.degLevel = rParams[0].getParam("deglevel").getValue();
                        StringTokenizer st = new StringTokenizer(this.degLevel, "-");
                        while (st.hasMoreTokens()) {
                            int exceedValue = Integer.parseInt(rParams[i].getParam(this.tEBitErrThMgr.getDEGExceedType(bitType)).getValue());
                            int badValue2 = Integer.parseInt(rParams[i].getParam(this.tEBitErrThMgr.getDEGBadType(bitType)).getValue());
                            operation = this.setDEGQXData(slotID, portID, pathID, new Integer(st.nextToken()), bitType, exceedValue, badValue2);
                            operationList.add(operation);
                        }
                    }
                    ++j;
                }
                continue block0;
            }
        }
        return operationList;
    }

    private Operation setFloatFECQXData(int slotID, int portID, int pathID, int coefficient, int exponent) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_FLOAT_BEFORE_FEC_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_FLOAT_BEFORE_FEC_TH is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("coefficient");
            part.setValue(String.valueOf(coefficient));
            part = input.getPart("exponent");
            part.setValue(String.valueOf(exponent));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setFECQXData(int slotID, int portID, int pathID, int excValue) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_BEFORE_FEC_TH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_BEFORE_FEC_TH is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("excValue");
            part.setValue(String.valueOf(excValue));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setSDHQXData(int neID, int slotID, int portID, int pathID, int bitType, int exceedValue, int badValue) {
        Operation oper = null;
        Input input = null;
        Part part = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_B1B2B3_SFSDTH");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_B1B2B3_SFSDTH is not found!");
                return null;
            }
            input = oper.getInput();
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("bitType");
            part.setValue(String.valueOf(bitType));
            part = input.getPart("exceedValue");
            part.setValue(String.valueOf(exceedValue));
            part = input.getPart("badValue");
            part.setValue(String.valueOf(badValue));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setOTNQXData(int slotID, int portID, int pathID, int level, int bitType, int exceedValue, int badValue) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_OTNBIP8");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_OTNBIP8 is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part1 = input.getPart("slotID");
            part1.setValue(String.valueOf(slotID));
            part1 = input.getPart("portID");
            part1.setValue(String.valueOf(portID));
            part1 = input.getPart("pathID");
            part1.setValue(String.valueOf(pathID));
            part1 = input.getPart("level");
            part1.setValue(String.valueOf(level));
            part1 = input.getPart("bitType");
            part1.setValue(String.valueOf(bitType));
            part1 = input.getPart("exceedValue");
            part1.setValue(String.valueOf(exceedValue));
            part1 = input.getPart("badValue");
            part1.setValue(String.valueOf(badValue));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    private Operation setDEGQXData(int slotID, int portID, int pathID, int degLevel, int bitType, int exceedValue, int badValue) {
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_DEGTH_WM");
            if (null == oper) {
                log.info("The operation NSCMD_CFG_SET_DEGTH_WM is not found!");
                return null;
            }
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portID));
            part = input.getPart("pathID");
            part.setValue(String.valueOf(pathID));
            part = input.getPart("degLevel");
            part.setValue(String.valueOf(degLevel));
            part = input.getPart("bitType");
            part.setValue(String.valueOf(bitType));
            part = input.getPart("degValue");
            part.setValue(String.valueOf(exceedValue));
            part = input.getPart("degTime");
            part.setValue(String.valueOf(badValue));
        }
        catch (Exception e) {
            log.error("Parse Qx description file fail!", (Throwable)e);
            return null;
        }
        return oper;
    }

    @Override
    protected String descToString(Datainterface inputData) {
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuffer = new StringBuffer();
        String boardString = this.res.getString("board");
        int boardType = -1;
        int slotID = -1;
        strBuffer.append(boardString);
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        String operDes = rParams[0].getParam("operDes").getValue();
        int portID = Integer.parseInt(rParams[0].getParam("portID").getValue());
        boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        strBuffer.append(TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID)).append("-").append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID)).append("-").append(tEConfigurationDataMgr.getBoardTypeName(this.neid, boardType)).append("-").append(TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotID, boardType, portID));
        if (rParams[0].getParam("pathID") != null) {
            int pathID = Integer.parseInt(rParams[0].getParam("pathID").getValue());
            strBuffer.append("-").append(pathID);
        }
        strBuffer.append(",").append(operDes.substring(0, operDes.length() - 1));
        return strBuffer.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        this.filterErrorCodeList.add(38737);
        this.filterErrorCodeList.add(38664);
        this.filterErrorCodeList.add(38777);
        this.filterErrorCodeList.add(39555);
        return this.filterErrorCodeList;
    }
}

