/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.exc;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nemgr.marine.TENE_MARINE_1600ST16;
import com.huawei.nglct.nemgr.marine.exc.TEWDMUsableResource;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TEWDMGetUsableResourceBean
implements TENEMgrInterface {
    private Datainterface datainterface = new Datainterface();
    private int neID = -1;
    private int neType = -1;
    private ArrayList usableResourceList = new ArrayList();
    private int hasXCboard = -1;
    private boolean blSouthResource = false;
    private static final int BOARDTYPE_TBE = 1067;
    private static final Integer BDTYPE_TN96TOA = 2348;
    private static final int XC_BOARD = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        Param[] paramArr = rParams.getParam();
        ArrayList<Integer> sevTypeList = new ArrayList<Integer>();
        int len = paramArr.length;
        for (int i = 0; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (name.equalsIgnoreCase("neID")) {
                this.neID = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("sevType")) {
                sevTypeList.add(Integer.valueOf(value));
                continue;
            }
            if (!name.equalsIgnoreCase("issouthresource") || !value.equalsIgnoreCase("true")) continue;
            this.blSouthResource = true;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        if (ne == null) {
            this.datainterface.setBussinessParams(new BussinessParams());
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        this.neType = ne.getNEType();
        Vector boardList = null;
        if (ne instanceof TENE_MARINE_1600ST16) {
            boardList = ne.getBoardList();
        }
        if (boardList == null || boardList.size() == 0) {
            this.datainterface.setBussinessParams(new BussinessParams());
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        Collections.sort(boardList);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            int slotID = board.getSlotID();
            int simpleGrade = TEOTNModelDataMgr.getInstance().getGradeFromBoard(bdType);
            String bdName = board.getBoardName();
            ArrayList logicPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neID, slotID);
            if (this.blSouthResource && 1067 == board.getBoardType()) {
                ArrayList<String> sourthPort = new ArrayList<String>();
                ArrayList macport = mgr.getETHMACPort(this.neID, board.getBoardType());
                int size3 = macport.size();
                for (int k = 0; k < size3; ++k) {
                    int portID = (Integer)macport.get(k);
                    if (!logicPortList.contains(portID)) continue;
                    String portName = mgr.getPortName(this.neID, slotID, bdType, portID);
                    sourthPort.add(portID + "," + portName);
                }
                TEWDMUsableResource usableRes = new TEWDMUsableResource(slotID, bdType, bdName, new ArrayList(), 0, sourthPort);
                if (this.usableResourceList.contains(usableRes)) continue;
                this.usableResourceList.add(usableRes);
                continue;
            }
            if (board.getBoardType() == 0) {
                this.hasXCboard = 1;
            }
            ArrayList portList = mgr.getBoardPortList(this.neID, bdType, slotID);
            if (mgr.isDynPortBoardType(neid, bdType)) {
                portList.removeAll(mgr.getSupportedDynPortList(neid, bdType));
                portList.addAll(mgr.getLogicPortList(neid, slotID));
            }
            this.filtePortList(bdType, slotID, portList);
            Collections.sort(portList);
            int size2 = sevTypeList.size();
            for (int j = 0; j < size2; ++j) {
                TEWDMUsableResource usableRes;
                Integer sevType = (Integer)sevTypeList.get(j);
                ArrayList<String> usablePortList = new ArrayList<String>();
                if (!this.isLegal(slotID, sevType)) continue;
                int size3 = portList.size();
                for (int k = 0; k < size3; ++k) {
                    int portID = (Integer)portList.get(k);
                    ArrayList tmpSevTypeList = mgr.getXCLevelList(this.neID, bdType, portID, slotID, -1);
                    if (tmpSevTypeList == null || tmpSevTypeList.size() <= 0 || !tmpSevTypeList.contains(sevType)) continue;
                    String portName = mgr.getPortName(this.neID, slotID, bdType, portID);
                    String key = portID + "," + portName;
                    if (usablePortList.contains(key)) continue;
                    usablePortList.add(key);
                }
                if (usablePortList.size() <= 0) continue;
                ArrayList<String> sourthPort = new ArrayList<String>();
                if (1067 == bdType) {
                    ArrayList macport = mgr.getETHMACPort(this.neID, bdType);
                    int size32 = macport.size();
                    for (int k = 0; k < size32; ++k) {
                        int portID = (Integer)macport.get(k);
                        if (!logicPortList.contains(portID)) continue;
                        String portName = mgr.getPortName(this.neID, slotID, bdType, portID);
                        sourthPort.add(portID + "," + portName);
                    }
                }
                if (this.usableResourceList.contains(usableRes = new TEWDMUsableResource(slotID, bdType, bdName, usablePortList, sevType, simpleGrade, sourthPort))) continue;
                this.usableResourceList.add(usableRes);
            }
        }
        return this.constructRtnData();
    }

    public String getSimplePath(int bdType, List portList) {
        ArrayList pathList = new ArrayList();
        TEPortParaRecord paraRecod = null;
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            String[] ports = ((String)portList.get(i)).split(",");
            paraRecod = TECircuitPackDescription.getInstance().getCPPortPara(bdType, Integer.parseInt(ports[0]));
            if (paraRecod.snkPathIDList == null || paraRecod.snkPathIDList.isEmpty() || pathList.containsAll(paraRecod.snkPathIDList)) continue;
            pathList.addAll(paraRecod.snkPathIDList);
        }
        Collections.sort(pathList);
        StringBuffer sb = new StringBuffer();
        Iterator iterator = pathList.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next()).append(",");
        }
        return sb.toString();
    }

    public Datainterface constructRtnData() {
        BussinessParams bParams = new BussinessParams();
        Collections.sort(this.usableResourceList);
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            int size1;
            TEWDMUsableResource res = (TEWDMUsableResource)this.usableResourceList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("hasXCboard", String.valueOf(this.hasXCboard));
            rParams.addParam(param);
            param = new Param("sevType", String.valueOf(res.getSevType()));
            rParams.addParam(param);
            param = new Param("subrackid", String.valueOf(TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)res.getSlotID())));
            rParams.addParam(param);
            param = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)res.getSlotID()));
            rParams.addParam(param);
            param = new Param("showslotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neID, (int)res.getSlotID())));
            rParams.addParam(param);
            param = new Param("slotID", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("bdType", String.valueOf(res.getBoardType()));
            rParams.addParam(param);
            param = new Param("bdName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("simpleGrade", String.valueOf(res.getSimpleGrade()));
            rParams.addParam(param);
            param = res.getSimpleGrade() != -1 ? new Param("simplePath", this.getSimplePath(res.getBoardType(), res.getPorts())) : new Param("simplePath", "");
            rParams.addParam(param);
            if (null != res.getPorts() && res.getPorts().size() > 0) {
                param = new Param("port", (String)res.getPorts().get(0));
                size1 = res.getPorts().size();
                for (j = 1; j < size1; ++j) {
                    option = new Option((String)res.getPorts().get(j));
                    param.addOption(option);
                }
                rParams.addParam(param);
            }
            if (null != res.getSourthPorts() && res.getSourthPorts().size() > 0) {
                param = new Param("southPort", (String)res.getSourthPorts().get(0));
                size1 = res.getSourthPorts().size();
                for (j = 1; j < size1; ++j) {
                    option = new Option((String)res.getSourthPorts().get(j));
                    param.addOption(option);
                }
            }
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void filtePortList(int bdType, int slotID, List portList) {
        int portId = 0;
        TEPortParaRecord paraRecord = null;
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        int boardMode = TEGetBoardMode.getBoardMode((int)this.neID, (int)slotID);
        if (bdType == BDTYPE_TN96TOA) {
            this.filterLPPortList(bdType, slotID, portList);
            return;
        }
        if (boardMode != 0) {
            for (int i = portList.size() - 1; i >= 0; --i) {
                portId = (Integer)portList.get(i);
                paraRecord = cpDesc.getCPPortPara(bdType, portId);
                if (null == paraRecord || null == paraRecord.boardModeList || paraRecord.boardModeList.contains(boardMode)) continue;
                portList.remove(i);
            }
        } else {
            int subrackType = TEGetNEDomainVersion.getInstance().getDevType(TEBoardUtil.getSubrackType((int)this.neID, (int)this.neType, (int)slotID));
            for (int i = portList.size() - 1; i >= 0; --i) {
                portId = (Integer)portList.get(i);
                paraRecord = cpDesc.getCPPortPara(bdType, portId);
                if (null == paraRecord || null == paraRecord.boardModeList || paraRecord.boardModeList.contains(subrackType)) continue;
                portList.remove(i);
            }
        }
    }

    private void filterLPPortList(int bdType, int slotID, List portList) {
        int portId = 0;
        TEPortParaRecord paraRecord = null;
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        HashMap portModeMap = QueryWDMMode.queryPortMode((int)this.neID, (int)slotID);
        for (int i = portList.size() - 1; i >= 0; --i) {
            Integer portMode;
            portId = (Integer)portList.get(i);
            paraRecord = cpDesc.getCPPortPara(bdType, portId);
            if (portId > 200) {
                portId -= 198;
            }
            if ((portMode = (Integer)portModeMap.get(portId)) == null) {
                portList.remove(i);
                continue;
            }
            if (null == paraRecord || null == paraRecord.boardModeList || paraRecord.boardModeList.contains(portMode)) continue;
            portList.remove(i);
        }
    }

    private boolean isLegal(int slotID, int serv) {
        int bd = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, slotID);
        if (bd != 1572) {
            return true;
        }
        int ne_8800_2 = -1;
        int boardMode = TEGetBoardMode.getBoardMode((int)this.neID, (int)slotID);
        if (boardMode == 0 && bd == 1572 && serv == 528) {
            return false;
        }
        Vector subs = TENEListMgr.getInstance().getNE(this.neID).getSubrackList();
        int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)slotID);
        int len = subs.size();
        for (int i = 0; i < len; ++i) {
            if (Integer.valueOf(((TESubrack)subs.get(i)).getSubrackID()) != shelfID) continue;
            ne_8800_2 = Integer.valueOf(((TESubrack)subs.get(i)).getLogicSubrackType());
        }
        return ne_8800_2 != 74 || boardMode != 0 || bd != 1572 || serv != 529;
    }
}

