/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.exc;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.exc.ExcObjectInfo;
import com.huawei.nglct.nemgr.marine.exc.PctInfo;
import com.huawei.nglct.nemgr.marine.exc.TEWDMEXCUtil;
import com.huawei.nglct.nemgr.marine.exc.WorkObjectInfo;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEWDMEXCConvertNormalToSNCPBean
extends TECommonWriteLogBean {
    private Datainterface rtnDatainterface = new Datainterface();
    ArrayList rowErrorList = new ArrayList();
    BussinessParams rtnBParams = new BussinessParams();
    private static final int PROTECT_UNIT = 1;
    private static final int WORK_UNIT = 2;
    private boolean allSuccess = true;
    private boolean allFailed = true;
    private ArrayList usedPgIDList = new ArrayList();
    private static final String PROTECT_ID = "pgno";
    private static final int REACHE_MAX_NUM_PG = 78338;
    private static final int RESULT_IS_NULL = 38662;
    private static final int RESULT_IS_NULL_0 = 39326;
    private PctInfo pctInfo = new PctInfo();
    private WorkObjectInfo workOjectInfo = new WorkObjectInfo();
    private static final int SERVICE_TYPE_ODU1 = 529;
    private static final int SERVICE_TYPE_ODU2 = 530;
    private static final int BOARD_TN12NS2 = 1199;
    private static final int BOARD_TN11ND2 = 1200;
    private int oduFlexSlot = 0;
    private static final String FIXED_STATUS = "1";
    private List excOdu2AndNoFixed = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int i;
        this.neid = neid;
        RowParams[] rParamsArr = inputData.getBussinessParams().getRowParams();
        ArrayList<RowParams> sdCdnRowParamList = new ArrayList<RowParams>();
        ArrayList<RowParams> sfCdnRowParamList = new ArrayList<RowParams>();
        int neID = -1;
        ExcObjectInfo excObjectInfo = new ExcObjectInfo();
        int len = rParamsArr.length;
        for (i = 0; i < len; ++i) {
            if (rParamsArr[i].getParam("rowName").getValue().equalsIgnoreCase("basicInfo")) {
                neID = Integer.parseInt(rParamsArr[i].getParam("neID").getValue());
                if (!this.usedPgIDList.isEmpty()) {
                    this.usedPgIDList.clear();
                }
                this.pctInfo.parserParam(neid, rParamsArr[i]);
                this.workOjectInfo.parseParam(neid, rParamsArr[i]);
                excObjectInfo.parseParam(rParamsArr[i]);
                continue;
            }
            if (rParamsArr[i].getParam("rowName").getValue().equalsIgnoreCase("SDCondition")) {
                sdCdnRowParamList.add(rParamsArr[i]);
                continue;
            }
            if (!rParamsArr[i].getParam("rowName").getValue().equalsIgnoreCase("SFCondition")) continue;
            sfCdnRowParamList.add(rParamsArr[i]);
        }
        this.excOdu2AndNoFixed = this.getAllODU2EXC();
        this.doConvertToSncp(this.pctInfo, this.workOjectInfo, excObjectInfo, sdCdnRowParamList, sfCdnRowParamList);
        int size = this.rowErrorList.size();
        for (i = 0; i < size; ++i) {
            RowParams rParam = new RowParams();
            RowErrors rError = (RowErrors)this.rowErrorList.get(i);
            rParam.addRowErrors(rError);
            this.rtnBParams.addRowParams(rParam);
        }
        if (this.allSuccess) {
            this.rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        } else if (this.allFailed) {
            this.rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)2));
        } else {
            this.rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1));
        }
        this.rtnDatainterface.setBussinessParams(this.rtnBParams);
        this.writeLog(neID, subFunc, inputData, user, ipAddress, this.rtnDatainterface);
        return this.rtnDatainterface;
    }

    public int getPctGroupID() {
        int pctGPID = -1;
        for (int i = 1; i <= 5120; ++i) {
            if (this.usedPgIDList.contains(String.valueOf(i))) continue;
            pctGPID = i;
            break;
        }
        return pctGPID;
    }

    public void doConvertToSncp(PctInfo pctInfo, WorkObjectInfo workOjectInfo, ExcObjectInfo excObjectInfo, List sdList, List sfList) {
        ArrayList<Object> operList = new ArrayList<Object>();
        try {
            ArrayList<Operation> operListPGID = new ArrayList<Operation>();
            Operation operPGID = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OPS_GET_WXCPS_PROTPAIR");
            Input inputPGID = operPGID.getInput();
            inputPGID.setPartValue(PROTECT_ID, "0");
            operListPGID.add(operPGID);
            OperationResult resultPGID = TENECommMgr.getInstance().sendCommand(this.neid, operListPGID, 10);
            if (resultPGID.retCode != 0) {
                this.rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)resultPGID.retCode));
                return;
            }
            Operation tmpOperPGID = (Operation)operListPGID.get(0);
            for (Output outputPGID : tmpOperPGID.getOutput()) {
                Fault[] faultArrPGID = outputPGID.getFault();
                int code = -1;
                for (Fault fault : faultArrPGID) {
                    code = Integer.parseInt(fault.getCode());
                    if (code == 0 || code == 38662 || 39326 == code) continue;
                    this.allSuccess = false;
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorObj", String.valueOf(this.neid));
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                    this.rowErrorList.add(rowError);
                    return;
                }
                Part[] partArr = outputPGID.getPart();
                Part part = Definitions.getParam((Part[])partArr, (String)PROTECT_ID);
                this.usedPgIDList.add(part.getValue());
            }
            int groupID = this.getPctGroupID();
            if (-1 == groupID) {
                this.allSuccess = false;
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorObj", String.valueOf(this.neid));
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)78338));
                this.rowErrorList.add(rowError);
                return;
            }
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OPS_SET_SNCPS_NORTOPRO");
            Input input = oper.getInput();
            input.setPartValue("pctGroupID", String.valueOf(groupID));
            pctInfo.buildInputParam(input);
            workOjectInfo.buildInputParam(input);
            operList.add(oper.clone());
            if (pctInfo.isSNCPctType()) {
                Operation operOTN = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OPS_SET_SNCPS_TCMLEVEL");
                Input inputOTN = operOTN.getInput();
                inputOTN.setPartValue("pctGroupID", String.valueOf(groupID));
                inputOTN.setPartValue("serviceType", String.valueOf(pctInfo.getPctServiceType()));
                inputOTN.setPartValue("OTNLevel", String.valueOf(excObjectInfo.getOtnLevel()));
                operList.add(operOTN.clone());
            }
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operList, null, 10, true);
            if (result.retCode != 0) {
                this.rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result.retCode));
                return;
            }
            Fault fault = ((Operation)operList.get(0)).getOutput()[0].getFault()[0];
            int code = Integer.parseInt(fault.getCode());
            if (code != 0) {
                this.allSuccess = false;
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorObj", String.valueOf(this.neid));
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError);
                return;
            }
            this.allFailed = false;
            boolean blAutoCreate = this.doAutoCreateExc(this.neid, pctInfo, workOjectInfo);
            if (!blAutoCreate) {
                return;
            }
            ArrayList<Object> operList2 = new ArrayList<Object>();
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OPS_SET_WXCPS_REVPARA");
            oper.getInput().setPartValue("pctGroupID", String.valueOf(groupID));
            oper.getInput().setPartValue("resumeMode", String.valueOf(excObjectInfo.getRevertiveMode()));
            oper.getInput().setPartValue("resumeTime", String.valueOf(excObjectInfo.getwTRTime()));
            operList2.add(oper.clone());
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OPS_SET_WXCPS_SDFLAG");
            oper.getInput().setPartValue("pctGroupID", String.valueOf(groupID));
            oper.getInput().setPartValue("SDFlag", String.valueOf(excObjectInfo.getsDTriggerFlag()));
            operList2.add(oper.clone());
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_SNCPS_DELAYTIME");
            oper.getInput().setPartValue("pctGroupID", String.valueOf(groupID));
            oper.getInput().setPartValue("pctUnit", String.valueOf(2));
            oper.getInput().setPartValue("delayTime", String.valueOf(excObjectInfo.getDelayTime()));
            operList2.add(oper.clone());
            oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_SNCPS_DELAYTIME");
            oper.getInput().setPartValue("pctGroupID", String.valueOf(groupID));
            oper.getInput().setPartValue("pctUnit", String.valueOf(1));
            oper.getInput().setPartValue("delayTime", String.valueOf(excObjectInfo.getDelayTime()));
            operList2.add(oper.clone());
            OperationResult result2 = TECommuNEMgr.getInstance().sendCommand(this.neid, operList2, 10, this.subfunc);
            if (result2.retCode != 0) {
                return;
            }
            int size = operList2.size();
            for (int i = 0; i < size; ++i) {
                Operation tempOper = (Operation)operList2.get(i);
                Output output = tempOper.getOutput()[0];
                Fault fault2 = output.getFault()[0];
                int code2 = Integer.parseInt(fault2.getCode());
                if (code2 != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code2));
                    this.allSuccess = false;
                    RowErrors rowError = new RowErrors();
                    Param errorParam = new Param("errorBbj", String.valueOf(this.neid));
                    rowError.addParam(errorParam);
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code2));
                    this.rowErrorList.add(rowError);
                    continue;
                }
                this.allFailed = false;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMEXCConvertNormalToSNCPBean.doConvertToSncp() fail!", (Throwable)e);
        }
    }

    private Operation getAutoCreateExcOper(int sourceSlot, int sourcePort, int sourcePath, int sinkSlot, int sinkPort, int sinkPath, int oduflexSlot) {
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_NGWDM_ADD_XC");
        sourcePath = TEWDMEXCUtil.convertPathIDNM2Ne(this.neid, sourceSlot, sourcePath);
        sinkPath = TEWDMEXCUtil.convertPathIDNM2Ne(this.neid, sinkSlot, sinkPath);
        oper.getInput().setPartValue("srcSoltID", String.valueOf(sourceSlot));
        oper.getInput().setPartValue("srcPortNO", String.valueOf(sourcePort));
        oper.getInput().setPartValue("srcPathNO", String.valueOf(sourcePath));
        oper.getInput().setPartValue("srcReseredByte", String.valueOf(65535));
        oper.getInput().setPartValue("snkSoltID", String.valueOf(sinkSlot));
        oper.getInput().setPartValue("snkPortNO", String.valueOf(sinkPort));
        oper.getInput().setPartValue("snkPathNO", String.valueOf(TEWDMEXCUtil.convertPathIDNM2Ne(this.neid, sinkSlot, sinkPath)));
        oper.getInput().setPartValue("snkReseredByte", "65535");
        oper.getInput().setPartValue("level", String.valueOf(530));
        if (oper.getInput().getPart("oduflexslot") != null) {
            oper.getInput().setPartValue("oduflexslot", String.valueOf(oduflexSlot));
        }
        return (Operation)oper.clone();
    }

    private boolean doAutoCreateExc(int neID, PctInfo pctInfo, WorkObjectInfo workOjectInfo) {
        boolean blResult = true;
        if (pctInfo.getPctServiceType() == 529) {
            String firstExcStr;
            ArrayList<Object> operListAutoExc = new ArrayList<Object>();
            Operation oper = null;
            int worksourceBoard = TEConfigurationDataMgr.getInstance().getBoardType(neID, workOjectInfo.getWorkSourceSlot());
            int worksinkBoard = TEConfigurationDataMgr.getInstance().getBoardType(neID, workOjectInfo.getWorkSinkSlot());
            int pctsourceBoard = TEConfigurationDataMgr.getInstance().getBoardType(neID, pctInfo.getPctSourceSlot());
            if (this.isAutoCreateBoard(worksourceBoard) && this.isAutoCreateBoard(pctsourceBoard)) {
                firstExcStr = workOjectInfo.getWorkSourceSlot() + "-" + (workOjectInfo.getWorkSourcePort() + 20) + "-" + FIXED_STATUS + ":" + workOjectInfo.getWorkSourceSlot() + "-" + workOjectInfo.getWorkSourcePort() + "-" + FIXED_STATUS;
                String secondExcStr = pctInfo.getPctSourceSlot() + "-" + (pctInfo.getPctSourcePort() + 20) + "-" + FIXED_STATUS + ":" + pctInfo.getPctSourceSlot() + "-" + pctInfo.getPctSourcePort() + "-" + FIXED_STATUS;
                if (!this.excOdu2AndNoFixed.contains(firstExcStr)) {
                    oper = this.getAutoCreateExcOper(workOjectInfo.getWorkSourceSlot(), workOjectInfo.getWorkSourcePort() + 20, 1, workOjectInfo.getWorkSourceSlot(), workOjectInfo.getWorkSourcePort(), 1, pctInfo.getOduFlexSlot());
                    operListAutoExc.add(oper);
                }
                if (!this.excOdu2AndNoFixed.contains(secondExcStr)) {
                    oper = this.getAutoCreateExcOper(pctInfo.getPctSourceSlot(), pctInfo.getPctSourcePort() + 20, 1, pctInfo.getPctSourceSlot(), pctInfo.getPctSourcePort(), 1, pctInfo.getOduFlexSlot());
                    operListAutoExc.add(oper.clone());
                }
            } else if (this.isAutoCreateBoard(worksinkBoard) && !this.excOdu2AndNoFixed.contains(firstExcStr = workOjectInfo.getWorkSinkSlot() + "-" + workOjectInfo.getWorkSinkPort() + "-" + FIXED_STATUS + ":" + workOjectInfo.getWorkSinkSlot() + "-" + (workOjectInfo.getWorkSinkPort() + 20) + "-" + FIXED_STATUS)) {
                oper = this.getAutoCreateExcOper(workOjectInfo.getWorkSinkSlot(), workOjectInfo.getWorkSinkPort(), 1, workOjectInfo.getWorkSinkSlot(), workOjectInfo.getWorkSinkPort() + 20, 1, pctInfo.getOduFlexSlot());
                operListAutoExc.add(oper.clone());
            }
            if (!operListAutoExc.isEmpty()) {
                OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operListAutoExc, 10);
                if (result.retCode != 0) {
                    this.rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)result.retCode));
                    return false;
                }
                int code2 = 0;
                try {
                    code2 = TENEListUtils.sendVerify((int)neID);
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TEWDMEXCConvertNormalToSNCPBean.doAutoCreateExc() fail!", (Throwable)e);
                }
                if (code2 != 0) {
                    TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)neID, (int)code2));
                    blResult = false;
                }
            }
        }
        return blResult;
    }

    public boolean isAutoCreateBoard(int boardType) {
        boolean isResult = false;
        if (boardType == 1199 || boardType == 1200) {
            isResult = true;
        }
        return isResult;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        StringBuffer operDesc = new StringBuffer(100);
        StringBuffer filePath = new StringBuffer(100);
        filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("exc").append(File.separator).append("wdmexcInfo_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        operDesc.append(res.getString("workService")).append(':').append(res.getString("srcSlot")).append(' ');
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.workOjectInfo.getWorkSourceSlot());
        if (!"".equals(subrackName)) {
            operDesc.append(subrackName).append('-');
        }
        operDesc.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.workOjectInfo.getWorkSourceSlot())).append(',').append(res.getString("srcPort")).append(' ').append(this.workOjectInfo.getWorkSourcePort()).append(',').append(res.getString("srcPath")).append(' ').append(TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(this.workOjectInfo.getWorkSourcePath())).append(',').append(res.getString("snkSlot")).append(' ');
        subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.workOjectInfo.getWorkSinkSlot());
        if (!"".equals(subrackName)) {
            operDesc.append(subrackName).append('-');
        }
        operDesc.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.workOjectInfo.getWorkSinkSlot())).append(',').append(res.getString("snkPort")).append(' ').append(this.workOjectInfo.getWorkSinkPort()).append(',').append(res.getString("snkPath")).append(' ').append(TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(this.workOjectInfo.getWorkSinkPath())).append(';').append(res.getString("protectService")).append(':').append(res.getString("srcSlot")).append(' ');
        subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.pctInfo.getPctSourceSlot());
        if (!"".equals(subrackName)) {
            operDesc.append(subrackName).append('-');
        }
        operDesc.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.pctInfo.getPctSourceSlot())).append(',').append(res.getString("srcPort")).append(' ').append(this.pctInfo.getPctSourcePort()).append(',').append(res.getString("srcPath")).append(' ').append(TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(this.pctInfo.getPctSourcePath()));
        return operDesc.toString();
    }

    private List getAllODU2EXC() {
        ArrayList<Operation> list = new ArrayList<Operation>();
        ArrayList<String> listResult = new ArrayList<String>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_NGWDM_GET_XC");
            list.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, list, 10);
            if (result.retCode == 0) {
                Output temp = null;
                String sourceSlot = "";
                String sourcePort = "";
                String sourcePath = "";
                String sinkSlot = "";
                String sinkPort = "";
                String sinkPath = "";
                int size = oper.getOutputCount();
                for (int i = 0; i < size; ++i) {
                    temp = oper.getOutput(i);
                    if (!temp.getPart("serviceType").getValue().equals(String.valueOf(530)) || temp.getPart("xctype").getValue().equals(FIXED_STATUS)) continue;
                    sourceSlot = temp.getPart("sourceSlot").getValue();
                    sourcePort = temp.getPart("sourcePort").getValue();
                    sourcePath = temp.getPart("sourcePath").getValue();
                    sinkSlot = temp.getPart("sinkSlot").getValue();
                    sinkPort = temp.getPart("sinkPort").getValue();
                    sinkPath = temp.getPart("sinkPath").getValue();
                    listResult.add(sourceSlot + "-" + sourcePort + "-" + sourcePath + ":" + sinkSlot + "-" + sinkPort + "-" + sinkPath);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMEXCConvertNormalToSNCPBean.getAllODU2EXC() fail!", (Throwable)e);
        }
        return listResult;
    }
}

