/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor;

import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.GeographicCoordinate;

public final class PositionCalculator {
    public static GeographicCoordinate calcPointPosition(GeographicCoordinate startPoint, GeographicCoordinate endPoint, double dis_to_start) {
        if (null == startPoint || !startPoint.isLegal() || null == endPoint || !endPoint.isLegal()) {
            return null;
        }
        if (0.0 == dis_to_start) {
            return startPoint;
        }
        double angle = PositionCalculator.calcAngle(startPoint, endPoint);
        return PositionCalculator.calcLongAndLat(startPoint, dis_to_start, angle);
    }

    public static double calcAngle(GeographicCoordinate startPoint, GeographicCoordinate endPoint) {
        double x1 = startPoint.getLatitude().getLatitude();
        double y1 = startPoint.getLongitude().getLongitude();
        double x2 = endPoint.getLatitude().getLatitude();
        double y2 = endPoint.getLongitude().getLongitude();
        double pi = Math.PI;
        double w1 = y1 / 180.0 * pi;
        double j1 = x1 / 180.0 * pi;
        double w2 = y2 / 180.0 * pi;
        double j2 = x2 / 180.0 * pi;
        double dx = (w2 - w1) * startPoint.ed();
        double dy = (j2 - j1) * startPoint.ec();
        double angle = Math.atan(Math.abs(dx / dy)) * 180.0 / pi;
        double dLo = endPoint.getLongitude().getLongitude() - startPoint.getLongitude().getLongitude();
        double dLa = endPoint.getLatitude().getLatitude() - startPoint.getLatitude().getLatitude();
        if (dLo > 0.0 && dLa <= 0.0) {
            angle = 90.0 - angle + 90.0;
        } else if (dLo <= 0.0 && dLa < 0.0) {
            angle += 180.0;
        } else if (dLo < 0.0 && dLa >= 0.0) {
            angle = 90.0 - angle + 270.0;
        }
        return angle;
    }

    public static double calcAzimuth(GeographicCoordinate startPoint, GeographicCoordinate endPoint) {
        double x1 = startPoint.getLatitude().getLatitude();
        double y1 = startPoint.getLongitude().getLongitude();
        double x2 = endPoint.getLatitude().getLatitude();
        double y2 = endPoint.getLongitude().getLongitude();
        double pi = Math.PI;
        double w1 = y1 / 180.0 * pi;
        double j1 = x1 / 180.0 * pi;
        double w2 = y2 / 180.0 * pi;
        double j2 = x2 / 180.0 * pi;
        double ret = 4.0 * Math.pow(Math.sin((w1 - w2) / 2.0), 2.0) - Math.pow(Math.sin((j1 - j2) / 2.0) * (Math.cos(w1) - Math.cos(w2)), 2.0);
        ret = Math.sqrt(ret);
        ret /= Math.sin(Math.abs(j1 - j2) / 2.0) * (Math.cos(w1) + Math.cos(w2));
        ret = Math.atan(ret) / pi * 180.0;
        if (j1 > j2) {
            ret = w1 > w2 ? (ret += 180.0) : 180.0 - ret;
        } else if (w1 > w2) {
            ret = 360.0 - ret;
        }
        return ret;
    }

    public static double getDistance(GeographicCoordinate src, GeographicCoordinate dest) {
        if (!src.isLegal() || !dest.isLegal()) {
            return -1.0;
        }
        double latDis = src.radLat() - dest.radLat();
        double lonDis = src.radLon() - dest.radLon();
        double distance = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(latDis / 2.0), 2.0) + Math.cos(src.getLatitude().getLatitude()) * Math.cos(dest.getLatitude().getLatitude()) * Math.pow(Math.sin(lonDis / 2.0), 2.0)));
        distance = distance * 6378137.0 / 1000.0;
        distance = Math.round(distance * 10000.0) / 10000L;
        return distance;
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        GeographicCoordinate src = new GeographicCoordinate(lat1, lon1);
        GeographicCoordinate dest = new GeographicCoordinate(lat2, lon2);
        return PositionCalculator.getDistance(src, dest);
    }

    public static GeographicCoordinate calcLongAndLat(GeographicCoordinate startPoint, double distance, double angle) {
        double dx = distance * 1000.0 * Math.sin(angle * Math.PI / 180.0);
        double dy = distance * 1000.0 * Math.cos(angle * Math.PI / 180.0);
        double lon = (dx / startPoint.ed() + startPoint.radLon()) * 180.0 / Math.PI;
        double lat = (dy / startPoint.ec() + startPoint.radLat()) * 180.0 / Math.PI;
        GeographicCoordinate b = new GeographicCoordinate(lat, lon);
        return b;
    }

    public static GeographicCoordinate calcLongAndLat(double longitude, double latitude, double distance, double angle) {
        GeographicCoordinate a = new GeographicCoordinate(latitude, longitude);
        return PositionCalculator.calcLongAndLat(a, distance, angle);
    }
}

