/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor;

import java.text.DecimalFormat;

public class Longitude {
    public static final char EAST_ORT = 'E';
    public static final char WEST_ORT = 'W';
    private double longitude;
    private int degree;
    private DecimalFormat degreeformat;
    private double minute;
    private DecimalFormat minuteformat = new DecimalFormat("0.###'' ");
    private char orientation;

    public Longitude(double longitude) {
        this.longitude = longitude;
        this.degree = Math.abs((int)longitude);
        this.minute = (Math.abs(longitude) - (double)this.degree) * 60.0;
        this.orientation = (char)(longitude > 0.0 ? 69 : 87);
        char degree = '\u00b0';
        this.degreeformat = new DecimalFormat("#'" + degree + "'");
    }

    public Longitude(int degree, double minute, char orientation) {
        this.degree = Math.abs(degree);
        this.minute = Math.abs(minute);
        this.orientation = orientation;
        this.longitude = (double)degree + minute / 60.0;
        if (orientation == 'W' && this.longitude > 0.0) {
            this.longitude = -this.longitude;
        }
        char degreeChar = '\u00b0';
        this.degreeformat = new DecimalFormat("#'" + degreeChar + "'");
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public double getMinute() {
        return this.minute;
    }

    public void setMinute(double minute) {
        this.minute = minute;
    }

    public char getOrientation() {
        return this.orientation;
    }

    public void setOrientation(char orientation) {
        this.orientation = orientation;
    }

    public String toString() {
        return this.degreeformat.format(this.degree) + this.minuteformat.format(this.minute) + this.orientation;
    }
}

