/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor;

import java.text.DecimalFormat;

public class Latitude {
    public static final char NORTH_ORT = 'N';
    public static final char SOUTH_ORT = 'S';
    private double latitude;
    private int degree;
    private DecimalFormat degreeformat;
    private double minute;
    private DecimalFormat minuteformat = new DecimalFormat("0.###'' ");
    private char orientation;

    public Latitude(double latitude) {
        this.latitude = latitude;
        this.degree = Math.abs((int)latitude);
        this.minute = (Math.abs(latitude) - (double)this.degree) * 60.0;
        this.orientation = (char)(latitude > 0.0 ? 78 : 83);
        char degree = '\u00b0';
        this.degreeformat = new DecimalFormat("#'" + degree + "'");
    }

    public Latitude(int degree, double minute, char orientation) {
        this.degree = Math.abs(degree);
        this.minute = Math.abs(minute);
        this.orientation = orientation;
        this.latitude = (double)degree + minute / 60.0;
        if (orientation == 'S' && this.latitude > 0.0) {
            this.latitude = -this.latitude;
        }
        char degreeChar = '\u00b0';
        this.degreeformat = new DecimalFormat("#'" + degreeChar + "'");
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public double getMinute() {
        return this.minute;
    }

    public void setMinute(double minute) {
        this.minute = minute;
    }

    public char getOrientation() {
        return this.orientation;
    }

    public void setOrientation(char orientation) {
        this.orientation = orientation;
    }

    public String toString() {
        return this.degreeformat.format(this.degree) + this.minuteformat.format(this.minute) + this.orientation;
    }
}

