/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor;

import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.Latitude;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.Longitude;

public class GeographicCoordinate {
    public static final double EARTH_RADIUS = 6378137.0;
    public static final double POLAR_RADIUS = 6356725.0;
    private Latitude latitude = null;
    private Longitude longitude = null;

    public GeographicCoordinate() {
    }

    public GeographicCoordinate(Latitude latitude, Longitude longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public GeographicCoordinate(double latitude, double longitude) {
        this.latitude = new Latitude(latitude);
        this.longitude = new Longitude(longitude);
    }

    public Latitude getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Latitude latitude) {
        this.latitude = latitude;
    }

    public Longitude getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Longitude longitude) {
        this.longitude = longitude;
    }

    public double radLat() {
        return this.latitude.getLatitude() * Math.PI / 180.0;
    }

    public double radLon() {
        return this.longitude.getLongitude() * Math.PI / 180.0;
    }

    public double ec() {
        return 6356725.0 + 21412.0 * (90.0 - this.latitude.getLatitude()) / 90.0;
    }

    public double ed() {
        return this.ec() * Math.cos(this.radLat());
    }

    public boolean isLegal() {
        return null != this.latitude && null != this.longitude && Math.abs(this.latitude.getLatitude()) <= 90.0 && Math.abs(this.longitude.getLongitude()) <= 180.0;
    }
}

