/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultInfoPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultUserPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;

public final class TEQuickFaultDaoService {
    private static TEQuickFaultDaoService instance;
    public static final int EMAIL_TYPE = 1;
    private Logger logger = TELogFactory.getNormalLogger();

    private TEQuickFaultDaoService() {
    }

    public static synchronized TEQuickFaultDaoService getInstance() {
        if (instance == null) {
            instance = new TEQuickFaultDaoService();
        }
        return instance;
    }

    public int findMarineLineByNeID(Collection<TESLMLinePO> result, int lineID, int neID) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        result.clear();
        int resultCode = 1092743443;
        TEDaoOperationResult operationResult = null;
        try {
            int[] metadata = new int[]{neID};
            operationResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            if (operationResult != null) {
                resultCode = operationResult.getResult();
                if (resultCode == 0) {
                    for (Object item : operationResult.getData()) {
                        TESLMLinePO line = (TESLMLinePO)item;
                        if (line.getLineID() != lineID) continue;
                        result.add((TESLMLinePO)item);
                    }
                }
            } else {
                this.logger.error("Get Marine Line Fail: The daoOperationResult is null!");
            }
        }
        catch (Exception e1) {
            this.logger.error("Get Marine Line Fail: DB operation error!");
        }
        return resultCode;
    }

    public int findQuickFaultEmailUsers(Collection<TEMarineQuickFaultUserPO> result) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        result.clear();
        int resultCode = 1092743443;
        TEDaoOperationResult operationResult = null;
        try {
            operationResult = TECommonDaoService.findAll(TEMarineQuickFaultUserPO.class);
            if (operationResult != null) {
                resultCode = operationResult.getResult();
                if (resultCode == 0) {
                    for (Object item : operationResult.getData()) {
                        TEMarineQuickFaultUserPO user = (TEMarineQuickFaultUserPO)item;
                        if (user.getSendType() != 1) continue;
                        result.add(user);
                    }
                }
            } else {
                this.logger.error("Get Marine Cable Fail: The daoOperationResult is null!");
            }
        }
        catch (Exception e1) {
            this.logger.error("Get Marine Cable Fail: DB operation error!");
        }
        return resultCode;
    }

    public int saveQuickFaultInfo(TEMarineQuickFaultInfoPO quickFaultInfo) {
        int resultCode = 1092743443;
        TEDaoOperationResult operationResult = null;
        try {
            operationResult = TECommonDaoService.create((Object)quickFaultInfo);
            if (operationResult == null) {
                this.logger.error("Save Quick Fault user Fail: The daoOperationResult is null!");
            } else {
                resultCode = operationResult.getResult();
            }
        }
        catch (Exception e) {
            this.logger.error("Save Quick Fault user Fail: DB operation error!");
        }
        return resultCode;
    }

    public int saveQuickFaultInfoWithUser(TEMarineQuickFaultInfoPO quickFaultInfo) {
        ArrayList<TEMarineQuickFaultUserPO> users = new ArrayList<TEMarineQuickFaultUserPO>();
        int resultCode = this.findQuickFaultEmailUsers(users);
        if (resultCode == 0) {
            StringBuffer userNames = new StringBuffer();
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                userNames.append(((TEMarineQuickFaultUserPO)iterator.next()).getUserName());
                if (!iterator.hasNext()) continue;
                userNames.append(',');
            }
            quickFaultInfo.setToAddressee(userNames.toString());
        }
        resultCode = this.saveQuickFaultInfo(quickFaultInfo);
        return resultCode;
    }
}

