/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEPFEStatusGetter;
import com.huawei.nglct.nemgr.marine.e2ecommon.WriteLogInfo;

public class TEPFEStatusObj {
    private static double DIFFER = 0.001;
    private String neName;
    private int neid;
    private int voltage = 0;
    private int current = 0;
    private int queryResult = 0;
    private String errorInfo = "";

    public TEPFEStatusObj(int neid) {
        this.neid = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null != ne) {
            this.neName = ne.getNEName();
        }
    }

    public String getNeName() {
        return this.neName;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setNeName(String neName) {
        this.neName = neName;
    }

    public int getVoltage() {
        return this.voltage;
    }

    public void setVoltage(int voltage) {
        this.voltage = voltage;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(int queryResult) {
        this.queryResult = queryResult;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public void queryVoltage() {
        TEPFEStatusGetter statusGetter = new TEPFEStatusGetter();
        statusGetter.getPFEVoltageHandler(this);
    }

    public void queryVoltage(boolean isWriteLog, WriteLogInfo writeLogInfo) {
        TEPFEStatusGetter statusGetter = new TEPFEStatusGetter();
        statusGetter.getPFEVoltageHandler(this, isWriteLog, writeLogInfo);
    }

    public void queryHisPM(boolean isWriteLog, WriteLogInfo writeLogInfo) {
        TEPFEStatusGetter statusGetter = new TEPFEStatusGetter();
        statusGetter.getPFEHisVoltageHandler(this, isWriteLog, writeLogInfo);
    }

    public boolean approximate(Object obj) {
        if (!this.compareOddInfo(obj)) {
            return false;
        }
        TEPFEStatusObj other = (TEPFEStatusObj)obj;
        return !((double)Math.abs(this.voltage - other.voltage) > DIFFER * (double)Math.abs(this.voltage));
    }

    private boolean compareOddInfo(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEPFEStatusObj other = (TEPFEStatusObj)obj;
        if (this.current != other.current) {
            return false;
        }
        if (this.neName == null ? other.neName != null : !this.neName.equals(other.neName)) {
            return false;
        }
        if (this.neid != other.neid) {
            return false;
        }
        return this.queryResult == other.queryResult;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.current;
        result = 31 * result + (this.neName == null ? 0 : this.neName.hashCode());
        result = 31 * result + this.neid;
        result = 31 * result + this.queryResult;
        result = 31 * result + this.voltage;
        return result;
    }

    public boolean equals(Object obj) {
        if (!this.compareOddInfo(obj)) {
            return false;
        }
        TEPFEStatusObj other = (TEPFEStatusObj)obj;
        return this.voltage == other.voltage;
    }
}

