/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EConstants;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEPFEStatusObj;
import com.huawei.nglct.nemgr.marine.e2ecommon.WriteLogInfo;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.SimpleTimeZone;

class TEPFEStatusGetter {
    private static final String QUERY_PFE_PERFORMANCE = "Get_Board_Current_Performance_Browsing";
    private static final String QUERY_PFE_HISPERFORMANCE = "Get_Board_History_Performance_Browsing";
    private static final String RES_VOLTAGE = "RES_VOLTAGE";
    private static final String RES_CURRENT = "RES_CURRENT";
    public static final int TIMER_PERIOD = 120000;

    TEPFEStatusGetter() {
    }

    public void getPFEVoltageHandler(TEPFEStatusObj pfeStatus) {
        this.getPFEVoltageHandler(pfeStatus, false, null);
    }

    public void getPFEVoltageHandler(TEPFEStatusObj pfeStatus, boolean isWriteLog, WriteLogInfo writeLogInfo) {
        if (null == pfeStatus) {
            TELogFactory.getNormalLogger().error("getPFEVoltageHandler has a error! pfeStatus is null!");
            return;
        }
        this.queryPFEVoltage(pfeStatus, false);
        if (isWriteLog && null != writeLogInfo) {
            this.writeQueryLog(false, pfeStatus, writeLogInfo);
        }
    }

    public void getPFEHisVoltageHandler(TEPFEStatusObj pfeStatus, boolean isWriteLog, WriteLogInfo writeLogInfo) {
        if (null == pfeStatus) {
            TELogFactory.getNormalLogger().error("getPFEHisVoltageHandler has a error! pfeStatus is null!");
            return;
        }
        this.queryPFEVoltage(pfeStatus, true);
        if (isWriteLog && null != writeLogInfo) {
            this.writeQueryLog(true, pfeStatus, writeLogInfo);
        }
    }

    private void queryPFEVoltage(TEPFEStatusObj pfeStatus, boolean isHistory) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        int pfeNEID = pfeStatus.getNeid();
        boolean isConnect = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(pfeNEID);
        if (!isConnect) {
            pfeStatus.setQueryResult(1090625541);
            return;
        }
        TL1Operation oper = this.getQueryOper(isHistory, pfeNEID);
        if (null != oper) {
            operationList.add(oper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(pfeNEID, operationList, 30);
            TELogFactory.getNormalLogger().debug("Querying PFE Voltage is over! The result code is " + result.retCode);
            pfeStatus.setQueryResult(result.retCode);
            if (0 == result.retCode) {
                oper = (TL1Operation)operationList.get(0);
                this.getPFEStatus(pfeStatus, oper);
            }
        } else {
            pfeStatus.setQueryResult(1090605056);
        }
    }

    private TL1Operation getQueryOper(boolean isHistory, int pfeNEID) {
        TL1Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)pfeNEID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TL1Definitions create fail!");
        }
        TL1Operation oper = null;
        if (null != definitions) {
            oper = definitions.getTL1Operation("RTRV-PM-EQPT");
            InMsg inputMsg = oper.getInMsg();
            MsgBlock msgblock = inputMsg.getMsgBlock();
            msgblock.getPart("tmper").setValue("15-MIN");
            StringBuffer sb = new StringBuffer();
            sb.append("SLOT-5");
            inputMsg.getPart("aid").setValue(sb.toString());
            if (isHistory) {
                Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
                cal.setTimeInMillis(cal.getTimeInMillis() - 360000L - 900000L);
                String month = String.valueOf(cal.get(2) + 1);
                month = month.length() == 1 ? "0" + month : month;
                String date = String.valueOf(cal.get(5));
                date = date.length() == 1 ? "0" + date : date;
                String dateStr = month + "-" + date;
                String hour = String.valueOf(cal.get(10));
                hour = hour.length() == 1 ? "0" + hour : hour;
                String minute = String.valueOf(cal.get(12));
                minute = minute.length() == 1 ? "0" + minute : minute;
                String timeStr = hour + "-" + minute;
                inputMsg.getPart("mondat").setValue(dateStr);
                inputMsg.getPart("montm").setValue(timeStr);
            }
        }
        return oper;
    }

    private void getPFEStatus(TEPFEStatusObj pfeStatus, TL1Operation oper) {
        String pfeVoltageStr = null;
        String pfeCurrentStr = null;
        int len = oper.getOutMsgCount();
        for (int index = 0; index < len; ++index) {
            OutMsg outMsg = oper.getOutMsg(index);
            int retCode = outMsg.getFault().getCompletionCode();
            if (0 != retCode) {
                pfeStatus.setQueryResult(1107329312);
                pfeStatus.setErrorInfo(TETL1CommonUtil.getOperationResult((Fault)outMsg.getFault()));
                TELogFactory.getNormalLogger().error("OutMsg is fault! Error code: " + retCode);
                continue;
            }
            HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsg);
            String tmpValue = ((Part)hm.get("montype")).getValue();
            if ("PFEVOL-CUR".equals(tmpValue)) {
                pfeVoltageStr = ((Part)hm.get("monval")).getValue();
                if (null == pfeVoltageStr || pfeVoltageStr.isEmpty()) continue;
                pfeStatus.setVoltage(Integer.valueOf(pfeVoltageStr));
                continue;
            }
            if (!"PFECV-CUR".equals(tmpValue) || null == (pfeCurrentStr = ((Part)hm.get("monval")).getValue()) || pfeCurrentStr.isEmpty()) continue;
            pfeStatus.setCurrent(Integer.valueOf(pfeCurrentStr));
        }
        if (null == pfeVoltageStr || null == pfeCurrentStr) {
            pfeStatus.setQueryResult(1107329312);
            TELogFactory.getNormalLogger().error("Can not find the value of voltage or current!");
        } else {
            TELogFactory.getNormalLogger().debug(pfeStatus.getNeName() + "Voltage: " + pfeStatus.getVoltage() + "; Current: " + pfeStatus.getCurrent());
        }
    }

    private void writeQueryLog(boolean isHistory, TEPFEStatusObj pfeStatus, WriteLogInfo writeLogInfo) {
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        this.getQueryLogDetail(isHistory, pfeStatus, logInfoList);
        TEMarineLogMgrUtil.writeLog(writeLogInfo.getUserID(), writeLogInfo.getIpAddress(), logInfoList);
    }

    private void getQueryLogDetail(boolean isHistory, TEPFEStatusObj pfeStatus, List<TEMarineLogInfo> logInfoLst) {
        TEResourceUtil res = TEMarineE2EConstants.LOGRES;
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        StringBuilder logDetailStr = new StringBuilder();
        if (isHistory) {
            logInfo.setCmdID(2105093);
            logInfo.setOperateName(res.getString(QUERY_PFE_HISPERFORMANCE));
            logDetailStr.append(res.getString(QUERY_PFE_HISPERFORMANCE)).append(".");
        } else {
            logInfo.setCmdID(2101328);
            logInfo.setOperateName(res.getString(QUERY_PFE_PERFORMANCE));
            logDetailStr.append(res.getString(QUERY_PFE_PERFORMANCE)).append(".");
        }
        int errCode = pfeStatus.getQueryResult();
        logInfo.setErrCode(errCode);
        if (0 == errCode) {
            logInfo.setResult(0);
        } else {
            logInfo.setResult(2);
        }
        String neName = null == pfeStatus.getNeName() ? "Unknown" : pfeStatus.getNeName();
        logInfo.setOperateObject(neName);
        if (0 == pfeStatus.getQueryResult()) {
            logDetailStr.append(res.getString(RES_VOLTAGE)).append(":").append(pfeStatus.getVoltage()).append(";");
            logDetailStr.append(res.getString(RES_CURRENT)).append(":").append(pfeStatus.getCurrent()).append(".");
        }
        logInfo.setOperateDesc(logDetailStr.toString());
        logInfoLst.add(logInfo);
    }
}

