/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRouteGetter;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEMarineStationGetter {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public TEMarineStationPO getStationByNeName(String neName) {
        TEMarineStationPO station = null;
        TENE ne = TENEListMgr.getInstance().getNEByNEName(neName);
        if (null != ne) {
            station = this.getStationByNeID(ne.getNEID());
        }
        return station;
    }

    public TEMarineStationPO getStationByNeID(int neid) {
        if (0 == neid || -1 == neid) {
            return null;
        }
        TEMarineStationPO station = null;
        List<TEMarineStationPO> stationLst = this.getStationDataFromDB();
        if (null != stationLst) {
            for (TEMarineStationPO aStation : stationLst) {
                Set shelfSet = aStation.getShelfList();
                if (!this.isContainNe(shelfSet, neid)) continue;
                station = aStation;
                break;
            }
        }
        if (null == station) {
            normalLogger.error("Can not find the right station! \u00a1\u00aestation\u00a1\u00af is null!");
        } else {
            normalLogger.debug("Get the right station. Its name is " + station.getName());
        }
        return station;
    }

    private boolean isContainNe(Set<TEMarineStationNEPO> shelfSet, int neid) {
        boolean isContain = false;
        if (null != shelfSet && !shelfSet.isEmpty()) {
            for (TEMarineStationNEPO nePO : shelfSet) {
                if (nePO.getNeID() != (long)neid) continue;
                isContain = true;
                break;
            }
        }
        return isContain;
    }

    public boolean isStnContainNe(TEMarineStationPO station, int neid) {
        if (null == station) {
            normalLogger.debug("station is null! the result of isStnContainNe is false!");
            return false;
        }
        Set shelfSet = station.getShelfList();
        return this.isContainNe(shelfSet, neid);
    }

    public boolean isSTNContainCTB(TEMarineStationPO station, String ctbName) {
        if (null == station) {
            normalLogger.debug("station is null! the result of isSTNContainCTB is false!");
            return false;
        }
        Set ctbSet = station.getCTBList();
        if (null != ctbSet && !ctbSet.isEmpty()) {
            for (TEMarineCTBPO ctb : ctbSet) {
                if (!ctb.getName().equals(ctbName)) continue;
                return true;
            }
        }
        return false;
    }

    public List<TEMarineStationPO> getStationDataFromDB() {
        TEDaoOperationResult dbResult = null;
        ArrayList<TEMarineStationPO> stationList = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            return null;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                stationList = new ArrayList<TEMarineStationPO>();
                for (Object obj : data) {
                    TEMarineStationPO stationPO = (TEMarineStationPO)obj;
                    stationList.add(stationPO);
                }
            }
        } else {
            normalLogger.info("Get Station operation is fail! Error Code is " + retCode);
        }
        return stationList;
    }

    public List<Integer> getNEsFromStationByType(TEMarineStationPO station, int neType) {
        ArrayList<Integer> neidList = new ArrayList<Integer>();
        if (null != station) {
            Set stationNeSet = station.getShelfList();
            for (TEMarineStationNEPO stationNE : stationNeSet) {
                TENE ne = TENEListMgr.getInstance().getNE((int)stationNE.getNeID());
                if (null == ne || neType != ne.getNEType()) continue;
                neidList.add(ne.getNEID());
            }
        }
        return neidList;
    }

    public TEMarineStationPO getStationByID(int stationID) {
        TEMarineStationPO station = null;
        List<TEMarineStationPO> stationLst = this.getStationDataFromDB();
        if (null != stationLst) {
            for (TEMarineStationPO aStation : stationLst) {
                if (aStation.getStationID() != stationID) continue;
                station = aStation;
                break;
            }
        }
        if (null == station) {
            normalLogger.error("Can not find the right station! \u00a1\u00aestation\u00a1\u00af is null!");
        } else {
            normalLogger.debug("Get the right station. Its name is " + station.getName());
        }
        return station;
    }

    public TEMarineStationPO getStationByName(String stationName) {
        TEMarineStationPO station = null;
        List<TEMarineStationPO> stationLst = this.getStationDataFromDB();
        if (null == stationLst || stationLst.isEmpty()) {
            normalLogger.error("Can not get any station!");
        } else {
            for (TEMarineStationPO aStation : stationLst) {
                if (!aStation.getName().equals(stationName)) continue;
                station = aStation;
                break;
            }
        }
        if (null == station) {
            normalLogger.error("Can not find the station named " + stationName);
        } else {
            normalLogger.debug("Get the right station. Its name is " + station.getName());
        }
        return station;
    }

    public List<TEMarineCTBPO> doQueryCTBInfo() {
        ArrayList<TEMarineCTBPO> ctbList = new ArrayList<TEMarineCTBPO>();
        List<TEMarineStationPO> stnList = this.getStationDataFromDB();
        if (null == stnList || stnList.isEmpty()) {
            normalLogger.debug("stnList is null or empty!");
        } else {
            for (TEMarineStationPO stationPO : stnList) {
                ctbList.addAll(stationPO.getCTBList());
            }
        }
        return ctbList;
    }

    public TEMarineCablePO geCablePObyCTB(TEMarineCTBPO ctbPO, List<TEMarineCablePO> cableList) {
        if (null == ctbPO) {
            normalLogger.debug("ctbPO is null!");
            return null;
        }
        if (null == cableList || cableList.isEmpty()) {
            TEMarineRouteGetter routeGetter = new TEMarineRouteGetter();
            cableList = routeGetter.getAllCable();
        }
        if (null == cableList) {
            normalLogger.error("cableList is null!");
            return null;
        }
        for (TEMarineCablePO tmpCablePO : cableList) {
            if (!tmpCablePO.getSrcNodeName().equals(ctbPO.getName()) && !tmpCablePO.getSinkNodeName().equals(ctbPO.getName())) continue;
            return tmpCablePO;
        }
        return null;
    }

    public TEMarineEndCablePO getEndCable(int stationID, int neid, int slotid) {
        TEMarineEndCablePO endCable = null;
        List<TEMarineEndCablePO> endCableLst = this.getEndCableInStnFromDB(stationID);
        if (null != endCableLst && !endCableLst.isEmpty()) {
            for (TEMarineEndCablePO anEndCable : endCableLst) {
                if ((anEndCable.SrcNEID != (long)neid || anEndCable.SrcBoardID != slotid) && (anEndCable.DstNEID != (long)neid || anEndCable.DstBoardID != slotid)) continue;
                endCable = anEndCable;
                break;
            }
        }
        return endCable;
    }

    public List<TEMarineEndCablePO> getEndCableInStnFromDB(int stnID) {
        TEDaoOperationResult dbResult = null;
        ArrayList<TEMarineEndCablePO> endCableList = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineEndCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
        } else {
            int retCode = dbResult.getResult();
            if (0 == retCode) {
                List data = dbResult.getData();
                if (null != data && !data.isEmpty()) {
                    endCableList = new ArrayList<TEMarineEndCablePO>();
                    for (Object obj : data) {
                        TEMarineEndCablePO endCablenPO = (TEMarineEndCablePO)obj;
                        if (endCablenPO.getStnID() != stnID) continue;
                        endCableList.add(endCablenPO);
                    }
                }
            } else {
                normalLogger.info("Get Station operation is fail! Error Code is " + retCode);
            }
        }
        return endCableList;
    }
}

