/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.marine.bumanagement.budataoperation.TEBUDataBaseOperService;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRoute;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineStationGetter;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCTBPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEMarineRouteGetter {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    public TEMarineRoute getMarineRouteByStation(TEMarineStationPO station, String pfeName) {
        TEMarineRoute route;
        if (null == station) {
            normalLogger.error("start station is null!");
            return null;
        }
        List<TEMarineCablePO> cableLst = this.getAllCable();
        Map<String, TEMarineBUPO> buMap = this.getAllBU();
        if (null == cableLst || cableLst.isEmpty()) {
            route = null;
            normalLogger.error("Can not find any cable info! cableLst is null or empty!");
        } else {
            TEMarineCablePO firstCable;
            route = new TEMarineRoute();
            route.setStartStation(station);
            TEMarineStnEleCblDBOper eCblDBOper = TEMarineStnEleCblDBOper.getInstance();
            TEMarineStnEleCablePO eCable = eCblDBOper.getStnECableByNodeName(pfeName);
            if (null == eCable) {
                firstCable = this.getCableByStation(cableLst, station);
            } else {
                String ctbname = 0L == eCable.getSrcNEID() ? eCable.getSrcNEName() : eCable.getDstNEName();
                firstCable = this.getCableByCTB(cableLst, ctbname);
            }
            if (null != firstCable) {
                route.addACable(firstCable);
                this.getFullRoute(route, cableLst, buMap);
            }
        }
        return route;
    }

    public List<TEMarineCablePO> getAllCable() {
        ArrayList<TEMarineCablePO> cableList = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error("DB oper error!", (Throwable)e);
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
        } else {
            int retCode = dbResult.getResult();
            if (0 == retCode) {
                cableList = new ArrayList<TEMarineCablePO>();
                TEMarineCablePO cablePO = null;
                List data = dbResult.getData();
                for (Object obj : data) {
                    cablePO = (TEMarineCablePO)obj;
                    cableList.add(cablePO);
                }
            } else {
                normalLogger.error("Query submarine cable fail! The error code is " + retCode);
            }
        }
        return cableList;
    }

    public List<TEMarineCablePO> getCablesByStation(TEMarineStationPO station) {
        List<TEMarineCablePO> cableList = this.getAllCable();
        ArrayList<TEMarineCablePO> rCableList = new ArrayList<TEMarineCablePO>();
        for (TEMarineCablePO cable : cableList) {
            if ((0 != cable.getSrcType() || cable.SrcStationID != station.StationID) && (0 != cable.getSinkType() || cable.SinkStationID != station.StationID)) continue;
            rCableList.add(cable);
        }
        return rCableList;
    }

    public TEMarineCablePO getCableByNeInfo(TEMarineStationPO station, int neid, int slotid) {
        if (null == station) {
            TELogFactory.getNormalLogger().error("getCableByNeInfo is fail! Because station is null!");
            return null;
        }
        List<TEMarineCablePO> cableList = this.getCablesByStation(station);
        TEMarineStationGetter stnGetter = new TEMarineStationGetter();
        TEMarineEndCablePO endCable = stnGetter.getEndCable(station.getStationID(), neid, slotid);
        if (null == cableList || null == endCable) {
            TELogFactory.getNormalLogger().error("getCableByNeInfo() is fail! Becault the sation " + station.getName() + " has no cable or endCable is null!");
            return null;
        }
        String ctbName = endCable.SrcNEID == (long)neid && endCable.SrcBoardID == slotid ? endCable.DstNEName : endCable.SrcNEName;
        for (TEMarineCablePO cable : cableList) {
            if (!cable.SrcNodeName.equals(ctbName) && !cable.SinkNodeName.equals(ctbName)) continue;
            return cable;
        }
        return null;
    }

    private boolean isEndPoint(int prePointType, TEMarineBUPO bu, String preBUPort) {
        boolean isEndPoint;
        boolean bl = isEndPoint = 0 == prePointType;
        if (isEndPoint) {
            return true;
        }
        isEndPoint = null == bu || null == preBUPort || preBUPort.isEmpty() ? false : TEMarineBUUtil.isSpurTrackPort(bu, preBUPort);
        return isEndPoint;
    }

    public Map<String, TEMarineBUPO> getAllBU() {
        TEBUDataBaseOperService dataBaseService = new TEBUDataBaseOperService();
        ArrayList<TEMarineBUPO> buList = new ArrayList<TEMarineBUPO>();
        int result = dataBaseService.queryAllBUInfo(buList);
        HashMap<String, TEMarineBUPO> buMap = null;
        if (0 == result) {
            buMap = new HashMap<String, TEMarineBUPO>();
            for (TEMarineBUPO bu : buList) {
                buMap.put(bu.getBuName(), bu);
            }
        } else {
            normalLogger.error("Get BU fail! Error Code is " + result);
        }
        return buMap;
    }

    private TEMarineCablePO getCableByStation(List<TEMarineCablePO> cableList, TEMarineStationPO station) {
        TEMarineCablePO rCable = null;
        for (TEMarineCablePO cable : cableList) {
            if (0 == cable.getSrcType() && cable.SrcStationID == station.StationID) {
                rCable = cable;
                cableList.remove(cable);
                break;
            }
            if (0 != cable.getSinkType() || cable.SinkStationID != station.StationID) continue;
            rCable = cable;
            cableList.remove(cable);
            break;
        }
        return rCable;
    }

    private TEMarineCablePO getCableByCTB(List<TEMarineCablePO> cableList, String ctbName) {
        for (TEMarineCablePO rCable : cableList) {
            if (!rCable.SrcNodeName.equals(ctbName) && !rCable.SinkNodeName.equals(ctbName)) continue;
            return rCable;
        }
        return null;
    }

    private void getFullRoute(TEMarineRoute route, List<TEMarineCablePO> cableList, Map<String, TEMarineBUPO> buMap) {
        int preEndPointType;
        boolean isPreForward;
        TEMarineCablePO firstCable = route.getCableList().get(0);
        if (0 == firstCable.SrcType && firstCable.SrcStationID == route.getStartStation().getStationID()) {
            isPreForward = true;
            preEndPointType = firstCable.SinkType;
        } else {
            isPreForward = false;
            preEndPointType = firstCable.SrcType;
        }
        if (0 == preEndPointType || null == buMap) {
            return;
        }
        String preBUName = isPreForward ? firstCable.SinkNodeName : firstCable.SrcNodeName;
        String preBUPort = isPreForward ? firstCable.SinkBuPortName : firstCable.SrcBuPortName;
        TEMarineBUPO preBU = buMap.get(preBUName);
        route.addABU(preBU);
        while (!this.isEndPoint(preEndPointType, preBU, preBUPort)) {
            boolean findNextCable = false;
            for (int i = cableList.size() - 1; i >= 0; --i) {
                TEMarineCablePO cable = cableList.get(i);
                if (!this.isNextCable(cable, preEndPointType, preBU)) continue;
                isPreForward = preBU.getBuName().equals(cable.SrcNodeName);
                preEndPointType = isPreForward ? cable.SinkType : cable.SrcType;
                preBUPort = isPreForward ? cable.SinkBuPortName : cable.SrcBuPortName;
                String preNodeName = isPreForward ? cable.SinkNodeName : cable.SrcNodeName;
                preBU = null == preNodeName || preNodeName.isEmpty() ? null : buMap.get(preNodeName);
                cableList.remove(cable);
                route.addACable(cable);
                if (null != preBU) {
                    route.addABU(preBU);
                }
                findNextCable = true;
                break;
            }
            if (findNextCable && !cableList.isEmpty()) continue;
            break;
        }
    }

    private boolean isNextCable(TEMarineCablePO cable, int preEndPointType, TEMarineBUPO preBU) {
        boolean isNext;
        boolean bl = isNext = cable.SrcType == preEndPointType || cable.SinkType == preEndPointType;
        if (isNext) {
            isNext = preBU.getBuName().equals(cable.SrcNodeName) ? !TEMarineBUUtil.isSpurTrackPort(preBU, cable.SrcBuPortName) : (preBU.getBuName().equals(cable.SinkNodeName) ? !TEMarineBUUtil.isSpurTrackPort(preBU, cable.SinkBuPortName) : false);
        }
        return isNext;
    }

    public List<TEMarineRoute> doCalcAllRoute() {
        List<TEMarineCablePO> cableList = this.getAllCable();
        Map<String, TEMarineBUPO> buMap = this.getAllBU();
        TEMarineStationGetter stnGetter = new TEMarineStationGetter();
        List<TEMarineCTBPO> ctbList = stnGetter.doQueryCTBInfo();
        if (null == ctbList || ctbList.isEmpty() || null == cableList || cableList.isEmpty()) {
            normalLogger.debug("There is no CTB or no cable!");
            return null;
        }
        int listIndex = ctbList.size() - 1;
        ArrayList<TEMarineRoute> routeList = new ArrayList<TEMarineRoute>();
        while (!ctbList.isEmpty()) {
            TEMarineCTBPO ctb = ctbList.get(listIndex);
            TEMarineCablePO firstCable = stnGetter.geCablePObyCTB(ctb, cableList);
            TEMarineRoute route = null;
            if (null != firstCable) {
                route = new TEMarineRoute();
                route.setStartStation(stnGetter.getStationByID(ctb.getStationID()));
                route.addACable(firstCable);
                cableList.remove(firstCable);
                this.getFullRoute(route, cableList, buMap);
            }
            if (null != route && route.isFull()) {
                routeList.add(route);
                if (route.isEndByStation()) {
                    List<TEMarineCablePO> routeCableLst = route.getCableList();
                    this.removeCTBFormList(routeCableLst.get(routeCableLst.size() - 1), ctbList);
                }
            }
            ctbList.remove(ctb);
            listIndex = ctbList.size() - 1;
        }
        return routeList;
    }

    private void removeCTBFormList(TEMarineCablePO cable, List<TEMarineCTBPO> ctbList) {
        if (null == ctbList || ctbList.isEmpty() || null == cable || 1 == cable.SrcType && 1 == cable.SinkType) {
            return;
        }
        String startCTBName = 0 == cable.SrcType ? cable.SrcNodeName : "";
        String endCTBName = 0 == cable.SinkType ? cable.SinkNodeName : "";
        for (int i = ctbList.size() - 1; i >= 0; --i) {
            TEMarineCTBPO ctb = ctbList.get(i);
            if (!ctb.getName().equals(startCTBName) && !ctb.getName().equals(endCTBName)) continue;
            ctbList.remove(i);
        }
    }

    public int doCalcMainRoute(List<List<TEMarineCablePO>> mainRouteList) {
        if (null == mainRouteList) {
            normalLogger.error("marineCableInfoList is null!");
            return 1090605056;
        }
        List<TEMarineRoute> routeList = this.doCalcAllRoute();
        if (null == routeList || routeList.isEmpty()) {
            normalLogger.debug("Can not find any route!");
            return 0;
        }
        for (TEMarineRoute route : routeList) {
            if (route.getRouteType() != 0) continue;
            mainRouteList.add(route.getCableList());
        }
        return 0;
    }

    public TEMarineCablePO getCableByNodeNames(String srcName, String sinkName) {
        List<TEMarineCablePO> cableList = this.getAllCable();
        if (null == cableList || cableList.isEmpty()) {
            return null;
        }
        for (TEMarineCablePO cable : cableList) {
            if (!this.isSrcName(cable, srcName) || !this.isSinkName(cable, sinkName)) continue;
            return cable;
        }
        return null;
    }

    private boolean isSrcName(TEMarineCablePO cable, String srcName) {
        if (null == cable) {
            return false;
        }
        return cable.SrcType == 0 && cable.getSrcStationName().equals(srcName) || cable.SrcType == 1 && cable.getSrcNodeName().equals(srcName);
    }

    private boolean isSinkName(TEMarineCablePO cable, String sinkName) {
        if (null == cable) {
            return false;
        }
        return cable.SinkType == 0 && cable.getSinkStationName().equals(sinkName) || cable.SinkType == 1 && cable.getSinkNodeName().equals(sinkName);
    }
}

