/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineCableEngInfo;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEMarineRoute {
    private TEMarineStationPO startStation = null;
    private List<TEMarineCablePO> cableList = new ArrayList<TEMarineCablePO>();
    private Map<String, TEMarineBUPO> buMap = new HashMap<String, TEMarineBUPO>();
    private List<TEMarineCableEngInfo> cableEngInfoLst = new ArrayList<TEMarineCableEngInfo>();

    public int getRouteType() {
        int routeType = -1;
        if (this.isFull()) {
            routeType = this.isEndByStation() ? 0 : 1;
        }
        return routeType;
    }

    public TEMarineStationPO getStartStation() {
        return this.startStation;
    }

    public void setStartStation(TEMarineStationPO startStation) {
        this.startStation = startStation;
    }

    public List<TEMarineCablePO> getCableList() {
        return this.cableList;
    }

    public void setCableList(List<TEMarineCablePO> cableList) {
        this.cableList = cableList;
    }

    public Map<String, TEMarineBUPO> getBuMap() {
        return this.buMap;
    }

    public void setBuMap(Map<String, TEMarineBUPO> buMap) {
        this.buMap = buMap;
    }

    public void addACable(TEMarineCablePO cable) {
        if (null != cable) {
            this.cableList.add(cable);
        }
    }

    public List<TEMarineCableEngInfo> getCableEngInfoLst() {
        return this.cableEngInfoLst;
    }

    public void setCableEngInfoLst(List<TEMarineCableEngInfo> cableEngInfoLst) {
        if (null != cableEngInfoLst) {
            this.cableEngInfoLst = cableEngInfoLst;
        }
    }

    public void addCableEngInfo(TEMarineCableEngInfo cableEngInfo) {
        if (null != cableEngInfo) {
            this.cableEngInfoLst.add(cableEngInfo);
        }
    }

    public void clearCableEngInfoLst() {
        this.cableEngInfoLst.clear();
    }

    public void addABU(TEMarineBUPO bu) {
        if (null != bu) {
            this.buMap.put(bu.getBuName(), bu);
        }
    }

    public String getStartNodeName() {
        String startNodeName = "";
        if (null != this.startStation && null != this.startStation.getName()) {
            startNodeName = this.startStation.getName();
        }
        return startNodeName;
    }

    public String getEndNodeName() {
        String nodeName = "";
        if (null == this.cableList || this.cableList.isEmpty() || !this.isFull()) {
            TELogFactory.getNormalLogger().error("getEndNodeName is fail! Because cableList is null or empty! Or the route is not full!");
        } else {
            TEMarineCablePO endCable = this.cableList.get(this.cableList.size() - 1);
            nodeName = this.isEndByStation() ? (endCable.getSrcType() == 0 && endCable.getSrcStationID() != this.startStation.StationID ? endCable.getSrcStationName() : endCable.getSinkStationName()) : (endCable.getSrcType() == 1 && TEMarineBUUtil.isSpurTrackPort(this.buMap.get(endCable.getSrcNodeName()), endCable.getSrcBuPortName()) ? endCable.getSrcNodeName() : endCable.getSinkNodeName());
        }
        return nodeName;
    }

    public boolean isFull() {
        boolean isFullRoute;
        boolean bl = isFullRoute = !this.cableList.isEmpty();
        if (isFullRoute) {
            isFullRoute = this.isEndByStation() || this.isEndByBU();
        }
        return isFullRoute;
    }

    public boolean isEndByStation() {
        boolean isEndByStation;
        boolean bl = isEndByStation = !this.cableList.isEmpty();
        if (isEndByStation) {
            TEMarineCablePO cable = this.cableList.get(this.cableList.size() - 1);
            isEndByStation = 0 == cable.SrcType && cable.getSrcStationID() != this.startStation.StationID || 0 == cable.SinkType && cable.getSinkStationID() != this.startStation.StationID;
        }
        return isEndByStation;
    }

    public boolean isEndByBU() {
        boolean isEndByStation;
        boolean bl = isEndByStation = !this.cableList.isEmpty();
        if (isEndByStation) {
            TEMarineCablePO cable = this.cableList.get(this.cableList.size() - 1);
            isEndByStation = 1 == cable.SrcType && TEMarineBUUtil.isSpurTrackPort(this.buMap.get(cable.SrcNodeName), cable.SrcBuPortName) || 1 == cable.SinkType && TEMarineBUUtil.isSpurTrackPort(this.buMap.get(cable.SinkNodeName), cable.SinkBuPortName);
        }
        return isEndByStation;
    }

    public int getBUVoltage(String buName) {
        TEMarineBUPO bu = this.buMap.get(buName);
        int voltage_drop = 0;
        if (null == bu) {
            TELogFactory.getNormalLogger().error("Getting BU fail! BU name is " + buName);
        } else {
            voltage_drop = bu.getPressure();
        }
        return voltage_drop;
    }
}

