/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.marine.e2e.linemonitor.TESLMTestUtil;
import com.huawei.nglct.nemgr.marine.linemonitor_u2kv1r3c00.TEStartTest;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEMarineLineDaoService {
    public static final int TEST_MODE_IN_SRV = 1;
    public static final int TEST_TYPE_AUTO = 7;
    public static final int NO_CHECK_CONFLICT = 0;
    public static final int POSITIVE_DIRECTION = 0;
    public static final int REVERSE_DIRECTION = 1;
    public static final int TESTEVENTTYPE_BREAK = 0x2E9999;
    private static TEMarineLineDaoService instance = null;
    private Logger logger = TELogFactory.getNormalLogger();

    private TEMarineLineDaoService() {
    }

    public static TEMarineLineDaoService getInstance() {
        if (null == instance) {
            instance = new TEMarineLineDaoService();
        }
        return instance;
    }

    public int getLineInfoLstFromDB(int neid, List<TESLMLinePO> linePOLst) {
        if (null == linePOLst) {
            this.logger.error("Error! Input linePOLst is null!");
            return 2;
        }
        int[] metadata = new int[]{neid};
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
        }
        catch (Exception e) {
            this.logger.error("Get line info from DB is throw a exception!", (Throwable)e);
        }
        if (null == dbResult) {
            this.logger.error("The dbResult is null!");
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null == data || data.isEmpty()) {
                this.logger.debug("Can not find any line info of ne " + neid + "from DB.");
            } else {
                for (Object obj : data) {
                    TESLMLinePO line = (TESLMLinePO)obj;
                    linePOLst.add(line);
                }
            }
        }
        return retCode;
    }

    public TESLMLinePO getALinePOFromDB(int neid, int lineid) {
        ArrayList<TESLMLinePO> lineList = new ArrayList<TESLMLinePO>();
        int errorCode = this.getLineInfoLstFromDB(neid, lineList);
        if (0 == errorCode) {
            for (TESLMLinePO line : lineList) {
                if (line.LineID != lineid) continue;
                return line;
            }
            this.logger.debug("can not find the line " + lineid + " in the ne " + neid);
        } else {
            this.logger.debug("get line fail! errorcode is " + errorCode);
        }
        return null;
    }

    public int startLineTest(int neid, int lineid, int direction, int userid, String ipAddr) {
        boolean hasConnect = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid);
        if (!hasConnect) {
            this.logger.error("handleSBIConnectOnInter fail! neid is " + neid);
            return 1090605056;
        }
        Datainterface reqData = this.constructStartTestReq(neid, lineid, direction);
        SubFunc subFunc = TESLMTestUtil.getSubFunc(neid, 2555994);
        TEStartTest bean = new TEStartTest();
        Datainterface neRsp = bean.performBussinessProcess(neid, subFunc, reqData, null, String.valueOf(userid), ipAddr);
        return Integer.parseInt(neRsp.getErrorMessage().getErrorcode());
    }

    private Datainterface constructStartTestReq(int neid, int lineid, int direction) {
        Datainterface data = new Datainterface();
        BussinessParams bus = new BussinessParams();
        data.setBussinessParams(bus);
        RowParams rp = new RowParams();
        Param param = new Param("neid", String.valueOf(neid));
        rp.addParam(param);
        param = new Param("lineID", String.valueOf(lineid));
        rp.addParam(param);
        param = new Param("testMode", String.valueOf(1));
        rp.addParam(param);
        param = new Param("lineDirection", String.valueOf(direction));
        rp.addParam(param);
        param = new Param("testType", String.valueOf(7));
        rp.addParam(param);
        param = new Param("communicateCheck", String.valueOf(0));
        rp.addParam(param);
        bus.addRowParams(rp);
        return data;
    }
}

