/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2ecommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineCableEngInfo;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoEncryptUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRoute;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRouteGetter;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoDetailPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public final class TEMarineEngInfoDaoService {
    private final int INVALID_VALUE = -1;
    private static TEMarineEngInfoDaoService instance;
    private Logger logger = TELogFactory.getNormalLogger();

    private TEMarineEngInfoDaoService() {
    }

    public static synchronized TEMarineEngInfoDaoService getInstance() {
        if (instance == null) {
            instance = new TEMarineEngInfoDaoService();
        }
        return instance;
    }

    public int findAllEngInfo(Collection<TEMarineEngineerInfoPO> resultList) {
        if (resultList == null) {
            throw new IllegalArgumentException();
        }
        resultList.clear();
        TEDaoOperationResult daoOperationResult = null;
        try {
            daoOperationResult = TECommonDaoService.findAll(TEMarineEngineerInfoPO.class);
        }
        catch (Exception e) {
            this.logger.error("Get Marine EngInfo Fail: DB operation error!");
            return 1092743443;
        }
        if (daoOperationResult == null) {
            this.logger.error("Get Marine EngInfo Fail: The daoOperationResult is null!");
            return 1092743443;
        }
        int resultCode = daoOperationResult.getResult();
        if (resultCode == 0) {
            for (Object item : daoOperationResult.getData()) {
                TEMarineEngInfoEncryptUtil.decrypt((TEMarineEngineerInfoPO)item);
                resultList.add((TEMarineEngineerInfoPO)item);
            }
        }
        return resultCode;
    }

    public int findEngInfoByID(Collection<TEMarineEngineerInfoPO> resultList, int infoID) {
        if (resultList == null) {
            throw new IllegalArgumentException();
        }
        resultList.clear();
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        criteria.add(new TEDaoNameValuePair("InfoID", String.valueOf(infoID)));
        TEDaoOperationResult daoOperationResult = null;
        try {
            daoOperationResult = TECommonDaoService.findByID(TEMarineEngineerInfoPO.class, criteria);
        }
        catch (Exception e) {
            this.logger.error("Get Marine EngInfo Fail: DB operation error!");
            return 1092743443;
        }
        if (daoOperationResult == null) {
            this.logger.error("Get Marine EngInfo Fail: The daoOperationResult is null!");
            return 1092743443;
        }
        int resultCode = daoOperationResult.getResult();
        if (resultCode == 0) {
            for (Object item : daoOperationResult.getData()) {
                TEMarineEngInfoEncryptUtil.decrypt((TEMarineEngineerInfoPO)item);
                resultList.add((TEMarineEngineerInfoPO)item);
            }
        }
        return resultCode;
    }

    public int createEngInfos(Collection<TEMarineEngineerInfoPO> engInfoList) {
        if (engInfoList != null && !engInfoList.isEmpty()) {
            try {
                for (TEMarineEngineerInfoPO item : engInfoList) {
                    TEMarineEngInfoEncryptUtil.encrypt(item);
                    TEDaoOperationResult daoOperationResult = TECommonDaoService.create((Object)item);
                    int resultCode = daoOperationResult.getResult();
                    if (resultCode != 0) {
                        return resultCode;
                    }
                    TEMarineEngInfoEncryptUtil.decrypt(item);
                }
            }
            catch (Exception e) {
                this.logger.error("Create Marine EngInfo Fail: DB operation error!");
                return 1092743443;
            }
        }
        return 0;
    }

    public TEMarineEngineerInfoPO getEngineerInfoBySiteName(String startNodeName, String endNodeName) {
        ArrayList<TEMarineEngineerInfoPO> infoLst = new ArrayList<TEMarineEngineerInfoPO>();
        int retCode = this.findAllEngInfo(infoLst);
        TEMarineEngineerInfoPO info = null;
        if (0 == retCode) {
            for (TEMarineEngineerInfoPO aDoc : infoLst) {
                String docSrc = aDoc.getSrc().toLowerCase();
                String docSink = aDoc.getSink().toLowerCase();
                if (!docSrc.contains(startNodeName.toLowerCase()) || !docSink.contains(endNodeName.toLowerCase())) continue;
                info = aDoc;
                break;
            }
        } else {
            this.logger.error("Get Marine EngInfo Fail! The error code is " + retCode);
        }
        return info;
    }

    public int deleteEngInfoByID(Collection<Integer> infoIDs) {
        if (infoIDs != null && !infoIDs.isEmpty()) {
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>(infoIDs.size());
            for (Integer infoID : infoIDs) {
                criteria.add(new TEDaoNameValuePair("InfoID", String.valueOf(infoID)));
            }
            TEDaoOperationResult daoOperationResult = null;
            try {
                daoOperationResult = TECommonDaoService.deleteByID(TEMarineEngineerInfoPO.class, criteria);
            }
            catch (Exception e) {
                this.logger.error("Delete Marine EngInfo Fail: DB operation error!");
                return 1092743443;
            }
            if (daoOperationResult == null) {
                this.logger.error("Delete Marine EngInfo Fail: The daoOperationResult is null!");
                return 1092743443;
            }
            return daoOperationResult.getResult();
        }
        return 0;
    }

    public int getEngineerInfoByRoute(TEMarineRoute route) {
        if (null == route || null == route.getCableList() || route.getCableList().isEmpty()) {
            this.logger.error("Get Marine EngInfo Fail! The route is null or cableList is empty!");
            return 1090615236;
        }
        ArrayList<TEMarineEngineerInfoPO> allInfoLst = new ArrayList<TEMarineEngineerInfoPO>();
        int retCode = this.findAllEngInfo(allInfoLst);
        if (0 == retCode) {
            TEMarineEngineerInfoPO aEngInfo = new TEMarineEngineerInfoPO();
            String preSinkName = route.getStartNodeName();
            for (TEMarineCablePO cable : route.getCableList()) {
                String srcName = TEMarineE2EUtil.getCableSrcNodeName(cable);
                String sinkName = TEMarineE2EUtil.getCableSinkNodeName(cable);
                TEMarineCableEngInfo cableEngInfo = this.getCableEngInfo(aEngInfo, cable, preSinkName);
                if (null == cableEngInfo) {
                    aEngInfo = this.getEngInfoByNodeName(allInfoLst, srcName, sinkName);
                    cableEngInfo = this.getCableEngInfo(aEngInfo, cable, preSinkName);
                }
                if (null == cableEngInfo) {
                    route.clearCableEngInfoLst();
                    retCode = 1090615237;
                    this.logger.error("Can not find the engineerinfo of this cable! The srcName is " + srcName + ", sinkName is " + sinkName);
                    break;
                }
                route.addCableEngInfo(cableEngInfo);
                preSinkName = srcName.equals(preSinkName) ? sinkName : srcName;
            }
        } else {
            this.logger.error("Get Marine EngInfo Fail! The error code is " + retCode);
        }
        return retCode;
    }

    public TEMarineEngineerInfoPO getEngInfoByNodeName(List<TEMarineEngineerInfoPO> infoLst, String srcName, String sinkName) {
        TEMarineEngineerInfoPO info = null;
        if (null == infoLst || infoLst.isEmpty()) {
            this.logger.error("getEngInfoByNodeName is fail! Because infoLst is null or empty!");
        } else {
            boolean isFindSrcNameSucc = false;
            boolean isFindSinkNameSucc = false;
            for (TEMarineEngineerInfoPO aInfo : infoLst) {
                for (TEMarineEngineerInfoDetailPO detail : aInfo.getDetailList()) {
                    String detailPointName = detail.getAdditionalFeatures().toLowerCase();
                    String eventName = detail.getEvent();
                    isFindSrcNameSucc = detailPointName.contains(srcName.toLowerCase()) || eventName.equals(srcName) ? true : isFindSrcNameSucc;
                    boolean bl = isFindSinkNameSucc = detailPointName.contains(sinkName.toLowerCase()) || eventName.equals(sinkName) ? true : isFindSinkNameSucc;
                    if (!isFindSrcNameSucc || !isFindSinkNameSucc) continue;
                    info = aInfo;
                    break;
                }
                if (null == info) continue;
                break;
            }
        }
        return info;
    }

    private TEMarineCableEngInfo getCableEngInfo(TEMarineEngineerInfoPO info, TEMarineCablePO cable, String preSinkName) {
        TEMarineCableEngInfo cableEngInfo = null;
        if (null != info && null != info.getDetailList() && !info.getDetailList().isEmpty() && null != cable) {
            boolean isFindSrcNameSucc = false;
            boolean isFindSinkNameSucc = false;
            List detailInfoLst = info.getSortedDetailList();
            String cableSrcName = TEMarineE2EUtil.getCableSrcNodeName(cable);
            String cableSinkName = TEMarineE2EUtil.getCableSinkNodeName(cable);
            boolean isCableForward = cableSrcName.equals(preSinkName);
            String srcName = isCableForward ? cableSrcName : cableSinkName;
            String sinkName = isCableForward ? cableSinkName : cableSrcName;
            int startIndex = -1;
            int endIndex = -1;
            int len = detailInfoLst.size();
            for (int i = 0; i < len; ++i) {
                TEMarineEngineerInfoDetailPO detail = (TEMarineEngineerInfoDetailPO)detailInfoLst.get(i);
                String detailPointName = detail.getAdditionalFeatures().toLowerCase();
                String eventName = detail.getEvent();
                isFindSrcNameSucc = detailPointName.contains(srcName.toLowerCase()) || eventName.equals(srcName) ? true : isFindSrcNameSucc;
                isFindSinkNameSucc = detailPointName.contains(sinkName.toLowerCase()) || eventName.equals(sinkName) ? true : isFindSinkNameSucc;
                startIndex = isFindSrcNameSucc && -1 == startIndex ? i : startIndex;
                int n = endIndex = isFindSinkNameSucc && -1 == endIndex ? i : endIndex;
                if (isFindSrcNameSucc && isFindSinkNameSucc) break;
            }
            if (-1 == startIndex || -1 == endIndex || startIndex == endIndex) {
                this.logger.error("getCableEngInfo fail! startIndex=" + startIndex + "; endIndex=" + endIndex);
            } else {
                List<TEMarineEngineerInfoDetailPO> newDetailLst;
                cableEngInfo = new TEMarineCableEngInfo();
                cableEngInfo.setCable(cable);
                cableEngInfo.setLengthOfEngInfo(Double.parseDouble(((TEMarineEngineerInfoDetailPO)detailInfoLst.get(detailInfoLst.size() - 1)).getCmlDst()));
                cableEngInfo.setCableForward(isCableForward);
                boolean isDetailForward = startIndex < endIndex;
                cableEngInfo.setLstForward(startIndex < endIndex);
                List<Object> list = newDetailLst = isDetailForward ? detailInfoLst.subList(startIndex, endIndex + 1) : detailInfoLst.subList(endIndex, startIndex + 1);
                if (!isDetailForward) {
                    Collections.reverse(newDetailLst);
                }
                cableEngInfo.setDetailList(newDetailLst);
            }
        }
        return cableEngInfo;
    }

    public TEMarineCableEngInfo getCableEngInfoByNodeName(String srcName, String sinkName) {
        ArrayList<TEMarineEngineerInfoPO> infoLst = new ArrayList<TEMarineEngineerInfoPO>();
        int retCode = this.findAllEngInfo(infoLst);
        if (0 != retCode) {
            return null;
        }
        TEMarineEngineerInfoPO info = this.getEngInfoByNodeName(infoLst, srcName, sinkName);
        TEMarineCableEngInfo cableEngInfo = null;
        if (null != info && null != info.getDetailList() && !info.getDetailList().isEmpty()) {
            boolean isFindSrcNameSucc = false;
            boolean isFindSinkNameSucc = false;
            List detailInfoLst = info.getSortedDetailList();
            int startIndex = -1;
            int endIndex = -1;
            int len = detailInfoLst.size();
            for (int i = 0; i < len; ++i) {
                TEMarineEngineerInfoDetailPO detail = (TEMarineEngineerInfoDetailPO)detailInfoLst.get(i);
                String detailPointName = detail.getAdditionalFeatures().toLowerCase();
                String eventName = detail.getEvent();
                isFindSrcNameSucc = detailPointName.contains(srcName.toLowerCase()) || eventName.equals(srcName) ? true : isFindSrcNameSucc;
                isFindSinkNameSucc = detailPointName.contains(sinkName.toLowerCase()) || eventName.equals(sinkName) ? true : isFindSinkNameSucc;
                startIndex = isFindSrcNameSucc && -1 == startIndex ? i : startIndex;
                int n = endIndex = isFindSinkNameSucc && -1 == endIndex ? i : endIndex;
                if (isFindSrcNameSucc && isFindSinkNameSucc) break;
            }
            if (-1 == startIndex || -1 == endIndex || startIndex == endIndex) {
                this.logger.error("getCableEngInfo fail! startIndex=" + startIndex + "; endIndex=" + endIndex);
            } else {
                List<TEMarineEngineerInfoDetailPO> newDetailLst;
                cableEngInfo = new TEMarineCableEngInfo();
                cableEngInfo.setCable(this.getCable(srcName, sinkName));
                cableEngInfo.setLengthOfEngInfo(Double.parseDouble(((TEMarineEngineerInfoDetailPO)detailInfoLst.get(detailInfoLst.size() - 1)).getCmlDst()));
                cableEngInfo.setCableForward(true);
                boolean isDetailForward = startIndex < endIndex;
                cableEngInfo.setLstForward(startIndex < endIndex);
                List<Object> list = newDetailLst = isDetailForward ? detailInfoLst.subList(startIndex, endIndex) : detailInfoLst.subList(endIndex, startIndex);
                if (!isDetailForward) {
                    Collections.reverse(newDetailLst);
                }
                cableEngInfo.setDetailList(newDetailLst);
            }
        }
        return cableEngInfo;
    }

    private TEMarineCablePO getCable(String srcName, String sinkName) {
        TEMarineRouteGetter routeGetter = new TEMarineRouteGetter();
        return routeGetter.getCableByNodeNames(srcName, sinkName);
    }
}

