/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineCableDirMap;
import com.huawei.nglct.po.embeddednemgrmo.marine.TECableBondLinePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineRepeaterPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationNEPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEMarineCableLineRptUtil {
    private static final int CABLE_LINE_DIREC_SAME = 0;
    private static final int CABLE_LINE_DIREC_DIFF = 1;
    private static final int NODE_TYPE_STATION = 0;
    private static Object nextNode;
    private static int nextNodeType;

    private TEMarineCableLineRptUtil() {
    }

    public static String getRepeaterName(int lineID, int neID) {
        List<String> nameList;
        String rptNameStr = "";
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return rptNameStr;
        }
        TESLMLinePO curLine = TEMarineCableLineRptUtil.getLinePO(lineID, neID);
        List<TEMarineCablePO> allCable = TEMarineCableLineRptUtil.getAllCable();
        if (null == curLine || allCable.isEmpty()) {
            return rptNameStr;
        }
        if (TEMarineCableLineRptUtil.checkGetRepeaterNameValid(curLine, allCable) && !(nameList = TEMarineCableLineRptUtil.doCalRepeaterNameList(curLine, allCable)).isEmpty()) {
            rptNameStr = TEMarineCableLineRptUtil.convertRptNameStr(nameList);
        }
        return rptNameStr;
    }

    private static String convertRptNameStr(List<String> nameList) {
        StringBuilder sb = new StringBuilder();
        int size = nameList.size();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                sb.append(nameList.get(i));
                if (i == size - 1) continue;
                sb.append(";");
            }
        }
        return sb.toString();
    }

    private static List<String> doCalRepeaterNameList(TESLMLinePO curLine, List<TEMarineCablePO> allCable) {
        ArrayList<String> rptNameList = new ArrayList<String>();
        List<TEMarineCablePO> passedByCable = TEMarineCableLineRptUtil.getPassedByCable(curLine, allCable);
        if (passedByCable.isEmpty()) {
            return rptNameList;
        }
        List<TEMarineCableDirMap> sortedPassedByCable = TEMarineCableLineRptUtil.sortCable(passedByCable, curLine);
        for (TEMarineCableDirMap curCableMap : sortedPassedByCable) {
            ArrayList<TEMarineRepeaterPO> tmpRPTList = new ArrayList<TEMarineRepeaterPO>();
            for (TEMarineRepeaterPO curRpt : curCableMap.getCurCable().getRPTList()) {
                tmpRPTList.add(curRpt);
            }
            if (tmpRPTList.isEmpty()) continue;
            TEMarineCableLineRptUtil.sortTmpRPTList(tmpRPTList);
            if (curCableMap.getSrcToSnk() == 1) {
                Collections.reverse(tmpRPTList);
            }
            for (TEMarineRepeaterPO curRpt : tmpRPTList) {
                rptNameList.add(curRpt.getName());
            }
        }
        return rptNameList;
    }

    private static void sortTmpRPTList(List<TEMarineRepeaterPO> tmpRPTList) {
        Collections.sort(tmpRPTList, new Comparator<TEMarineRepeaterPO>(){

            @Override
            public int compare(TEMarineRepeaterPO o1, TEMarineRepeaterPO o2) {
                return o1.getID() - o2.getID();
            }
        });
    }

    private static List<TEMarineCableDirMap> sortCable(List<TEMarineCablePO> passedByCable, TESLMLinePO curLine) {
        TEMarineCablePO curCablePO;
        ArrayList<TEMarineCableDirMap> cableDirMapList = new ArrayList<TEMarineCableDirMap>();
        int cableDir = -1;
        nextNodeType = -1;
        nextNode = null;
        int curStationID = TEMarineCableLineRptUtil.getStationIDByNeID(curLine.getNeID());
        if (curStationID == -1) {
            return cableDirMapList;
        }
        Iterator<TEMarineCablePO> iterator = passedByCable.iterator();
        while (iterator.hasNext()) {
            curCablePO = iterator.next();
            if (0 == curCablePO.getSrcType() && curCablePO.getSrcStationID() == curStationID) {
                cableDir = 0;
                cableDirMapList.add(new TEMarineCableDirMap(curCablePO, cableDir));
                iterator.remove();
                nextNodeType = curCablePO.getSinkType();
                if (curCablePO.getSinkType() == 0) {
                    nextNode = curCablePO.getSinkStationID();
                    break;
                }
                nextNode = curCablePO.getSinkNodeName();
                break;
            }
            if (0 != curCablePO.getSinkType() || curCablePO.getSinkStationID() != curStationID) continue;
            cableDir = 1;
            cableDirMapList.add(new TEMarineCableDirMap(curCablePO, cableDir));
            iterator.remove();
            nextNodeType = curCablePO.getSrcType();
            if (curCablePO.getSrcType() == 0) {
                nextNode = curCablePO.getSrcStationID();
                break;
            }
            nextNode = curCablePO.getSrcNodeName();
            break;
        }
        iterator = passedByCable.iterator();
        while (!passedByCable.isEmpty()) {
            while (iterator.hasNext()) {
                curCablePO = iterator.next();
                if (nextNodeType == 0) {
                    if (nextNodeType == curCablePO.getSrcType() && curCablePO.getSrcStationID() == ((Integer)nextNode).intValue()) {
                        cableDir = 0;
                        cableDirMapList.add(new TEMarineCableDirMap(curCablePO, cableDir));
                        iterator.remove();
                        nextNodeType = curCablePO.getSinkType();
                        nextNode = curCablePO.getSinkType() == 0 ? Integer.valueOf(curCablePO.getSinkStationID()) : curCablePO.getSinkNodeName();
                        cableDir = 0;
                        break;
                    }
                    if (nextNodeType != curCablePO.getSinkType() || curCablePO.getSinkStationID() != ((Integer)nextNode).intValue()) continue;
                    cableDir = 1;
                    cableDirMapList.add(new TEMarineCableDirMap(curCablePO, cableDir));
                    iterator.remove();
                    nextNodeType = curCablePO.getSrcType();
                    if (curCablePO.getSrcType() == 0) {
                        nextNode = curCablePO.getSrcStationID();
                        break;
                    }
                    nextNode = curCablePO.getSrcNodeName();
                    break;
                }
                if (nextNodeType == curCablePO.getSrcType() && curCablePO.getSrcNodeName().equals(nextNode)) {
                    cableDir = 0;
                    cableDirMapList.add(new TEMarineCableDirMap(curCablePO, cableDir));
                    iterator.remove();
                    nextNodeType = curCablePO.getSinkType();
                    nextNode = curCablePO.getSinkType() == 0 ? Integer.valueOf(curCablePO.getSinkStationID()) : curCablePO.getSinkNodeName();
                    cableDir = 0;
                    break;
                }
                if (nextNodeType != curCablePO.getSinkType() || !curCablePO.getSinkNodeName().equals(nextNode)) continue;
                cableDir = 1;
                cableDirMapList.add(new TEMarineCableDirMap(curCablePO, cableDir));
                iterator.remove();
                nextNodeType = curCablePO.getSrcType();
                if (curCablePO.getSrcType() == 0) {
                    nextNode = curCablePO.getSrcStationID();
                    break;
                }
                nextNode = curCablePO.getSrcNodeName();
                break;
            }
            iterator = passedByCable.iterator();
        }
        return cableDirMapList;
    }

    private static int getStationIDByNeID(long neID) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStationPO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Query TEMarineStationPO fail!", (Throwable)e);
            return -1;
        }
        if (0 == dbResult.getResult()) {
            List data = dbResult.getData();
            for (Object obj : data) {
                TEMarineStationPO stationPO = (TEMarineStationPO)obj;
                Set neSet = stationPO.getShelfList();
                for (TEMarineStationNEPO ne : neSet) {
                    if (ne.neID != neID) continue;
                    return stationPO.getStationID();
                }
            }
        }
        return -1;
    }

    private static List<TEMarineCablePO> getPassedByCable(TESLMLinePO curLine, List<TEMarineCablePO> allCable) {
        ArrayList<TEMarineCablePO> passedByCableList = new ArrayList<TEMarineCablePO>();
        for (TEMarineCablePO curCable : allCable) {
            Set curCableLines = curCable.getBONDLineList();
            for (TECableBondLinePO tmpLine : curCableLines) {
                if (tmpLine.getLineId() != curLine.getLineID() || tmpLine.getSnkNeID() != curLine.getNeID() && tmpLine.getSrcNeID() != curLine.getNeID()) continue;
                passedByCableList.add(curCable);
            }
        }
        return passedByCableList;
    }

    public static List<TEMarineCablePO> getAllCable() {
        ArrayList<TEMarineCablePO> cableList = new ArrayList<TEMarineCablePO>();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineCablePO.class);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Query all the Cable fail!", (Throwable)e);
            return cableList;
        }
        if (null != dbResult && dbResult.getResult() == 0) {
            TEMarineCablePO curCablePO = null;
            List data = dbResult.getData();
            for (Object obj : data) {
                curCablePO = (TEMarineCablePO)obj;
                cableList.add(curCablePO);
            }
        }
        return cableList;
    }

    public static boolean checkGetRepeaterNameValid(TESLMLinePO curLine, List<TEMarineCablePO> allCable) {
        boolean isBiDirect = TEMarineCableLineRptUtil.checkLineBiDirect(curLine);
        if (isBiDirect) {
            return TEMarineCableLineRptUtil.checkCableIntact(curLine, allCable);
        }
        return false;
    }

    private static boolean checkCableIntact(TESLMLinePO curLinePO, List<TEMarineCablePO> allCable) {
        int cableCount = 0;
        for (TEMarineCablePO curCable : allCable) {
            Set curCableLines = curCable.getBONDLineList();
            for (TECableBondLinePO curLine : curCableLines) {
                if (curLine.getLineId() != curLinePO.getLineID() || curLine.getSnkNeID() != curLinePO.getNeID() && curLine.getSrcNeID() != curLinePO.getNeID()) continue;
                ++cableCount;
            }
        }
        return cableCount == curLinePO.getEqptNum() + 1;
    }

    private static boolean checkLineBiDirect(TESLMLinePO curLinePO) {
        long opNEID = curLinePO.getOppositeNEID();
        if (0L == opNEID) {
            return false;
        }
        return TEMarineCableLineRptUtil.isNeInManageDomain(opNEID);
    }

    private static boolean isNeInManageDomain(long opNEID) {
        return TENEListMgr.getInstance().getNEIDList().contains((int)opNEID);
    }

    public static TESLMLinePO getLinePO(int lineID, int neID) {
        TESLMLinePO curLinePO = null;
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair neIDPair = new TEDaoNameValuePair();
        neIDPair.setName("NeID");
        neIDPair.setValue(String.valueOf(neID));
        criteria.add(neIDPair);
        TEDaoNameValuePair lineIDPair = new TEDaoNameValuePair();
        lineIDPair.setName("LineID");
        lineIDPair.setValue(String.valueOf(lineID));
        criteria.add(lineIDPair);
        TEDaoOperationResult dbresult = null;
        try {
            dbresult = TECommonDaoService.findByID((int[])new int[]{neID}, TESLMLinePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Query The Line:" + lineID + " fail!", (Throwable)e);
            return null;
        }
        int errCode = dbresult.getResult();
        if (0 != errCode) {
            return null;
        }
        if (!dbresult.getData().isEmpty()) {
            curLinePO = (TESLMLinePO)dbresult.getData().get(0);
        }
        return curLinePO;
    }
}

