/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.trane2e.wdmservicetype;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnPathIndex;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnOTNXCServiceType;
import com.huawei.network.qasn.m_q_inventory_port.QAsnSetOTNServiceTypeReq;
import com.huawei.network.qasn.m_q_inventory_port.QAsnSetOTNServiceTypeRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.gencfg.TEGeneralKeyValueObj;
import com.huawei.nglct.db.gencfg.TEGeneralValueObj;
import com.huawei.nglct.db.gencfg.TEGnlValueElementObj;
import com.huawei.nglct.mo.CfgDataMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.marine.e2e.trane2e.gencfg.TESetGencfgValueHandler;
import com.huawei.nglct.nemgr.neadapter.TENEFuntionAdapterMgr;
import com.huawei.nglct.nemgr.neadapter.functionadapter.TEGenCfgInterface;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenOperationResult;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValueResult;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TESetWDMServiceTypeHandler {
    private static final int SERVICE_TYPE_DEFAULT_SHELFID = 0;
    private static final int FRAME_DEFAULT_SHELFID = -1;
    private static final Logger e2eLogger = TELogFactory.getNormalLogger();
    public static final String ATTR_SERVICETYPE = "W32PORT_ATTR_ST_SERVICETYPE";
    private boolean allFail = true;
    private boolean allSuccess = true;
    private static Map<Integer, Integer> convertServiceTypeMap = new HashMap<Integer, Integer>();

    public int handleRequest(QAsnSetOTNServiceTypeReq req, QAsnSetOTNServiceTypeRsp rsp, TaskMgr tm) {
        e2eLogger.info(TEAsn1Util.getAsn1String((Object)req));
        if (null == req.xcServiceTypeList || req.xcServiceTypeList.isEmpty()) {
            e2eLogger.error("SetOTNService: no serviceType!");
            rsp.errInfo.result = 0;
            e2eLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        QAsnOTNXCServiceType serviceType = null;
        for (Object xcServiceType : req.xcServiceTypeList) {
            serviceType = (QAsnOTNXCServiceType)xcServiceType;
            this.resetDefaultShelfID(serviceType);
        }
        this.handleLoginNE(req);
        QAsnOTNXCServiceType xcServiceType = null;
        rsp.errInfo.errList = new QAsnErrInfoList();
        int len = req.xcServiceTypeList.size();
        for (int i = 0; i < len; ++i) {
            xcServiceType = (QAsnOTNXCServiceType)req.xcServiceTypeList.get(i);
            this.handleSetType(rsp, xcServiceType);
        }
        this.setRspGlobalErrCode(rsp, this.allSuccess, this.allFail);
        e2eLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void resetDefaultShelfID(QAsnOTNXCServiceType serviceType) {
        if (-1 == serviceType.srcPathIndex.shelfID.intValue()) {
            serviceType.srcPathIndex.shelfID = BigInteger.valueOf(0L);
        }
        if (-1 == serviceType.dstPathIndex.shelfID.intValue()) {
            serviceType.dstPathIndex.shelfID = BigInteger.valueOf(0L);
        }
    }

    private void handleSetType(QAsnSetOTNServiceTypeRsp rsp, QAsnOTNXCServiceType xcServiceType) {
        TEGenOperationResult result = null;
        TEGenOperationResult srcCheckResult = null;
        TEGenOperationResult dstCheckResult = null;
        int srcCheckRetCode = -1;
        int dstCheckRetCode = -1;
        QAsnPathIndex srcPathIndex = xcServiceType.srcPathIndex;
        QAsnPathIndex dstPathIndex = xcServiceType.dstPathIndex;
        int serviceType = xcServiceType.serviceTpye;
        serviceType = TESetWDMServiceTypeHandler.specialHandle(xcServiceType.srcPathIndex.neID, serviceType);
        serviceType = CfgDataMgr.getInstance().getNESerTypeByNM(serviceType);
        if (-1 == serviceType) {
            result = this.constructError(1090598309);
            this.setErrInfo(rsp, srcPathIndex, result);
            this.setErrInfo(rsp, dstPathIndex, result);
        } else {
            srcCheckResult = this.checkSupportSetType(srcPathIndex);
            dstCheckResult = this.checkSupportSetType(dstPathIndex);
            srcCheckRetCode = srcCheckResult.getWholeErrorCode();
            if (0 != srcCheckRetCode) {
                srcCheckRetCode = ((TEGenValueResult)srcCheckResult.getGenResultList().get((int)0)).errorCode;
            }
            if (0 != (dstCheckRetCode = dstCheckResult.getWholeErrorCode())) {
                dstCheckRetCode = ((TEGenValueResult)dstCheckResult.getGenResultList().get((int)0)).errorCode;
            }
            if (srcCheckResult.isWholeSucess()) {
                result = this.setServiceType(srcPathIndex, serviceType);
                this.setErrInfo(rsp, srcPathIndex, result);
            } else if (1090615116 != srcCheckRetCode) {
                this.setErrInfo(rsp, srcPathIndex, srcCheckResult);
            }
            if (dstCheckResult.isWholeSucess()) {
                result = this.setServiceType(dstPathIndex, serviceType);
                this.setErrInfo(rsp, dstPathIndex, result);
            } else if (1090615116 != dstCheckRetCode) {
                this.setErrInfo(rsp, dstPathIndex, dstCheckResult);
            }
            if (1090615116 == srcCheckRetCode && 1090615116 == dstCheckRetCode) {
                this.setErrInfo(rsp, srcPathIndex, srcCheckResult);
                this.setErrInfo(rsp, dstPathIndex, dstCheckResult);
            }
        }
    }

    private static int specialHandle(int neID, int serviceType) {
        int spicialServiceType = serviceType;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne == null) {
            return spicialServiceType;
        }
        if (1 == ne.getIsTL1OrQX() && convertServiceTypeMap.containsKey(spicialServiceType)) {
            spicialServiceType = convertServiceTypeMap.get(spicialServiceType);
        }
        return spicialServiceType;
    }

    private TEGenOperationResult checkSupportSetType(QAsnPathIndex pathIndex) {
        TEGenOperationResult result = null;
        int neID = pathIndex.neID;
        int cnemgrSlotID = TEBoardUtil.neToSlotIDNM((int)pathIndex.shelfID.intValue(), (int)pathIndex.slotID);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            result = this.constructError(1090596385);
            return result;
        }
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, cnemgrSlotID);
        if (-1 == boardType) {
            result = this.constructError(1090646021);
            return result;
        }
        int portID = TEConfigurationDataMgr.getPortRelativeID((int)pathIndex.portID);
        result = TEGenCfgDataMgr.isSupportAttr((int)neID, (int)boardType, (int)portID, (String)ATTR_SERVICETYPE) || TEGenCfgDataMgr.isSupportAttr((int)neID, (int)boardType, (int)portID, (String)"W32PORT_ATTR_ST_SERVICETYPE_2") ? this.constructError(0) : this.constructError(1090615116);
        return result;
    }

    private void handleLoginNE(QAsnSetOTNServiceTypeReq req) {
        HashSet<Integer> set = new HashSet<Integer>();
        QAsnOTNXCServiceType xcServiceType = null;
        QAsnPathIndex srcPathIndex = null;
        QAsnPathIndex dstPathIndex = null;
        int len = req.xcServiceTypeList.size();
        for (int i = 0; i < len; ++i) {
            xcServiceType = (QAsnOTNXCServiceType)req.xcServiceTypeList.get(i);
            srcPathIndex = xcServiceType.srcPathIndex;
            dstPathIndex = xcServiceType.dstPathIndex;
            set.add(srcPathIndex.neID);
            set.add(dstPathIndex.neID);
        }
        Iterator iter = set.iterator();
        int neID = -1;
        TENE ne = null;
        while (iter.hasNext()) {
            neID = (Integer)iter.next();
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne || 1 == ne.getLogStatus()) continue;
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neID);
        }
    }

    private void setErrInfo(QAsnSetOTNServiceTypeRsp rsp, QAsnPathIndex pathIndex, TEGenOperationResult result) {
        if (pathIndex.neID == 0) {
            this.allFail = false;
            return;
        }
        int retCode = result.getWholeErrorCode();
        if (0 == retCode) {
            this.allFail = false;
        } else {
            this.allSuccess = false;
            List genValueResultList = result.getGenResultList();
            for (TEGenValueResult genResult : genValueResultList) {
                QAsnErrInfo errInfo = this.constructErrInfo(pathIndex, genResult.errorCode, genResult.errorInfo);
                rsp.errInfo.errList.add((Object)errInfo);
            }
        }
    }

    private QAsnErrInfo constructErrInfo(QAsnPathIndex pathIndex, int errCode, String errorInfo) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.objID = this.constructErrObjID(pathIndex);
        errInfo.errCode = errCode;
        if (null != errorInfo) {
            TENE ne = TENEListMgr.getInstance().getNE(pathIndex.neID);
            if (ne == null) {
                return errInfo;
            }
            if (ne.getIsTL1OrQX() == 1) {
                errInfo.strOperDesc = errorInfo.getBytes();
            }
        }
        return errInfo;
    }

    private QAsnTinyIntList constructErrObjID(QAsnPathIndex pathIndex) {
        QAsnTinyIntList objID = new QAsnTinyIntList();
        objID.add((Object)pathIndex.neID);
        objID.add((Object)pathIndex.shelfID);
        objID.add((Object)pathIndex.slotID);
        objID.add((Object)pathIndex.portID);
        objID.add((Object)pathIndex.pathID);
        return objID;
    }

    private void setRspGlobalErrCode(QAsnSetOTNServiceTypeRsp rsp, boolean allSuccess, boolean allFail) {
        rsp.errInfo.result = allSuccess ? 0 : (allFail ? 1090650122 : 1090650121);
    }

    private TEGenOperationResult setServiceType(QAsnPathIndex pathIndex, int serviceType) {
        TEGenOperationResult result = null;
        if (null == pathIndex) {
            result = this.constructError(1090593542);
            return result;
        }
        TENE ne = TENEListMgr.getInstance().getNE(pathIndex.neID);
        if (null == ne) {
            result = this.constructError(1090596385);
            return result;
        }
        int cnemgrSlotID = TEBoardUtil.neToSlotIDNM((int)pathIndex.shelfID.intValue(), (int)pathIndex.slotID);
        int attrID = this.getAttrID(ne, cnemgrSlotID);
        TEGenAttrObjectValue attrValue = this.constructAttrObjectValue(pathIndex, attrID, serviceType);
        result = this.setServiceTypeImpl(pathIndex.neID, attrValue);
        if (0 == result.getWholeErrorCode() && 0 == ne.getIsTL1OrQX()) {
            int retCode = this.saveToDB(pathIndex, serviceType);
            if (0 != retCode) {
                result = this.constructError(retCode);
                return result;
            }
            result = this.constructError(0);
        }
        return result;
    }

    protected void handleErrorCode(TEGenOperationResult operResult) {
        if (0 != operResult.getWholeErrorCode()) {
            List resultList = operResult.getGenResultList();
            TEGenValueResult result = null;
            Iterator iter = resultList.iterator();
            while (iter.hasNext()) {
                result = (TEGenValueResult)iter.next();
                if (38669 != result.errorCode) continue;
                iter.remove();
            }
            if (resultList.isEmpty()) {
                operResult.setWholeErrorCode(0);
            }
        }
    }

    private TEGenAttrObjectValue constructAttrObjectValue(QAsnPathIndex pathIndex, int attrID, int serviceType) {
        TEGenAttrObjectValue atrrValue = new TEGenAttrObjectValue();
        TEGenObjectID objectID = this.constructGenObjectID(pathIndex);
        atrrValue.setObjectID(objectID);
        List<TEGenValue> attrIDList = this.constructGenValue(attrID, serviceType);
        atrrValue.setAttrIDList(attrIDList);
        return atrrValue;
    }

    private TEGenObjectID constructGenObjectID(QAsnPathIndex pathIndex) {
        int neID = pathIndex.neID;
        int cnemgrSlotID = TEBoardUtil.neToSlotIDNM((int)pathIndex.shelfID.intValue(), (int)pathIndex.slotID);
        int cnemgrPortID = pathIndex.portID;
        int pathID = pathIndex.pathID.intValue();
        TEGenObjectID objectID = null;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne == null) {
            objectID = new TEGenObjectID();
            return objectID;
        }
        int objTypeID = this.getObjectID(ne);
        objectID = new TEGenObjectID(new int[]{objTypeID, neID, cnemgrSlotID, cnemgrPortID, pathID});
        return objectID;
    }

    private List<TEGenValue> constructGenValue(int attrID, int serviceType) {
        ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
        TEGenValue genValue = new TEGenValue();
        genValue.setAttrID(attrID);
        genValue.setValue(String.valueOf(serviceType));
        attrIDList.add(genValue);
        return attrIDList;
    }

    private TEGenOperationResult setServiceTypeImpl(int neID, TEGenAttrObjectValue attrValue) {
        TEGenOperationResult result = null;
        TEGenCfgInterface adpaterIF = (TEGenCfgInterface)TENEFuntionAdapterMgr.getInstance().findFunctionInterface(neID, TEGenCfgInterface.class.getName());
        result = adpaterIF.setAttribToNE(adpaterIF.getWDMInterfaceCmdFilePath(), attrValue);
        if (!result.isWholeSucess()) {
            e2eLogger.info(String.format("adpaterIF.setAttribToNE[neID:%d, attrValue:%s]", neID, attrValue.toString()));
            e2eLogger.info("result:" + result.toString());
        }
        return result;
    }

    private int saveToDB(QAsnPathIndex pathIndex, int serviceType) {
        int neID = pathIndex.neID;
        int cnemgrSlotID = TEBoardUtil.neToSlotIDNM((int)pathIndex.shelfID.intValue(), (int)pathIndex.slotID);
        int cnemgrPortID = pathIndex.portID;
        int pathID = pathIndex.pathID.intValue();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090596385;
        }
        int objectID = this.getObjectID(ne);
        int attrID = this.getAttrID(ne, cnemgrSlotID);
        int[] teObjID = new int[]{objectID, neID, cnemgrSlotID, cnemgrPortID, pathID};
        TEGeneralKeyValueObj keyValueObj = TESetGencfgValueHandler.constructKeyValueObj(attrID, teObjID);
        TEGeneralValueObj valueObj = TESetGencfgValueHandler.constructValueObj(0, "", serviceType);
        TEGnlValueElementObj elementObj = TESetGencfgValueHandler.constructElementObj(keyValueObj, valueObj);
        ArrayList<TEGnlValueElementObj> gnlValueElementObjList = new ArrayList<TEGnlValueElementObj>();
        gnlValueElementObjList.add(elementObj);
        int retCode = TESetGencfgValueHandler.saveToDB(gnlValueElementObjList);
        return retCode;
    }

    private int getAttrID(TENE ne, int cnemgrSlotID) {
        int attrID = -1;
        attrID = 271534;
        return attrID;
    }

    private int getObjectID(TENE ne) {
        int objectID = -1;
        objectID = this.isTL1Device(ne) ? 61524 : 61509;
        return objectID;
    }

    private TEGenOperationResult constructError(int errorCode) {
        TEGenOperationResult result = new TEGenOperationResult();
        result.setWholeErrorCode(0);
        ArrayList<TEGenValueResult> resultList = new ArrayList<TEGenValueResult>();
        result.setGenResultList(resultList);
        result.setErrorInfo(null);
        if (0 != errorCode) {
            TEGenValueResult curResult = new TEGenValueResult();
            curResult.errorCode = errorCode;
            resultList.add(curResult);
            result.setWholeErrorCode(2);
        }
        return result;
    }

    private boolean isTL1Device(TENE ne) {
        return 1 == ne.getIsTL1OrQX();
    }

    static {
        convertServiceTypeMap.put(32778, 16389);
        convertServiceTypeMap.put(10755, 34104);
        convertServiceTypeMap.put(10764, 34105);
        convertServiceTypeMap.put(10800, 34102);
        convertServiceTypeMap.put(10944, 34106);
        convertServiceTypeMap.put(11520, 34107);
    }
}

