/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.trane2e.servicetype;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_common.QAsnPortIndexList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnGetOTNServiceRangeReq;
import com.huawei.network.qasn.m_q_inventory_port.QAsnGetOTNServiceRangeRsp;
import com.huawei.network.qasn.m_q_inventory_port.QAsnOTNPathServiceRange;
import com.huawei.network.qasn.m_q_inventory_port.QAsnOTNPathServiceRangeList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnOTNPortServiceRange;
import com.huawei.network.qasn.m_q_inventory_port.QAsnOTNPortServiceRangeList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.neadapter.TENEFuntionAdapterMgr;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMPathSrvRangeObj;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMPortSrvRangeObj;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMServiceTypeListAdapterIF;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMSrvRangeKey;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMSrvRangeResult;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetOTNServiceRangeHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getNormalLogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        QAsnGetOTNServiceRangeReq req = (QAsnGetOTNServiceRangeReq)qReq;
        QAsnGetOTNServiceRangeRsp rsp = (QAsnGetOTNServiceRangeRsp)qRsp;
        long globalTimeBegin = System.currentTimeMillis();
        QAsnPortIndexList portIndexList = req.portList;
        if (null == portIndexList || portIndexList.isEmpty()) {
            rsp.errInfo.result = 0;
            return 0;
        }
        List<WDMSrvRangeKey> srvRangeKeyList = this.constructKeyList(portIndexList);
        TIntObjectHashMap<List<WDMSrvRangeKey>> rangeKeyMap = this.getRangeKeyMap(srvRangeKeyList);
        int[] neIDArr = rangeKeyMap.keys();
        WDMSrvRangeResult result = null;
        List tempRangeKeyList = null;
        int len = neIDArr.length;
        for (int i = 0; i < len; ++i) {
            tempRangeKeyList = (List)rangeKeyMap.get(neIDArr[i]);
            if (null == tempRangeKeyList || tempRangeKeyList.isEmpty()) continue;
            result = this.getServiceRange(tempRangeKeyList);
            this.constructRsp(rsp, result);
        }
        this.constructGlobalErrCode(rsp);
        e2eLogger.info("Get rsp success! size: " + rsp.portServiceRangeList.size());
        long globalTimeEnd = System.currentTimeMillis();
        TEGetOTNServiceRangeHandler.debug((String)"global time: ", (long)globalTimeBegin, (long)globalTimeEnd, (boolean)true);
        return 0;
    }

    private void constructGlobalErrCode(QAsnGetOTNServiceRangeRsp rsp) {
        if (1 == rsp.errInfo.result && rsp.portServiceRangeList.isEmpty()) {
            rsp.errInfo.result = 1090650122;
        }
    }

    private TIntObjectHashMap<List<WDMSrvRangeKey>> getRangeKeyMap(List<WDMSrvRangeKey> srvRangeKeyList) {
        TIntObjectHashMap rangeKeyMap = new TIntObjectHashMap();
        if (null != srvRangeKeyList) {
            int neID = -1;
            ArrayList<WDMSrvRangeKey> rangeKeyList = null;
            for (WDMSrvRangeKey rangeKey : srvRangeKeyList) {
                if (null == rangeKey) continue;
                neID = rangeKey.getNeID();
                rangeKeyList = (ArrayList<WDMSrvRangeKey>)rangeKeyMap.get(neID);
                if (null == rangeKeyList) {
                    rangeKeyList = new ArrayList<WDMSrvRangeKey>();
                    rangeKeyMap.put(neID, rangeKeyList);
                }
                rangeKeyList.add(rangeKey);
            }
        }
        return rangeKeyMap;
    }

    private List<WDMSrvRangeKey> constructKeyList(QAsnPortIndexList portIndexList) {
        ArrayList<WDMSrvRangeKey> keyList = new ArrayList<WDMSrvRangeKey>();
        QAsnPortIndex portIndex = null;
        WDMSrvRangeKey rangeKey = null;
        int cnemgrSlotID = -1;
        int len = portIndexList.size();
        for (int i = 0; i < len; ++i) {
            portIndex = (QAsnPortIndex)portIndexList.get(i);
            cnemgrSlotID = TEBoardUtil.neToSlotIDNM((int)TEBoardUtil.convertShelfID((Integer)portIndex.shelfID), (int)portIndex.slotID);
            rangeKey = new WDMSrvRangeKey();
            rangeKey.setOneID(portIndex.oneID);
            rangeKey.setNeID(portIndex.neID);
            rangeKey.setSlotid(cnemgrSlotID);
            rangeKey.setPortid(portIndex.portID);
            keyList.add(rangeKey);
        }
        return keyList;
    }

    private WDMSrvRangeResult getServiceRange(List<WDMSrvRangeKey> srvRangeKeyList) {
        if (null == srvRangeKeyList || srvRangeKeyList.isEmpty()) {
            return new WDMSrvRangeResult();
        }
        WDMSrvRangeKey key = srvRangeKeyList.get(0);
        WDMServiceTypeListAdapterIF adpater = this.getApater(key.getNeID());
        if (adpater == null) {
            e2eLogger.error("Cannot find NEFunctionAdapterInterface for " + key.getNeID());
            return new WDMSrvRangeResult();
        }
        return adpater.getWDMServiceTypeList(srvRangeKeyList);
    }

    private WDMServiceTypeListAdapterIF getApater(int neID) {
        WDMServiceTypeListAdapterIF adpater = null;
        TENEFuntionAdapterMgr adapterMgr = TENEFuntionAdapterMgr.getInstance();
        String adapterName = WDMServiceTypeListAdapterIF.class.getName();
        adpater = (WDMServiceTypeListAdapterIF)adapterMgr.findFunctionInterface(neID, adapterName);
        return adpater;
    }

    private void constructRsp(QAsnGetOTNServiceRangeRsp rsp, WDMSrvRangeResult result) {
        this.constructRspError(rsp, result.getErrInfoReturn());
        rsp.portServiceRangeList.addAll((Collection)this.constructRspRange(result.getPortSrvRangeObjList()));
    }

    private void constructRspError(QAsnGetOTNServiceRangeRsp rsp, TEErrInfoReturn errInfoReturn) {
        int retCode = errInfoReturn.getResult();
        if (0 != retCode) {
            rsp.errInfo.result = 1;
        }
        if (null == rsp.errInfo.errList) {
            rsp.errInfo.errList = new QAsnErrInfoList();
        }
        rsp.errInfo.errList.addAll((Collection)this.constructErrList(errInfoReturn.getErrList()));
    }

    private QAsnOTNPortServiceRangeList constructRspRange(List<WDMPortSrvRangeObj> serviceListObjList) {
        QAsnOTNPortServiceRangeList qRangeList = new QAsnOTNPortServiceRangeList();
        if (null != serviceListObjList) {
            QAsnOTNPortServiceRange qServiceRange = null;
            for (WDMPortSrvRangeObj portSrvRangeObj : serviceListObjList) {
                qServiceRange = new QAsnOTNPortServiceRange();
                qServiceRange.portIndex = this.cosntructPortIndex(portSrvRangeObj.getKey());
                qServiceRange.pathServiceRangeList.addAll((Collection)this.cosntructPathRange(portSrvRangeObj.getPortServiceRangeList()));
                qRangeList.add((Object)qServiceRange);
            }
        }
        return qRangeList;
    }

    private QAsnPortIndex cosntructPortIndex(WDMSrvRangeKey key) {
        QAsnPortIndex portIndex = new QAsnPortIndex();
        portIndex.oneID = key.getOneID();
        portIndex.neID = key.getNeID();
        portIndex.shelfID = TEBoardUtil.getRelativeShelfID((int)key.getSlotid());
        portIndex.slotID = TEBoardUtil.bigSlotToSmall((int)key.getSlotid());
        portIndex.portID = TEQueryPortForDataMgr.getAbstractPortID((int)key.getNeID(), (int)key.getPortid());
        return portIndex;
    }

    private QAsnOTNPathServiceRangeList cosntructPathRange(List<WDMPathSrvRangeObj> pathRangeList) {
        QAsnOTNPathServiceRangeList qRangeList = new QAsnOTNPathServiceRangeList();
        QAsnOTNPathServiceRange qRange = null;
        TIntArrayList pathRange = null;
        if (null == pathRangeList || pathRangeList.isEmpty()) {
            return qRangeList;
        }
        Iterator<WDMPathSrvRangeObj> iter = pathRangeList.iterator();
        WDMPathSrvRangeObj pathRangeObj = null;
        int pathID = -1;
        while (iter.hasNext()) {
            pathRangeObj = iter.next();
            qRange = new QAsnOTNPathServiceRange();
            pathID = pathRangeObj.getKey().getPathid();
            if (-1 == pathID || 0 == pathID) {
                pathID = 1;
            }
            qRange.pathID = pathID;
            pathRange = pathRangeObj.getPathServiceRangeList();
            if (null != pathRange) {
                int len = pathRange.size();
                for (int i = 0; i < len; ++i) {
                    qRange.supportServiceList.add((Object)pathRange.get(i));
                }
            }
            if (null == pathRange || pathRange.isEmpty()) continue;
            qRangeList.add((Object)qRange);
        }
        return qRangeList;
    }

    protected boolean isLogReq() {
        boolean isLog = false;
        return isLog;
    }

    protected boolean isLogRsp() {
        boolean isLog = false;
        return isLog;
    }
}

