/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stnelecable;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnAddDelStnEleCableMessageNtfToC;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnStnEleCable;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEStnEleCblAsnPOConverter;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEMarineStnEleCblDBOper {
    private static TEMarineStnEleCblDBOper oper = new TEMarineStnEleCblDBOper();
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TEMarineStnEleCblDBOper() {
    }

    public static TEMarineStnEleCblDBOper getInstance() {
        return oper;
    }

    public int queryStnEleCblByID(int eleCableID, TEMarineStnEleCablePO eleCable) {
        if (null == eleCable) {
            normalLogger.error("eleCable is null!");
            return 2;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID(TEMarineStnEleCablePO.class, this.getECableNVPairLst("EleCableID", String.valueOf(eleCableID)));
        }
        catch (Exception e) {
            normalLogger.error("Marine----Find A ECable in DataBase fail! Its id is " + eleCableID, (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        List objList = dbResult.getData();
        int retCode = dbResult.getResult();
        if (null == objList || objList.isEmpty()) {
            retCode = 1090615288;
        } else {
            TEMarineStnEleCablePO dbECable = (TEMarineStnEleCablePO)objList.get(0);
            eleCable.copyValuesFromOther(dbECable);
        }
        return retCode;
    }

    public int createStnEleCable(TEMarineStnEleCablePO eleCable) {
        if (null == eleCable) {
            normalLogger.error("eleCable is null!");
            return 2;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.create((Object)eleCable);
        }
        catch (Exception e) {
            normalLogger.error("Marine----Create A ECable in DataBase fail! Its id is " + eleCable.getEleCableID(), (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        List objList = dbResult.getData();
        if (null != objList && !objList.isEmpty()) {
            TEMarineStnEleCablePO dbECable = (TEMarineStnEleCablePO)objList.get(0);
            eleCable.copyValuesFromOther(dbECable);
        }
        return dbResult.getResult();
    }

    public int deleteStnEleCable(int eleCableID) {
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.deleteByID(TEMarineStnEleCablePO.class, this.getECableNVPairLst("EleCableID", String.valueOf(eleCableID)));
        }
        catch (Exception e) {
            normalLogger.error("Marine----Delete A ECable in DataBase fail! Its id is " + eleCableID, (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        return dbResult.getResult();
    }

    public int setStnEleCable(TEMarineStnEleCablePO eleCable) {
        if (null == eleCable) {
            normalLogger.error("eleCable is null!");
            return 2;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.update((Object)eleCable);
        }
        catch (Exception e) {
            normalLogger.error("Marine----Modify A ECable in DataBase fail! Its id is " + eleCable.getEleCableID(), (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        return dbResult.getResult();
    }

    public int getStnEleCblsByStnID(int stationID, List<TEMarineStnEleCablePO> stnEleCableList) {
        if (null == stnEleCableList) {
            return 2;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findByID(TEMarineStnEleCablePO.class, this.getECableNVPairLst("StationID", String.valueOf(stationID)));
        }
        catch (Exception e) {
            normalLogger.error("Marine----Find ECables by station id in DataBase fail! stationID is " + stationID, (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        List objList = dbResult.getData();
        if (null != objList && !objList.isEmpty()) {
            int lstLen = objList.size();
            for (int i = 0; i < lstLen; ++i) {
                TEMarineStnEleCablePO dbECable = (TEMarineStnEleCablePO)objList.get(i);
                stnEleCableList.add(dbECable);
            }
        }
        return dbResult.getResult();
    }

    public int getAllStnEleCbls(List<TEMarineStnEleCablePO> stnECableList) {
        if (null == stnECableList) {
            return 2;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll(TEMarineStnEleCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error("Marine----Find all ECables in DataBase fail! ", (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        List objList = dbResult.getData();
        if (null != objList && !objList.isEmpty()) {
            int lstLen = objList.size();
            for (int i = 0; i < lstLen; ++i) {
                TEMarineStnEleCablePO dbECable = (TEMarineStnEleCablePO)objList.get(i);
                stnECableList.add(dbECable);
            }
        }
        Collections.sort(stnECableList);
        return dbResult.getResult();
    }

    private List<TEDaoNameValuePair> getECableNVPairLst(String name, String value) {
        ArrayList<TEDaoNameValuePair> pairList = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair nvPair = new TEDaoNameValuePair();
        nvPair.setName(name);
        nvPair.setValue(value);
        pairList.add(nvPair);
        return pairList;
    }

    public void delECableByPFENEIDSet(Set<Integer> delPFENEIDSet, boolean isSendMsg, int stnID) {
        if (null == delPFENEIDSet || delPFENEIDSet.isEmpty()) {
            normalLogger.debug("delPFENEIDSet is null or is empty!");
            return;
        }
        ArrayList<TEMarineStnEleCablePO> stnECableList = new ArrayList<TEMarineStnEleCablePO>();
        int retCode = this.getAllStnEleCbls(stnECableList);
        if (0 == retCode && !stnECableList.isEmpty()) {
            HashSet<Integer> delECableIDSet = new HashSet<Integer>();
            for (TEMarineStnEleCablePO eCable : stnECableList) {
                if (!delPFENEIDSet.contains((int)eCable.getSrcNEID()) && !delPFENEIDSet.contains((int)eCable.getDstNEID())) continue;
                delECableIDSet.add(eCable.getEleCableID());
            }
            retCode = this.delStnECables(delECableIDSet);
            if (isSendMsg && 0 == retCode) {
                this.sendMessages(delECableIDSet, stnID);
            }
        }
    }

    public int delStnECables(Set<Integer> delECableIDSet) {
        if (null == delECableIDSet || delECableIDSet.isEmpty()) {
            normalLogger.debug("delECableIDSet is null or is empty! can not delete station ecable");
            return 0;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.deleteByID(TEMarineStnEleCablePO.class, this.getECablesNVPairLst("EleCableID", delECableIDSet));
        }
        catch (Exception e) {
            normalLogger.error("Marine----Find ECables by station id in DataBase fail!", (Throwable)e);
            return 1092743443;
        }
        if (null == dbResult) {
            normalLogger.error("Marine----dbResult is null!");
            return 1092743443;
        }
        return dbResult.getResult();
    }

    private List<TEDaoNameValuePair> getECablesNVPairLst(String name, Set<Integer> delECableIDSet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        for (int delECableID : delECableIDSet) {
            criteria.add(new TEDaoNameValuePair(name, String.valueOf(delECableID)));
        }
        return criteria;
    }

    private void sendMessages(Set<Integer> delECableIDSet, int stnID) {
        if (null == delECableIDSet || delECableIDSet.isEmpty()) {
            return;
        }
        for (int eCableID : delECableIDSet) {
            this.sendDelECableMsgToClient(eCableID, stnID);
        }
    }

    private void sendDelECableMsgToClient(int eCableID, int stationID) {
        AsnAddDelStnEleCableMessageNtfToC msg = new AsnAddDelStnEleCableMessageNtfToC();
        msg.operType = BigInteger.valueOf(0L);
        msg.stationID = BigInteger.valueOf(stationID);
        msg.eleCableID = BigInteger.valueOf(eCableID);
        TEASN1CommMgr.sendEventClient((FStruct)msg, (int)2180479);
    }

    public void sendMessageToClient(TEMarineStnEleCablePO eCable) {
        AsnStnEleCable asnECable = TEStnEleCblAsnPOConverter.getInstance().convertToAsn(eCable);
        AsnAddDelStnEleCableMessageNtfToC msg = new AsnAddDelStnEleCableMessageNtfToC();
        msg.operType = BigInteger.valueOf(1L);
        msg.stationID = BigInteger.valueOf(eCable.getStationID());
        msg.eleCableID = BigInteger.valueOf(eCable.getEleCableID());
        msg.stnEleCable = asnECable;
        TEASN1CommMgr.sendEventClient((FStruct)msg, (int)2180479);
    }

    public TEMarineStnEleCablePO getStnECableByNodeName(String nodeName) {
        if (null == nodeName || nodeName.equals("")) {
            TELogFactory.getNormalLogger().error("pfeName is null of is empty!");
            return null;
        }
        ArrayList<TEMarineStnEleCablePO> stnECableList = new ArrayList<TEMarineStnEleCablePO>();
        int retcode = this.getAllStnEleCbls(stnECableList);
        TEMarineStnEleCablePO eCable = null;
        if (0 == retcode) {
            for (TEMarineStnEleCablePO vECable : stnECableList) {
                if (!vECable.getSrcNEName().equals(nodeName) && !vECable.getDstNEName().equals(nodeName)) continue;
                eCable = vECable;
                break;
            }
        } else {
            TELogFactory.getNormalLogger().info("there is no stnecable! the retcode is " + retcode);
        }
        return eCable;
    }
}

