/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stnelecable;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.e2e.script.TEMarineScriptUtil;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineStationGetter;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineStnECableScriptHandler
implements TEScriptHandler {
    private static final int TE_ERR_MARINE_STATION_NOT_EXIST = 1090615308;
    private static final int TE_ERR_MARINE_STNECABLESRC_NOT_EXIST = 1090615309;
    private static final int TE_ERR_MARINE_STNECABLEDST_NOT_EXIST = 1090615310;
    private static final int TE_ERR_MARINE_SAME_STNECABLE_EXIST = 1090615311;
    private static final String ELECABLEID = "elecableid";
    private static final String STATIONNAME = "stationname";
    private static final String ELECABLENAME = "elecablename";
    private static final String ELECABLEMEMO = "elecablememo";
    private static final String SRCONEID = "srconeid";
    private static final String SRCNEID = "srcneid";
    private static final String SRCNENAME = "srcnename";
    private static final String DSTONEID = "dstoneid";
    private static final String DSTNEID = "dstneid";
    private static final String DSTNENAME = "dstnename";
    private static final String LENGTH = "length";
    private static final String RESISTANCE = "resistance";
    private static final String BUILDPERSON = "buildperson";
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TEMarineStnEleCablePO> eCableList = new ArrayList<TEMarineStnEleCablePO>();

    public int doExport(int neID, int item) {
        normalLogger.debug("Export station elec cable is start!");
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (!TENEListMgr.getInstance().isAddedNE(neID) || null == ne) {
            normalLogger.debug("the ne is not exist or the status of ne is not added!");
            return 0;
        }
        int nePhyType = ne.getNEType();
        if (!TEMarineScriptUtil.isMarineDevice(nePhyType)) {
            normalLogger.debug("The ne is not a type of marine ne!");
            return 1090613252;
        }
        ArrayList<TEMarineStnEleCablePO> stnECableList = new ArrayList<TEMarineStnEleCablePO>();
        int retCode = TEMarineStnEleCblDBOper.getInstance().getAllStnEleCbls(stnECableList);
        if (stnECableList.isEmpty() || 0 != retCode) {
            normalLogger.debug("Getting stnEleCable fail or the stnEleCableList is empty!");
            return retCode;
        }
        TEMarineStationGetter stnGetter = new TEMarineStationGetter();
        for (TEMarineStnEleCablePO stnECable : stnECableList) {
            TEScriptCmd cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            cmd.addPara(ELECABLEID, stnECable.getEleCableID(), false, true);
            TEMarineStationPO tmpStn = stnGetter.getStationByID(stnECable.getStationID());
            if (null == tmpStn) continue;
            cmd.addPara(STATIONNAME, tmpStn.getName(), true, true);
            cmd.addPara(ELECABLENAME, stnECable.getEleCableName(), true, true);
            cmd.addPara(ELECABLEMEMO, stnECable.getEleCableMemo(), true, true);
            cmd.addPara(SRCONEID, stnECable.getSrcOneID(), false, true);
            cmd.addPara(SRCNEID, (int)stnECable.getSrcNEID(), false, true);
            cmd.addPara(SRCNENAME, stnECable.getSrcNEName(), true, true);
            cmd.addPara(DSTONEID, stnECable.getDstOneID(), false, true);
            cmd.addPara(DSTNEID, (int)stnECable.getDstNEID(), false, true);
            cmd.addPara(DSTNENAME, stnECable.getDstNEName(), true, true);
            cmd.addPara(LENGTH, stnECable.getLength(), false, true);
            cmd.addPara(RESISTANCE, stnECable.getResistance(), false, true);
            cmd.addPara(BUILDPERSON, stnECable.getBuildPerson(), true, true);
            retCode = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
            if (0 == retCode) continue;
            break;
        }
        normalLogger.debug("Export station elec cable is end! retCode is " + retCode);
        return retCode;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        TELogFactory.getNormalLogger().debug("TEMarineStnECableScriptHandler.doImport() start!");
        if (null == contents || contents.isEmpty()) {
            TELogFactory.getNormalLogger().debug("TEMarineStnECableScriptHandler.doImport() is end! Because contents is null or empty!");
            return 0;
        }
        int retCode = 0;
        TEMarineStationGetter stnGetter = new TEMarineStationGetter();
        ArrayList tl = new ArrayList();
        for (TEScriptCmd cmd : contents) {
            tl.clear();
            TEMarineStnEleCablePO eCable = new TEMarineStnEleCablePO();
            cmd.getPara(ELECABLEID, tl, false);
            eCable.setEleCableID(this.calcECableID());
            tl.clear();
            cmd.getPara(STATIONNAME, tl, false);
            String stnName = (String)tl.get(0);
            TEMarineStationPO tmpStn = stnGetter.getStationByName(stnName);
            if (null == tmpStn) {
                retCode = 1090615308;
                break;
            }
            eCable.setStationID(tmpStn.getStationID());
            tl.clear();
            cmd.getPara(ELECABLENAME, tl, false);
            eCable.setEleCableName((String)tl.get(0));
            tl.clear();
            cmd.getPara(ELECABLEMEMO, tl, false);
            eCable.setEleCableMemo((String)tl.get(0));
            tl.clear();
            cmd.getPara(SRCONEID, tl, false);
            eCable.setSrcOneID(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(SRCNEID, tl, false);
            eCable.setSrcNEID((long)Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(SRCNENAME, tl, false);
            eCable.setSrcNEName((String)tl.get(0));
            tl.clear();
            cmd.getPara(DSTONEID, tl, false);
            eCable.setDstOneID(Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(DSTNEID, tl, false);
            eCable.setDstNEID((long)Integer.valueOf((String)tl.get(0)).intValue());
            tl.clear();
            cmd.getPara(DSTNENAME, tl, false);
            eCable.setDstNEName((String)tl.get(0));
            tl.clear();
            cmd.getPara(LENGTH, tl, false);
            eCable.setLength((String)tl.get(0));
            tl.clear();
            cmd.getPara(RESISTANCE, tl, false);
            eCable.setResistance((String)tl.get(0));
            tl.clear();
            cmd.getPara(BUILDPERSON, tl, false);
            eCable.setBuildPerson((String)tl.get(0));
            retCode = this.checkECable(eCable, tmpStn);
            if (0 != retCode) break;
            retCode = TEMarineStnEleCblDBOper.getInstance().createStnEleCable(eCable);
            if (0 != retCode) continue;
            this.eCableList.add(eCable);
            TEMarineStnEleCblDBOper.getInstance().sendMessageToClient(eCable);
        }
        TELogFactory.getNormalLogger().debug("TEMarineStnECableScriptHandler.doImport() end! retCode is " + retCode);
        return retCode;
    }

    private int checkECable(TEMarineStnEleCablePO stnECable, TEMarineStationPO stn) {
        int retCode = this.checkStationInfo(stnECable, stn);
        if (0 == retCode) {
            retCode = this.checkECableInfo(stnECable);
        }
        return retCode;
    }

    private int checkStationInfo(TEMarineStnEleCablePO stnECable, TEMarineStationPO station) {
        boolean isSrcExist;
        TEMarineStationGetter stnGetter = new TEMarineStationGetter();
        int retCode = 0;
        String srcNEName = stnECable.getSrcNEName();
        int srcID = (int)stnECable.getSrcNEID();
        if (0 == srcID) {
            isSrcExist = stnGetter.isSTNContainCTB(station, srcNEName);
            retCode = isSrcExist ? retCode : 1090615309;
        } else {
            TENE ne = TENEListMgr.getInstance().getNEByNEName(srcNEName);
            if (null == ne) {
                retCode = 1090615309;
                isSrcExist = false;
            } else {
                srcID = ne.getNEID();
                stnECable.setSrcNEID((long)srcID);
                isSrcExist = stnGetter.isStnContainNe(station, srcID);
                int n = retCode = isSrcExist ? retCode : 1090615309;
            }
        }
        if (!isSrcExist) {
            return retCode;
        }
        String dstNEName = stnECable.getDstNEName();
        int dstID = (int)stnECable.getDstNEID();
        boolean isDstExist = true;
        if (0 == dstID) {
            isDstExist = stnGetter.isSTNContainCTB(station, dstNEName);
            retCode = isDstExist ? retCode : 1090615310;
        } else {
            TENE ne = TENEListMgr.getInstance().getNEByNEName(dstNEName);
            if (null == ne) {
                retCode = 1090615310;
                isDstExist = false;
            } else {
                dstID = ne.getNEID();
                stnECable.setDstNEID((long)dstID);
                isDstExist = stnGetter.isStnContainNe(station, dstID);
                retCode = isDstExist ? retCode : 1090615310;
            }
        }
        return retCode;
    }

    private int checkECableInfo(TEMarineStnEleCablePO stnECable) {
        ArrayList<TEMarineStnEleCablePO> eCableList = new ArrayList<TEMarineStnEleCablePO>();
        int retCode = TEMarineStnEleCblDBOper.getInstance().getAllStnEleCbls(eCableList);
        if (0 == retCode) {
            int n = retCode = this.isECableIsExist(eCableList, stnECable) ? 1090615311 : 0;
        }
        if (0 == retCode && this.isUsedInfo(stnECable, eCableList)) {
            retCode = 1090615286;
        }
        return retCode;
    }

    private boolean isECableIsExist(List<TEMarineStnEleCablePO> eCableLst, TEMarineStnEleCablePO eCable) {
        if (eCableLst.isEmpty()) {
            return false;
        }
        for (TEMarineStnEleCablePO aECable : eCableLst) {
            if (aECable.getEleCableID() != eCable.getEleCableID() && !aECable.getEleCableName().equals(eCable.getEleCableName())) continue;
            return true;
        }
        return false;
    }

    private boolean isUsedInfo(TEMarineStnEleCablePO newCable, List<TEMarineStnEleCablePO> eCableList) {
        if (eCableList.isEmpty()) {
            return false;
        }
        for (TEMarineStnEleCablePO cable : eCableList) {
            if (!(cable.getSrcNEID() == newCable.getSrcNEID() && cable.getSrcNEName().equals(newCable.getSrcNEName()) || cable.getDstNEID() == newCable.getSrcNEID() && cable.getDstNEName().equals(newCable.getSrcNEName()) || cable.getSrcNEID() == newCable.getDstNEID() && cable.getSrcNEName().equals(newCable.getDstNEName())) && (cable.getDstNEID() != newCable.getDstNEID() || !cable.getDstNEName().equals(newCable.getDstNEName()))) continue;
            return true;
        }
        return false;
    }

    private int calcECableID() {
        if (this.eCableList.isEmpty()) {
            TEMarineStnEleCblDBOper.getInstance().getAllStnEleCbls(this.eCableList);
        }
        boolean START_ECABLE_ID = true;
        if (this.eCableList.isEmpty()) {
            return 1;
        }
        if (1 == this.eCableList.size()) {
            int cableID = this.eCableList.get(0).getEleCableID();
            return 1 == cableID ? cableID + 1 : 1;
        }
        TEMarineStnEleCablePO preCable = null;
        int eCblLen = this.eCableList.size();
        for (int i = 0; i < eCblLen; ++i) {
            TEMarineStnEleCablePO cable = this.eCableList.get(i);
            if (null == preCable) {
                preCable = cable;
                continue;
            }
            int diff = cable.getEleCableID() - preCable.getEleCableID();
            if (diff > 1) {
                return preCable.getEleCableID() + 1;
            }
            preCable = cable;
        }
        return preCable.getEleCableID() + 1;
    }
}

