/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stnelecable;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnQueryStnEleCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnQueryStnEleCableRsp;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEStnEleCblAsnPOConverter;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EConstants;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineQueryStnEleCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private static String QUERY_STNECABLE_RES = "QUERY_STNECABLE";
    private static int retCode = 0;

    public int handleRequest(AsnQueryStnEleCableReq req, AsnQueryStnEleCableRsp rsp, TaskMgr tm, TETaskInfo info) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        int stnEleCableID = req.eleCableID.intValue();
        TEMarineStnEleCablePO stnEleCable = this.getStnEleCableByID(stnEleCableID);
        if (0 == retCode) {
            rsp.result.isSuccess = true;
            rsp.stnEleCable = TEStnEleCblAsnPOConverter.getInstance().convertToAsn(stnEleCable);
        } else {
            rsp.result.isSuccess = false;
        }
        rsp.result.setRetCode(retCode);
        this.writeLog(req, rsp, info);
        normalLogger.info("TEMarineQueryStnEleCableHandler is end. The result code is " + retCode);
        return 0;
    }

    private TEMarineStnEleCablePO getStnEleCableByID(int stnEleCableID) {
        TEMarineStnEleCablePO stnEleCable = new TEMarineStnEleCablePO();
        TEMarineStnEleCblDBOper oper = TEMarineStnEleCblDBOper.getInstance();
        retCode = oper.queryStnEleCblByID(stnEleCableID, stnEleCable);
        normalLogger.debug("The result of query stnEleCable by ID is " + retCode);
        return stnEleCable;
    }

    private void writeLog(AsnQueryStnEleCableReq req, AsnQueryStnEleCableRsp rsp, TETaskInfo info) {
        List<TEMarineLogInfo> logInfoLst = this.getLogInfo(req, rsp, info);
        TEMarineLogMgrUtil.writeLog(req.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoLst);
    }

    private List<TEMarineLogInfo> getLogInfo(AsnQueryStnEleCableReq req, AsnQueryStnEleCableRsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineE2EConstants.LOGRES;
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setErrCode(rsp.result.retCode.intValue());
        logInfo.setResult(rsp.result.retCode.intValue());
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)rsp.result.retCode.intValue()));
        logInfo.setOperateName(res.getString(QUERY_STNECABLE_RES));
        logInfo.setOperateObject(res.getString(QUERY_STNECABLE_RES));
        logInfo.setOperateDesc(res.getString(QUERY_STNECABLE_RES));
        logInfoList.add(logInfo);
        return logInfoList;
    }
}

