/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stnelecable;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnAddDelStnEleCableMessageNtfToC;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnSetStnEleCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnSetStnEleCableRsp;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnStnEleCable;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEStnEleCblAsnPOConverter;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EConstants;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEMarineCreateStnEleCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(AsnSetStnEleCableReq req, AsnSetStnEleCableRsp rsp, TaskMgr tm, TETaskInfo info) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        TEMarineStnEleCablePO eCable = TEStnEleCblAsnPOConverter.getInstance().convertToPO(req.stnEleCable);
        ArrayList<TEMarineStnEleCablePO> eCableList = new ArrayList<TEMarineStnEleCablePO>();
        int retCode = TEMarineStnEleCblDBOper.getInstance().getAllStnEleCbls(eCableList);
        if (this.isUsedInfo(eCable, eCableList)) {
            retCode = 1090615286;
        } else {
            int newECableID = this.getAvailNewID(eCableList);
            eCable.setEleCableID(newECableID);
            retCode = TEMarineStnEleCblDBOper.getInstance().createStnEleCable(eCable);
        }
        if (0 == retCode) {
            rsp.result.isSuccess = true;
            rsp.eleCableID = BigInteger.valueOf(eCable.getEleCableID());
            this.sendMessageToClient(eCable);
        } else {
            rsp.eleCableID = BigInteger.valueOf(0L);
            rsp.result.isSuccess = false;
        }
        rsp.result.setRetCode(retCode);
        this.writeLog(req, rsp, info);
        normalLogger.info("TEMarineCreateStnEleCableHandler is end. The result code is " + retCode);
        return 0;
    }

    private boolean isUsedInfo(TEMarineStnEleCablePO newCable, List<TEMarineStnEleCablePO> eCableList) {
        if (eCableList.isEmpty()) {
            return false;
        }
        int eCblLen = eCableList.size();
        for (int i = 0; i < eCblLen; ++i) {
            TEMarineStnEleCablePO cable = eCableList.get(i);
            if (!(cable.getSrcNEID() == newCable.getSrcNEID() && cable.getSrcNEName().equals(newCable.getSrcNEName()) || cable.getDstNEID() == newCable.getSrcNEID() && cable.getDstNEName().equals(newCable.getSrcNEName()) || cable.getSrcNEID() == newCable.getDstNEID() && cable.getSrcNEName().equals(newCable.getDstNEName())) && (cable.getDstNEID() != newCable.getDstNEID() || !cable.getDstNEName().equals(newCable.getDstNEName()))) continue;
            return true;
        }
        return false;
    }

    private int getAvailNewID(List<TEMarineStnEleCablePO> eCableList) {
        boolean START_ECABLE_ID = true;
        if (eCableList.isEmpty()) {
            return 1;
        }
        if (1 == eCableList.size()) {
            int cableID = eCableList.get(0).getEleCableID();
            return 1 == cableID ? cableID + 1 : 1;
        }
        TEMarineStnEleCablePO preCable = null;
        int eCblLen = eCableList.size();
        for (int i = 0; i < eCblLen; ++i) {
            TEMarineStnEleCablePO cable = eCableList.get(i);
            if (null == preCable) {
                preCable = cable;
                continue;
            }
            int diff = cable.getEleCableID() - preCable.getEleCableID();
            if (diff > 1) {
                return preCable.getEleCableID() + 1;
            }
            preCable = cable;
        }
        return preCable.getEleCableID() + 1;
    }

    private void sendMessageToClient(TEMarineStnEleCablePO eCable) {
        AsnStnEleCable asnECable = TEStnEleCblAsnPOConverter.getInstance().convertToAsn(eCable);
        AsnAddDelStnEleCableMessageNtfToC msg = new AsnAddDelStnEleCableMessageNtfToC();
        msg.operType = BigInteger.valueOf(1L);
        msg.stationID = BigInteger.valueOf(eCable.getStationID());
        msg.eleCableID = BigInteger.valueOf(eCable.getEleCableID());
        msg.stnEleCable = asnECable;
        TEASN1CommMgr.sendEventClient((FStruct)msg, (int)2180479);
    }

    private void writeLog(AsnSetStnEleCableReq req, AsnSetStnEleCableRsp rsp, TETaskInfo info) {
        List<TEMarineLogInfo> logInfoLst = this.getLogInfo(req, rsp, info);
        TEMarineLogMgrUtil.writeLog(req.userID.intValue(), TopoUtility.ipToString((long)info.getMsgHead().senderProcIP), logInfoLst);
    }

    private List<TEMarineLogInfo> getLogInfo(AsnSetStnEleCableReq req, AsnSetStnEleCableRsp rsp, TETaskInfo info) {
        TEResourceUtil res = TEMarineE2EConstants.LOGRES;
        ArrayList<TEMarineLogInfo> logInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo logInfo = new TEMarineLogInfo();
        logInfo.setCmdID(info.getMsgHead().cmdCode);
        logInfo.setErrCode(rsp.result.retCode.intValue());
        logInfo.setResult(rsp.result.retCode.intValue());
        logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)rsp.result.retCode.intValue()));
        String create_res = res.getString("CREATE_STNECABLE");
        logInfo.setOperateName(create_res);
        logInfo.setOperateObject(create_res);
        logInfo.setOperateDesc(res.getString("STNECABLE_NAME") + ":" + new String(req.stnEleCable.eleCableName));
        logInfoList.add(logInfo);
        return logInfoList;
    }
}

