/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.e2e.stationviewmgr;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEndCable;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineEndCableList;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQueryEndCableReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnMarineQueryEndCableRsp;
import com.huawei.nglct.nemgr.marine.e2e.stationviewmgr.TEMarineCTBPortUpdateHandler;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;

public class TEMarineQueryEndCableHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    public int handleRequest(AsnMarineQueryEndCableReq req, AsnMarineQueryEndCableRsp rsp, TaskMgr tm) {
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        TEDaoOperationResult dbResult = null;
        int stnID = req.stationID.intValue();
        try {
            dbResult = TECommonDaoService.findAll(TEMarineEndCablePO.class);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            return 2;
        }
        if (null == dbResult) {
            normalLogger.error("The dbResult is null!");
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(1092743443);
            return 2;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            rsp.stationID = BigInteger.valueOf(stnID);
            AsnMarineEndCableList marineEndCableList = rsp.marineEndCableList;
            AsnMarineEndCable endCable = null;
            TEMarineEndCablePO tmpEndCablePO = null;
            List dataList = dbResult.getData();
            for (Object obj : dataList) {
                tmpEndCablePO = (TEMarineEndCablePO)obj;
                if (stnID != tmpEndCablePO.StationID) continue;
                endCable = this.convertEndCablePOToAsn(tmpEndCablePO);
                marineEndCableList.add((Object)endCable);
                this.updateCTBPortData(endCable);
            }
            rsp.result.isSuccess = true;
            rsp.result.setRetCode(retCode);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.setRetCode(retCode);
        }
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private void updateCTBPortData(AsnMarineEndCable endCable) {
        if (null == endCable) {
            return;
        }
        int ctbStnID = endCable.stnID.intValue();
        String ctbName = null;
        int portID = 0;
        if (0 == endCable.srcNEID.intValue()) {
            ctbName = new String(endCable.srcNEName);
            portID = endCable.srcPortID.intValue();
        } else {
            ctbName = new String(endCable.dstNEName);
            portID = endCable.dstPortID.intValue();
        }
        TEMarineCTBPortUpdateHandler.updateMarineCTBPort(ctbStnID, ctbName, portID, true);
    }

    private AsnMarineEndCable convertEndCablePOToAsn(TEMarineEndCablePO endCablePO) {
        if (null == endCablePO) {
            return null;
        }
        AsnMarineEndCable endCable = new AsnMarineEndCable();
        endCable.stnID = BigInteger.valueOf(endCablePO.StationID);
        endCable.fiberID = BigInteger.valueOf(endCablePO.EndCableID);
        endCable.linkType = BigInteger.valueOf(endCablePO.LinkType);
        endCable.name = endCablePO.EndCableName.getBytes();
        endCable.memo = endCablePO.EndCableMemo.getBytes();
        endCable.srcOneID = BigInteger.valueOf(endCablePO.SrcOneID);
        endCable.srcNEID = BigInteger.valueOf(endCablePO.SrcNEID);
        endCable.srcNEName = endCablePO.SrcNEName.getBytes();
        endCable.srcBoardID = BigInteger.valueOf(endCablePO.SrcBoardID);
        endCable.srcBoardName = endCablePO.SrcBoardName.getBytes();
        endCable.srcBoardType = BigInteger.valueOf(0L);
        endCable.srcPortID = BigInteger.valueOf(endCablePO.SrcPortID);
        endCable.srcPortName = endCablePO.SrcPortName.getBytes();
        endCable.dstOneID = BigInteger.valueOf(endCablePO.DstOneID);
        endCable.dstNEID = BigInteger.valueOf(endCablePO.DstNEID);
        endCable.dstNEName = endCablePO.DstNEName.getBytes();
        endCable.dstBoardID = BigInteger.valueOf(endCablePO.DstBoardID);
        endCable.dstBoardName = endCablePO.DstBoardName.getBytes();
        endCable.dstBoardType = BigInteger.valueOf(0L);
        endCable.dstPortID = BigInteger.valueOf(endCablePO.DstPortID);
        endCable.dstPortName = endCablePO.DstPortName.getBytes();
        endCable.dir = BigInteger.valueOf(endCablePO.Dir);
        endCable.length = endCablePO.Length.getBytes();
        endCable.buildPerson = endCablePO.BuildPerson.getBytes();
        endCable.maintainPerson = endCablePO.MaintainPerson.getBytes();
        return endCable;
    }
}

